/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.RecentProjectPanel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nullable;

public class NewRecentProjectPanel
extends RecentProjectPanel {
    public NewRecentProjectPanel(WelcomeScreen screen) {
        super(screen);
        ListWithFilter panel;
        this.setBorder(null);
        this.setBackground(FlatWelcomeFrame.getProjectsBackground());
        JScrollPane scrollPane = (JScrollPane)UIUtil.findComponentOfType((JComponent)this, JScrollPane.class);
        if (scrollPane != null) {
            scrollPane.setBackground(FlatWelcomeFrame.getProjectsBackground());
            scrollPane.setSize((Dimension)JBUI.size((int)245, (int)460));
            scrollPane.setMinimumSize((Dimension)JBUI.size((int)245, (int)460));
            scrollPane.setPreferredSize((Dimension)JBUI.size((int)245, (int)460));
        }
        if ((panel = (ListWithFilter)UIUtil.findComponentOfType((JComponent)this, ListWithFilter.class)) != null) {
            panel.setBackground(FlatWelcomeFrame.getProjectsBackground());
        }
    }

    @Override
    protected Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    protected JBList createList(AnAction[] recentProjectActions, Dimension size) {
        final JBList list = super.createList(recentProjectActions, size);
        list.setBackground(FlatWelcomeFrame.getProjectsBackground());
        list.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Component next;
                FocusTraversalPolicy policy;
                FlatWelcomeFrame frame;
                if (e.getKeyCode() == 39 && (frame = (FlatWelcomeFrame)UIUtil.getParentOfType(FlatWelcomeFrame.class, (Component)list)) != null && (policy = frame.getFocusTraversalPolicy()) != null && (next = policy.getComponentAfter(frame, (Component)list)) != null) {
                    next.requestFocus();
                }
            }
        });
        return list;
    }

    @Override
    protected ListCellRenderer createRenderer(UniqueNameBuilder<ReopenProjectAction> pathShortener) {
        return new RecentProjectPanel.RecentProjectItemRenderer(this.myPathShortener){
            private GridBagConstraints nameCell;
            private GridBagConstraints pathCell;
            private GridBagConstraints closeButtonCell;

            private void initConstraints() {
                this.nameCell = new GridBagConstraints();
                this.pathCell = new GridBagConstraints();
                this.closeButtonCell = new GridBagConstraints();
                this.nameCell.gridx = 0;
                this.nameCell.gridy = 0;
                this.nameCell.weightx = 1.0;
                this.nameCell.weighty = 1.0;
                this.nameCell.anchor = 23;
                this.nameCell.insets = JBUI.insets((int)6, (int)5, (int)1, (int)5);
                this.pathCell.gridx = 0;
                this.pathCell.gridy = 1;
                this.pathCell.insets = JBUI.insets((int)1, (int)5, (int)6, (int)5);
                this.pathCell.anchor = 25;
                this.closeButtonCell.gridx = 1;
                this.closeButtonCell.gridy = 0;
                this.closeButtonCell.anchor = 24;
                this.closeButtonCell.insets = JBUI.insets((int)7, (int)7, (int)7, (int)7);
                this.closeButtonCell.gridheight = 2;
            }

            @Override
            protected Color getListBackground(boolean isSelected, boolean hasFocus) {
                return isSelected ? FlatWelcomeFrame.getListSelectionColor(hasFocus) : FlatWelcomeFrame.getProjectsBackground();
            }

            @Override
            protected Color getListForeground(boolean isSelected, boolean hasFocus) {
                return UIUtil.getListForeground((isSelected && hasFocus ? 1 : 0) != 0);
            }

            @Override
            protected void layoutComponents() {
                this.setLayout(new GridBagLayout());
                this.initConstraints();
                this.add((Component)this.myName, this.nameCell);
                this.add((Component)this.myPath, this.pathCell);
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (Registry.is((String)"removable.welcome.screen.projects")) {
                    if (this.myHovered) {
                        this.add((Component)this.myCloseThisItem, this.closeButtonCell);
                        list.revalidate();
                    } else {
                        this.remove(this.myCloseThisItem);
                        list.revalidate();
                    }
                }
                return this;
            }
        };
    }

    @Override
    @Nullable
    protected JPanel createTitle() {
        return null;
    }
}

