/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsDetectorImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.WeakList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectableIndentOptionsProvider
extends FileIndentOptionsProvider {
    private boolean myIsEnabledInTest;
    private final List<VirtualFile> myAcceptedFiles = new WeakList();

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/codeStyle/autodetect/DetectableIndentOptionsProvider", "getIndentOptions"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/DetectableIndentOptionsProvider", "getIndentOptions"));
        }
        return this.isEnabled(settings, file) ? new IndentOptionsDetectorImpl(file).getIndentOptions() : null;
    }

    public boolean useOnFullReformat() {
        return false;
    }

    public void setEnabledInTest(boolean isEnabledInTest) {
        this.myIsEnabledInTest = isEnabledInTest;
    }

    private boolean isEnabled(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/codeStyle/autodetect/DetectableIndentOptionsProvider", "isEnabled"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/DetectableIndentOptionsProvider", "isEnabled"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myIsEnabledInTest;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null || vFile instanceof LightVirtualFile) {
            return false;
        }
        return settings.AUTODETECT_INDENTS;
    }

    @Nullable
    public static DetectableIndentOptionsProvider getInstance() {
        return (DetectableIndentOptionsProvider)((Object)FileIndentOptionsProvider.EP_NAME.findExtension(DetectableIndentOptionsProvider.class));
    }

    @Nullable
    public String getDisplayName() {
        return ApplicationBundle.message((String)"code.style.indents.detector.display.name", (Object[])new Object[0]);
    }

    public boolean canBeDisabled() {
        return true;
    }

    public void disable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/codeStyle/autodetect/DetectableIndentOptionsProvider", "disable"));
        }
        CodeStyleSettingsManager.getSettings((Project)project).AUTODETECT_INDENTS = false;
        this.myAcceptedFiles.clear();
    }

    public void setAccepted(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/DetectableIndentOptionsProvider", "setAccepted"));
        }
        this.myAcceptedFiles.add(file);
    }

    public boolean isAcceptedWithoutWarning(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/DetectableIndentOptionsProvider", "isAcceptedWithoutWarning"));
        }
        return this.myAcceptedFiles.contains(file);
    }
}

