/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.impl.smartPointers.AnchorElementInfoFactory;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnchorElementInfo
extends SelfElementInfo {
    private int stubId;
    private IStubElementType myStubElementType;

    AnchorElementInfo(@NotNull PsiElement anchor, @NotNull PsiFile containingFile) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        super(containingFile.getProject(), ProperTextRange.create((Segment)anchor.getTextRange()), anchor.getClass(), containingFile, LanguageUtil.getRootLanguage((PsiElement)anchor));
        assert (!(anchor instanceof PsiFile)) : "FileElementInfo must be used for file: " + anchor;
        this.stubId = -1;
    }

    AnchorElementInfo(@NotNull PsiElement anchor, @NotNull PsiFileWithStubSupport containingFile, int stubId, @NotNull IStubElementType stubElementType) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (stubElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubElementType", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        super(containingFile.getProject(), new ProperTextRange(0, 0), anchor.getClass(), containingFile, containingFile.getLanguage());
        this.stubId = stubId;
        this.myStubElementType = stubElementType;
        IElementType contentElementType = ((PsiFileImpl)containingFile).getContentElementType();
        assert (contentElementType instanceof IStubFileElementType) : contentElementType;
        assert (!(anchor instanceof PsiFile)) : "FileElementInfo must be used for file: " + anchor;
    }

    @Override
    @Nullable
    public PsiElement restoreElement() {
        if (this.stubId != -1) {
            PsiFile file = this.restoreFile();
            if (!(file instanceof PsiFileWithStubSupport)) {
                return null;
            }
            return PsiAnchor.restoreFromStubIndex((PsiFileWithStubSupport)file, this.stubId, this.myStubElementType, false);
        }
        if (!this.mySyncMarkerIsValid) {
            return null;
        }
        PsiFile file = this.restoreFile();
        if (file == null) {
            return null;
        }
        PsiElement anchor = file.findElementAt(this.getSyncStartOffset());
        if (anchor == null) {
            return null;
        }
        TextRange range = anchor.getTextRange();
        if (range.getStartOffset() != this.getSyncStartOffset() || range.getEndOffset() != this.getSyncEndOffset()) {
            return null;
        }
        if (anchor instanceof PsiIdentifier) {
            PsiElement parent = anchor.getParent();
            if (parent instanceof PsiJavaCodeReferenceElement) {
                parent = parent.getParent();
            }
            if (!anchor.equals(AnchorElementInfoFactory.getAnchor(parent))) {
                return null;
            }
            return parent;
        }
        if (anchor instanceof XmlToken) {
            XmlToken token = (XmlToken)anchor;
            return token.getTokenType() == XmlTokenType.XML_NAME ? token.getParent() : null;
        }
        return null;
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof AnchorElementInfo) {
            AnchorElementInfo otherAnchor = (AnchorElementInfo)other;
            if (this.stubId != -1 && otherAnchor.stubId != -1 && this.stubId != otherAnchor.stubId) {
                return false;
            }
            if (this.myStubElementType != null && otherAnchor.myStubElementType != null && this.myStubElementType != otherAnchor.myStubElementType) {
                return false;
            }
        }
        return super.pointsToTheSameElementAs(other);
    }

    @Override
    public void fastenBelt(int offset, RangeMarker[] cachedRangeMarker) {
        PsiElement element;
        if (this.stubId != -1 && (element = this.restoreElement()) != null) {
            this.stubId = -1;
            this.myStubElementType = null;
            PsiElement anchor = AnchorElementInfoFactory.getAnchor(element);
            this.setRange((Segment)(anchor == null ? element : anchor).getTextRange());
        }
        super.fastenBelt(offset, cachedRangeMarker);
    }
}

