/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.ITemplateDataElementType;
import com.intellij.psi.templateLanguages.OuterLanguageElementImpl;
import com.intellij.psi.templateLanguages.SimpleTreePatcher;
import com.intellij.psi.templateLanguages.TemplateBlackAndWhiteLexer;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TreePatcher;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.LocalTimeCounter;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataElementType
extends IFileElementType
implements ITemplateDataElementType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.templateLanguages.TemplateDataElementType");
    public static final LanguageExtension<TreePatcher> TREE_PATCHER = new LanguageExtension("com.intellij.lang.treePatcher", (Object)new SimpleTreePatcher());
    @NotNull
    private final IElementType myTemplateElementType;
    @NotNull
    private final IElementType myOuterElementType;

    public TemplateDataElementType(@NonNls String debugName, Language language, @NotNull IElementType templateElementType, @NotNull IElementType outerElementType) {
        if (templateElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateElementType", "com/intellij/psi/templateLanguages/TemplateDataElementType", "<init>"));
        }
        if (outerElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerElementType", "com/intellij/psi/templateLanguages/TemplateDataElementType", "<init>"));
        }
        super(debugName, language);
        this.myTemplateElementType = templateElementType;
        this.myOuterElementType = outerElementType;
    }

    protected Lexer createBaseLexer(TemplateLanguageFileViewProvider viewProvider) {
        return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(viewProvider.getBaseLanguage())).createLexer(viewProvider.getManager().getProject());
    }

    protected LanguageFileType createTemplateFakeFileType(Language language) {
        return new TemplateFileType(language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASTNode parseContents(ASTNode chameleon) {
        CharTable table = SharedImplUtil.findCharTableByTree(chameleon);
        FileElement treeElement = new DummyHolder((PsiManager)((TreeElement)chameleon).getManager(), null, table).getTreeElement();
        FileElement fileElement = TreeUtil.getFileElement((TreeElement)chameleon);
        PsiFile file = (PsiFile)fileElement.getPsi();
        PsiFile originalFile = file.getOriginalFile();
        TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)originalFile.getViewProvider();
        Language language = this.getTemplateFileLanguage(viewProvider);
        CharSequence chars = chameleon.getChars();
        PsiFile templateFile = this.createTemplateFile(file, language, chars, viewProvider);
        FileElement parsed = ((PsiFileImpl)templateFile).calcTreeElement();
        DebugUtil.startPsiModification("template language parsing");
        try {
            TreeElement element;
            this.prepareParsedTemplateFile(parsed);
            Lexer langLexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language)).createLexer(file.getProject());
            MergingLexerAdapter lexer = new MergingLexerAdapter((Lexer)new TemplateBlackAndWhiteLexer(this.createBaseLexer(viewProvider), langLexer, this.myTemplateElementType, this.myOuterElementType), TokenSet.create((IElementType[])new IElementType[]{this.myTemplateElementType, this.myOuterElementType}));
            lexer.start(chars);
            this.insertOuters(parsed, (Lexer)lexer, table);
            if (parsed != null && (element = parsed.getFirstChildNode()) != null) {
                parsed.rawRemoveAllChildren();
                treeElement.rawAddChildren(element);
            }
        }
        finally {
            DebugUtil.finishPsiModification();
        }
        treeElement.subtreeChanged();
        TreeElement childNode = treeElement.getFirstChildNode();
        DebugUtil.checkTreeStructure(parsed);
        DebugUtil.checkTreeStructure(treeElement);
        DebugUtil.checkTreeStructure(chameleon);
        if (fileElement != chameleon) {
            DebugUtil.checkTreeStructure((ASTNode)file.getNode());
            DebugUtil.checkTreeStructure((ASTNode)originalFile.getNode());
        }
        return childNode;
    }

    protected void prepareParsedTemplateFile(FileElement root) {
    }

    protected Language getTemplateFileLanguage(TemplateLanguageFileViewProvider viewProvider) {
        return viewProvider.getTemplateDataLanguage();
    }

    protected PsiFile createTemplateFile(PsiFile file, Language language, CharSequence chars, TemplateLanguageFileViewProvider viewProvider) {
        Lexer baseLexer = this.createBaseLexer(viewProvider);
        CharSequence templateText = this.createTemplateText(chars, baseLexer);
        return this.createFromText(language, templateText, file.getManager());
    }

    protected CharSequence createTemplateText(CharSequence buf, Lexer lexer) {
        StringBuilder result = new StringBuilder(buf.length());
        lexer.start(buf);
        while (lexer.getTokenType() != null) {
            if (lexer.getTokenType() == this.myTemplateElementType) {
                this.appendCurrentTemplateToken(result, buf, lexer);
            }
            lexer.advance();
        }
        return result;
    }

    protected void appendCurrentTemplateToken(StringBuilder result, CharSequence buf, Lexer lexer) {
        result.append(buf, lexer.getTokenStart(), lexer.getTokenEnd());
    }

    private void insertOuters(TreeElement root, Lexer lexer, CharTable table) {
        TreePatcher patcher = (TreePatcher)TREE_PATCHER.forLanguage(root.getPsi().getLanguage());
        int treeOffset = 0;
        LeafElement leaf = TreeUtil.findFirstLeaf(root);
        while (lexer.getTokenType() != null) {
            IElementType tt = lexer.getTokenType();
            if (tt != this.myTemplateElementType) {
                while (leaf != null && treeOffset < lexer.getTokenStart()) {
                    if ((treeOffset += leaf.getTextLength()) > lexer.getTokenStart()) {
                        leaf = patcher.split(leaf, leaf.getTextLength() - (treeOffset - lexer.getTokenStart()), table);
                        treeOffset = lexer.getTokenStart();
                    }
                    leaf = (LeafElement)TreeUtil.nextLeaf(leaf);
                }
                if (leaf == null) break;
                OuterLanguageElementImpl newLeaf = this.createOuterLanguageElement(lexer, table, this.myOuterElementType);
                patcher.insert(leaf.getTreeParent(), leaf, newLeaf);
                leaf.getTreeParent().subtreeChanged();
                leaf = newLeaf;
            }
            lexer.advance();
        }
        if (lexer.getTokenType() != null) {
            assert (lexer.getTokenType() != this.myTemplateElementType);
            OuterLanguageElementImpl newLeaf = this.createOuterLanguageElement(lexer, table, this.myOuterElementType);
            ((CompositeElement)root).rawAddChildren(newLeaf);
            ((CompositeElement)root).subtreeChanged();
        }
    }

    protected OuterLanguageElementImpl createOuterLanguageElement(Lexer lexer, CharTable table, @NotNull IElementType outerElementType) {
        int tokenEnd;
        if (outerElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerElementType", "com/intellij/psi/templateLanguages/TemplateDataElementType", "createOuterLanguageElement"));
        }
        CharSequence buffer = lexer.getBufferSequence();
        int tokenStart = lexer.getTokenStart();
        if (tokenStart < 0 || tokenStart > buffer.length()) {
            LOG.error("Invalid start: " + tokenStart + "; " + lexer);
        }
        if ((tokenEnd = lexer.getTokenEnd()) < 0 || tokenEnd > buffer.length()) {
            LOG.error("Invalid end: " + tokenEnd + "; " + lexer);
        }
        return new OuterLanguageElementImpl(outerElementType, table.intern(buffer, tokenStart, tokenEnd));
    }

    protected PsiFile createFromText(final Language language, CharSequence text, PsiManager manager) {
        LightVirtualFile virtualFile = new LightVirtualFile("foo", (FileType)this.createTemplateFakeFileType(language), text, LocalTimeCounter.currentTime());
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(manager, (VirtualFile)virtualFile, false){

            @Override
            @NotNull
            public Language getBaseLanguage() {
                Language language2 = language;
                if (language2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataElementType$1", "getBaseLanguage"));
                }
                return language2;
            }
        };
        return viewProvider.getPsi(language);
    }

    protected static class TemplateFileType
    extends LanguageFileType {
        private final Language myLanguage;

        public TemplateFileType(Language language) {
            super(language);
            this.myLanguage = language;
        }

        @NotNull
        public String getDefaultExtension() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataElementType$TemplateFileType", "getDefaultExtension"));
            }
            return "";
        }

        @NotNull
        @NonNls
        public String getDescription() {
            String string = "fake for language" + this.myLanguage.getID();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataElementType$TemplateFileType", "getDescription"));
            }
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return null;
        }

        @NotNull
        @NonNls
        public String getName() {
            String string = this.myLanguage.getID();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataElementType$TemplateFileType", "getName"));
            }
            return string;
        }
    }
}

