/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudGitAgent;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.CloudDeploymentConfiguratorBase;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentNameProvider;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.CloudDeploymentRuntimeProvider;
import com.intellij.remoteServer.util.CloudGitApplicationRuntime;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudMultiSourceServerRuntimeInstance<DC extends CloudDeploymentNameConfiguration, AC extends CloudAgentConfigBase, A extends CloudGitAgent<AC, ?>, SC extends AC>
extends CloudServerRuntimeInstance<DC, A, SC> {
    private static final Logger LOG = Logger.getInstance((String)("#" + CloudMultiSourceServerRuntimeInstance.class.getName()));
    private final ServerType<?> myServerType;

    public CloudMultiSourceServerRuntimeInstance(ServerType<?> serverType, SC configuration, ServerTaskExecutor tasksExecutor, List<File> libraries, List<Class<?>> commonJarClasses, String specificsModuleName, String specificJarPath, Class<A> agentInterface, String agentClassName) throws Exception {
        super(configuration, tasksExecutor, libraries, commonJarClasses, specificsModuleName, specificJarPath, agentInterface, agentClassName);
        this.myServerType = serverType;
    }

    @Override
    public A getAgent() {
        return (A)((CloudGitAgent)super.getAgent());
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance", "getDeploymentName"));
        }
        String string = CloudDeploymentNameProvider.DEFAULT_NAME_PROVIDER.getDeploymentName(source);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance", "getDeploymentName"));
        }
        return string;
    }

    public void connect(final ServerConnector.ConnectionCallback<DC> callback) {
        this.getAgentTaskExecutor().execute(new Computable(){

            public Object compute() {
                CloudMultiSourceServerRuntimeInstance.this.doConnect(CloudMultiSourceServerRuntimeInstance.this.getConfiguration(), new CloudAgentLogger(){

                    public void debugEx(Exception e) {
                        LOG.debug((Throwable)e);
                    }

                    public void debug(String message) {
                        LOG.debug(message);
                    }
                });
                return null;
            }
        }, new CallbackWrapper(){

            public void onSuccess(Object result) {
                callback.connected((ServerRuntimeInstance)CloudMultiSourceServerRuntimeInstance.this);
            }

            @Override
            public void onError(String message) {
                callback.errorOccurred(message);
            }
        });
    }

    public void deploy(final @NotNull DeploymentTask<DC> task, final @NotNull DeploymentLogManager logManager, final @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance", "deploy"));
        }
        if (logManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance", "deploy"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance", "deploy"));
        }
        this.getTaskExecutor().submit((ThrowableRunnable)new ThrowableRunnable<Exception>(){

            public void run() throws Exception {
                CloudMultiSourceServerRuntimeInstance.this.createDeploymentRuntime(task, logManager).deploy(callback);
            }
        }, (RemoteOperationCallback)callback);
    }

    public void disconnect() {
        this.getTaskExecutor().submit(new Runnable(){

            @Override
            public void run() {
                CloudMultiSourceServerRuntimeInstance.this.getAgent().disconnect();
            }
        });
    }

    public CloudDeploymentRuntime createDeploymentRuntime(DeployToServerRunConfiguration<?, DC> runConfiguration) throws ServerRuntimeException {
        return this.createDeploymentRuntime(runConfiguration.getDeploymentSource(), (CloudDeploymentNameConfiguration)runConfiguration.getDeploymentConfiguration(), runConfiguration.getProject());
    }

    public CloudDeploymentRuntime createDeploymentRuntime(final DeploymentSource source, DC configuration, Project project) throws ServerRuntimeException {
        return this.createDeploymentRuntime(new DeploymentTask<DC>((CloudDeploymentNameConfiguration)configuration, project){
            final /* synthetic */ CloudDeploymentNameConfiguration val$configuration;
            final /* synthetic */ Project val$project;
            {
                this.val$configuration = cloudDeploymentNameConfiguration;
                this.val$project = project;
            }

            @NotNull
            public DeploymentSource getSource() {
                DeploymentSource deploymentSource = source;
                if (deploymentSource == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance$5", "getSource"));
                }
                return deploymentSource;
            }

            @NotNull
            public DC getConfiguration() {
                CloudDeploymentNameConfiguration cloudDeploymentNameConfiguration = this.val$configuration;
                if (cloudDeploymentNameConfiguration == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance$5", "getConfiguration"));
                }
                return cloudDeploymentNameConfiguration;
            }

            @NotNull
            public Project getProject() {
                Project project = this.val$project;
                if (project == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance$5", "getProject"));
                }
                return project;
            }

            public boolean isDebugMode() {
                return false;
            }

            @NotNull
            public ExecutionEnvironment getExecutionEnvironment() {
                throw new UnsupportedOperationException();
            }
        }, null);
    }

    private CloudDeploymentRuntime createDeploymentRuntime(DeploymentTask<DC> deploymentTask, @Nullable DeploymentLogManager logManager) throws ServerRuntimeException {
        DeploymentSource source = deploymentTask.getSource();
        for (CloudDeploymentRuntimeProvider provider : CloudDeploymentConfiguratorBase.getDeploymentRuntimeProviders(this.myServerType)) {
            CloudDeploymentRuntime result = provider.createDeploymentRuntime(source, this, deploymentTask, logManager);
            if (result == null) continue;
            return result;
        }
        throw new ServerRuntimeException("Unknown deployment source");
    }

    @Override
    protected CloudApplicationRuntime createApplicationRuntime(CloudRemoteApplication application) {
        return new CloudGitApplicationRuntime(this, application.getName(), null);
    }

    protected abstract void doConnect(SC var1, CloudAgentLogger var2);
}

