/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BufferedListConsumer<T>
implements Consumer<List<T>> {
    private final int myInterval;
    private long myTs;
    private final int mySize;
    private List<T> myBuffer;
    private final Object myFlushLock;
    private final Consumer<List<T>> myConsumer;
    private int myCnt;
    private Runnable myFlushListener;
    private volatile boolean myPendingFlush;

    public BufferedListConsumer(int size, Consumer<List<T>> consumer, int interval) {
        this.mySize = size;
        this.myFlushLock = new Object();
        this.myBuffer = new ArrayList<T>(size);
        this.myConsumer = consumer;
        this.myInterval = interval;
        this.myTs = System.currentTimeMillis();
        this.myCnt = 0;
        this.myPendingFlush = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeOne(T t) {
        Object object = this.myFlushLock;
        synchronized (object) {
            ++this.myCnt;
            this.myBuffer.add(t);
            this.flushCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(List<T> list) {
        Object object = this.myFlushLock;
        synchronized (object) {
            this.myCnt += list.size();
            this.myBuffer.addAll(list);
            this.flushCheck();
        }
    }

    private void flushCheck() {
        long ts = System.currentTimeMillis();
        if (this.myBuffer.size() >= this.mySize || this.myInterval > 0 && ts - (long)this.myInterval > this.myTs) {
            this.flushImpl(ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushImpl(long ts) {
        Object object = this.myFlushLock;
        synchronized (object) {
            if (this.myPendingFlush || this.myBuffer.isEmpty()) {
                return;
            }
            this.myPendingFlush = true;
            this.invokeConsumer(this.createConsumerRunnable(ts));
        }
    }

    protected void invokeConsumer(@NotNull Runnable consumerRunnable) {
        if (consumerRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerRunnable", "com/intellij/util/BufferedListConsumer", "invokeConsumer"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(consumerRunnable);
    }

    @NotNull
    private Runnable createConsumerRunnable(final long ts) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list;
                BufferedListConsumer.this.myTs = ts;
                Object object = BufferedListConsumer.this.myFlushLock;
                synchronized (object) {
                    BufferedListConsumer.this.myPendingFlush = false;
                    if (BufferedListConsumer.this.myBuffer.isEmpty()) {
                        return;
                    }
                    list = BufferedListConsumer.this.myBuffer;
                    BufferedListConsumer.this.myBuffer = new ArrayList(BufferedListConsumer.this.mySize);
                }
                BufferedListConsumer.this.myConsumer.consume((Object)list);
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/BufferedListConsumer", "createConsumerRunnable"));
        }
        return runnable;
    }

    public void flush() {
        this.flushImpl(System.currentTimeMillis());
        if (this.myFlushListener != null) {
            this.myFlushListener.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCnt() {
        Object object = this.myFlushLock;
        synchronized (object) {
            return this.myCnt;
        }
    }

    public Consumer<T> asConsumer() {
        return new Consumer<T>(){

            public void consume(T t) {
                BufferedListConsumer.this.consumeOne(t);
            }
        };
    }
}

