/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.impl.TabbedContentImpl;
import com.intellij.util.ContentsUtil;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ContentUtilEx
extends ContentsUtil {
    public static void addTabbedContent(ContentManager manager, JComponent contentComponent, String groupPrefix, String tabName, boolean select) {
        ContentUtilEx.addTabbedContent(manager, contentComponent, groupPrefix, tabName, select, null);
    }

    public static void addTabbedContent(ContentManager manager, JComponent contentComponent, String groupPrefix, String tabName, boolean select, @Nullable Disposable childDisposable) {
        TabbedContentImpl tabbedContent = null;
        for (Content content : manager.getContents()) {
            if (!(content instanceof TabbedContent) || !content.getTabName().startsWith(groupPrefix + ": ")) continue;
            tabbedContent = (TabbedContent)content;
            break;
        }
        if (tabbedContent == null) {
            Disposable disposable = Disposer.newDisposable();
            tabbedContent = new TabbedContentImpl(contentComponent, tabName, true, groupPrefix);
            ContentsUtil.addOrReplaceContent((ContentManager)manager, (Content)tabbedContent, (boolean)select);
            Disposer.register((Disposable)tabbedContent, (Disposable)disposable);
        } else {
            for (Pair tab : new ArrayList(tabbedContent.getTabs())) {
                if (!Comparing.equal((Object)tab.second, (Object)contentComponent)) continue;
                tabbedContent.removeContent((JComponent)tab.second);
            }
            if (select) {
                manager.setSelectedContent((Content)tabbedContent, true, true);
            }
            tabbedContent.addContent(contentComponent, tabName, true);
        }
        if (childDisposable != null) {
            Disposer.register((Disposable)tabbedContent, (Disposable)childDisposable);
        }
    }
}

