/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchMatchedNodesGenerator {
    @NotNull
    private final LiteLinearGraph myGraph;
    @NotNull
    private final UnsignedBitSet myNodesVisibility;
    @NotNull
    private final DfsUtil myDfsUtil;

    @NotNull
    public static UnsignedBitSet generateVisibleNodes(@NotNull PermanentLinearGraphImpl permanentGraph, @Nullable Set<Integer> headNodeIndexes) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/graph/collapsing/BranchMatchedNodesGenerator", "generateVisibleNodes"));
        }
        if (headNodeIndexes == null) {
            UnsignedBitSet nodesVisibility = new UnsignedBitSet();
            nodesVisibility.set(0, permanentGraph.nodesCount() - 1, true);
            UnsignedBitSet unsignedBitSet = nodesVisibility;
            if (unsignedBitSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/collapsing/BranchMatchedNodesGenerator", "generateVisibleNodes"));
            }
            return unsignedBitSet;
        }
        assert (!headNodeIndexes.isEmpty());
        BranchMatchedNodesGenerator generator = new BranchMatchedNodesGenerator(LinearGraphUtils.asLiteLinearGraph(permanentGraph));
        generator.generate(headNodeIndexes);
        UnsignedBitSet unsignedBitSet = generator.myNodesVisibility;
        if (unsignedBitSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/collapsing/BranchMatchedNodesGenerator", "generateVisibleNodes"));
        }
        return unsignedBitSet;
    }

    BranchMatchedNodesGenerator(@NotNull LiteLinearGraph graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/collapsing/BranchMatchedNodesGenerator", "<init>"));
        }
        this.myDfsUtil = new DfsUtil();
        this.myGraph = graph;
        this.myNodesVisibility = new UnsignedBitSet();
    }

    private void generate(@NotNull Set<Integer> startedNodes) {
        if (startedNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startedNodes", "com/intellij/vcs/log/graph/collapsing/BranchMatchedNodesGenerator", "generate"));
        }
        for (int startNode : startedNodes) {
            this.myNodesVisibility.set(startNode, true);
            this.myDfsUtil.nodeDfsIterator(startNode, new DfsUtil.NextNode(){

                @Override
                public int fun(int currentNode) {
                    for (int downNode : BranchMatchedNodesGenerator.this.myGraph.getNodes(currentNode, LiteLinearGraph.NodeFilter.DOWN)) {
                        if (BranchMatchedNodesGenerator.this.myNodesVisibility.get(downNode)) continue;
                        BranchMatchedNodesGenerator.this.myNodesVisibility.set(downNode, true);
                        return downNode;
                    }
                    return -1;
                }
            });
        }
    }
}

