/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.BranchMatchedNodesGenerator;
import com.intellij.vcs.log.graph.collapsing.CollapsedActionManager;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.impl.facade.CascadeLinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.GraphChanges;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollapsedLinearGraphController
extends CascadeLinearGraphController {
    @NotNull
    private CollapsedGraph myCollapsedGraph;

    public CollapsedLinearGraphController(@NotNull CascadeLinearGraphController delegateLinearGraphController, @NotNull PermanentGraphInfo<?> permanentGraphInfo, @Nullable Set<Integer> IdsOfVisibleBranches) {
        if (delegateLinearGraphController == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateLinearGraphController", "com/intellij/vcs/log/graph/collapsing/CollapsedLinearGraphController", "<init>"));
        }
        if (permanentGraphInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraphInfo", "com/intellij/vcs/log/graph/collapsing/CollapsedLinearGraphController", "<init>"));
        }
        super(delegateLinearGraphController, permanentGraphInfo);
        UnsignedBitSet initVisibility = BranchMatchedNodesGenerator.generateVisibleNodes(permanentGraphInfo.getPermanentLinearGraph(), IdsOfVisibleBranches);
        this.myCollapsedGraph = CollapsedGraph.newInstance(this.getDelegateLinearGraphController().getCompiledGraph(), initVisibility);
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        if (delegateAnswer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateAnswer", "com/intellij/vcs/log/graph/collapsing/CollapsedLinearGraphController", "delegateGraphChanged"));
        }
        if (delegateAnswer.getGraphChanges() != null) {
            LinearGraph delegateGraph = this.getDelegateLinearGraphController().getCompiledGraph();
            this.myCollapsedGraph = CollapsedGraph.updateInstance(this.myCollapsedGraph, delegateGraph);
            this.applyDelegateChanges(delegateGraph, delegateAnswer.getGraphChanges());
        }
        LinearGraphController.LinearGraphAnswer linearGraphAnswer = delegateAnswer;
        if (linearGraphAnswer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/collapsing/CollapsedLinearGraphController", "delegateGraphChanged"));
        }
        return linearGraphAnswer;
    }

    private void applyDelegateChanges(LinearGraph graph, GraphChanges<Integer> changes) {
        HashSet nodesToShow = ContainerUtil.newHashSet();
        for (GraphChanges.Edge<Integer> edge : changes.getChangedEdges()) {
            Integer downIndex;
            Integer downId;
            Integer upIndex;
            if (edge.removed()) continue;
            Integer upId = edge.upNodeId();
            if (upId != null && (upIndex = graph.getNodeIndex(upId)) != null) {
                nodesToShow.add(upIndex);
            }
            if ((downId = edge.downNodeId()) == null || (downIndex = graph.getNodeIndex(downId)) == null) continue;
            nodesToShow.add(downIndex);
        }
        for (GraphChanges.Node node : changes.getChangedNodes()) {
            Integer nodeIndex;
            if (node.removed() || (nodeIndex = graph.getNodeIndex((Integer)node.getNodeId())) == null) continue;
            nodesToShow.add(nodeIndex);
        }
        CollapsedActionManager.expandNodes(this.myCollapsedGraph, nodesToShow);
    }

    @Override
    @Nullable
    protected LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/graph/collapsing/CollapsedLinearGraphController", "performAction"));
        }
        return CollapsedActionManager.performAction(this, action);
    }

    @Override
    @NotNull
    public LinearGraph getCompiledGraph() {
        LinearGraph linearGraph = this.myCollapsedGraph.getCompiledGraph();
        if (linearGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/collapsing/CollapsedLinearGraphController", "getCompiledGraph"));
        }
        return linearGraph;
    }

    @NotNull
    protected CollapsedGraph getCollapsedGraph() {
        CollapsedGraph collapsedGraph = this.myCollapsedGraph;
        if (collapsedGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/collapsing/CollapsedLinearGraphController", "getCollapsedGraph"));
        }
        return collapsedGraph;
    }

    @Override
    @Nullable
    protected GraphElement convertToDelegate(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphElement", "com/intellij/vcs/log/graph/collapsing/CollapsedLinearGraphController", "convertToDelegate"));
        }
        if (graphElement instanceof GraphEdge) {
            Integer upIndex = ((GraphEdge)graphElement).getUpNodeIndex();
            Integer downIndex = ((GraphEdge)graphElement).getDownNodeIndex();
            if (upIndex != null && downIndex != null && this.myCollapsedGraph.hasCollapsedEdge(upIndex, downIndex)) {
                return null;
            }
            Integer convertedUpIndex = upIndex == null ? null : Integer.valueOf(this.myCollapsedGraph.convertToDelegateNodeIndex(upIndex));
            Integer convertedDownIndex = downIndex == null ? null : Integer.valueOf(this.myCollapsedGraph.convertToDelegateNodeIndex(downIndex));
            return new GraphEdge(convertedUpIndex, convertedDownIndex, ((GraphEdge)graphElement).getTargetId(), ((GraphEdge)graphElement).getType());
        }
        if (graphElement instanceof GraphNode) {
            return new GraphNode(this.myCollapsedGraph.convertToDelegateNodeIndex(((GraphNode)graphElement).getNodeIndex()), ((GraphNode)graphElement).getType());
        }
        return null;
    }
}

