/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import org.jetbrains.annotations.NotNull;

public class DottedFilterEdgesGenerator {
    @NotNull
    private final CollapsedGraph myCollapsedGraph;
    @NotNull
    private final CollapsedGraph.Modification myModification;
    @NotNull
    private final LiteLinearGraph myLiteDelegateGraph;
    private final int myUpIndex;
    private final int myDownIndex;
    @NotNull
    private final ShiftNumber myNumbers;

    public static void update(@NotNull CollapsedGraph collapsedGraph, int upDelegateNodeIndex, int downDelegateNodeIndex) {
        if (collapsedGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collapsedGraph", "com/intellij/vcs/log/graph/collapsing/DottedFilterEdgesGenerator", "update"));
        }
        CollapsedGraph.Modification modification = collapsedGraph.startModification();
        new DottedFilterEdgesGenerator(collapsedGraph, modification, upDelegateNodeIndex, downDelegateNodeIndex).update();
        modification.apply();
    }

    private DottedFilterEdgesGenerator(@NotNull CollapsedGraph collapsedGraph, @NotNull CollapsedGraph.Modification modification, int upIndex, int downIndex) {
        if (collapsedGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collapsedGraph", "com/intellij/vcs/log/graph/collapsing/DottedFilterEdgesGenerator", "<init>"));
        }
        if (modification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modification", "com/intellij/vcs/log/graph/collapsing/DottedFilterEdgesGenerator", "<init>"));
        }
        this.myCollapsedGraph = collapsedGraph;
        this.myModification = modification;
        this.myLiteDelegateGraph = LinearGraphUtils.asLiteLinearGraph(collapsedGraph.getDelegatedGraph());
        this.myUpIndex = upIndex;
        this.myDownIndex = downIndex;
        this.myNumbers = new ShiftNumber(upIndex, downIndex);
    }

    private boolean nodeIsVisible(int nodeIndex) {
        return this.myCollapsedGraph.isNodeVisible(nodeIndex);
    }

    private void addDottedEdge(int nodeIndex1, int nodeIndex2) {
        this.myModification.createEdge(new GraphEdge(nodeIndex1, nodeIndex2, null, GraphEdgeType.DOTTED));
    }

    private void addDottedArrow(int nodeIndex, boolean isUp) {
        this.myModification.createEdge(new GraphEdge(nodeIndex, null, null, isUp ? GraphEdgeType.DOTTED_ARROW_UP : GraphEdgeType.DOTTED_ARROW_DOWN));
    }

    private void update() {
        this.downWalk();
        this.upWalk();
    }

    private boolean hasDottedEdges(int nodeIndex, boolean isUp) {
        for (GraphEdge edge : this.myModification.getEdgesToAdd().getAdjacentEdges(nodeIndex, EdgeFilter.NORMAL_ALL)) {
            if (edge.getType() != GraphEdgeType.DOTTED) continue;
            if (isUp && LinearGraphUtils.isEdgeUp(edge, nodeIndex)) {
                return true;
            }
            if (isUp || !LinearGraphUtils.isEdgeDown(edge, nodeIndex)) continue;
            return false;
        }
        return false;
    }

    private void addEdgeOrArrow(int currentNodeIndex, int anotherNodeIndex, boolean isUp) {
        if (this.hasDottedEdges(currentNodeIndex, isUp)) {
            if (this.nodeIsVisible(anotherNodeIndex)) {
                this.addDottedEdge(currentNodeIndex, anotherNodeIndex);
            } else {
                this.addDottedArrow(currentNodeIndex, isUp);
            }
        }
    }

    private void downWalk() {
        for (int currentNodeIndex = this.myUpIndex; currentNodeIndex <= this.myDownIndex; ++currentNodeIndex) {
            int nearlyUp;
            if (this.nodeIsVisible(currentNodeIndex)) {
                nearlyUp = Integer.MIN_VALUE;
                int maxAdjNumber = Integer.MIN_VALUE;
                for (int upNode : this.myLiteDelegateGraph.getNodes(currentNodeIndex, LiteLinearGraph.NodeFilter.UP)) {
                    if (upNode < this.myUpIndex) {
                        this.addEdgeOrArrow(currentNodeIndex, upNode, true);
                        continue;
                    }
                    if (this.nodeIsVisible(upNode)) {
                        maxAdjNumber = Math.max(maxAdjNumber, this.myNumbers.getNumber(upNode));
                        continue;
                    }
                    nearlyUp = Math.max(nearlyUp, this.myNumbers.getNumber(upNode));
                }
                if (nearlyUp == maxAdjNumber || nearlyUp == Integer.MIN_VALUE) {
                    this.myNumbers.setNumber(currentNodeIndex, maxAdjNumber);
                    continue;
                }
                this.addDottedEdge(currentNodeIndex, nearlyUp);
                this.myNumbers.setNumber(currentNodeIndex, nearlyUp);
                continue;
            }
            nearlyUp = Integer.MIN_VALUE;
            for (int upNode : this.myLiteDelegateGraph.getNodes(currentNodeIndex, LiteLinearGraph.NodeFilter.UP)) {
                if (this.nodeIsVisible(upNode)) {
                    nearlyUp = Math.max(nearlyUp, upNode);
                    continue;
                }
                if (upNode < this.myUpIndex) continue;
                nearlyUp = Math.max(nearlyUp, this.myNumbers.getNumber(upNode));
            }
            this.myNumbers.setNumber(currentNodeIndex, nearlyUp);
        }
    }

    private void upWalk() {
        for (int currentNodeIndex = this.myDownIndex; currentNodeIndex >= this.myUpIndex; --currentNodeIndex) {
            int nearlyDown;
            if (this.nodeIsVisible(currentNodeIndex)) {
                nearlyDown = Integer.MAX_VALUE;
                int minAdjNumber = Integer.MAX_VALUE;
                for (int downNode : this.myLiteDelegateGraph.getNodes(currentNodeIndex, LiteLinearGraph.NodeFilter.DOWN)) {
                    if (downNode > this.myDownIndex) {
                        this.addEdgeOrArrow(currentNodeIndex, downNode, false);
                        continue;
                    }
                    if (this.nodeIsVisible(downNode)) {
                        minAdjNumber = Math.min(minAdjNumber, this.myNumbers.getNumber(downNode));
                        continue;
                    }
                    nearlyDown = Math.min(nearlyDown, this.myNumbers.getNumber(downNode));
                }
                if (nearlyDown == minAdjNumber || nearlyDown == Integer.MAX_VALUE) {
                    this.myNumbers.setNumber(currentNodeIndex, minAdjNumber);
                    continue;
                }
                this.addDottedEdge(currentNodeIndex, nearlyDown);
                this.myNumbers.setNumber(currentNodeIndex, nearlyDown);
                continue;
            }
            nearlyDown = Integer.MAX_VALUE;
            for (int downNode : this.myLiteDelegateGraph.getNodes(currentNodeIndex, LiteLinearGraph.NodeFilter.DOWN)) {
                if (this.nodeIsVisible(downNode)) {
                    nearlyDown = Math.min(nearlyDown, downNode);
                    continue;
                }
                if (downNode <= this.myDownIndex) continue;
                nearlyDown = Math.min(nearlyDown, this.myNumbers.getNumber(downNode));
            }
            this.myNumbers.setNumber(currentNodeIndex, nearlyDown);
        }
    }

    static class ShiftNumber {
        private final int startIndex;
        private final int endIndex;
        private final int[] numbers;

        ShiftNumber(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.numbers = new int[endIndex - startIndex + 1];
        }

        private boolean inRange(int nodeIndex) {
            return this.startIndex <= nodeIndex && nodeIndex <= this.endIndex;
        }

        protected int getNumber(int nodeIndex) {
            if (this.inRange(nodeIndex)) {
                return this.numbers[nodeIndex - this.startIndex];
            }
            return -1;
        }

        protected void setNumber(int nodeIndex, int value) {
            if (this.inRange(nodeIndex)) {
                this.numbers[nodeIndex - this.startIndex] = value;
            }
        }
    }
}

