/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.elements.GraphNodeType;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.CascadeLinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.bek.BekChecker;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BekBaseLinearGraphController
extends CascadeLinearGraphController {
    @NotNull
    private final BekIntMap myBekIntMap;
    @NotNull
    private final LinearGraph myBekGraph;

    public BekBaseLinearGraphController(@NotNull PermanentGraphInfo permanentGraphInfo, @NotNull BekIntMap bekIntMap) {
        if (permanentGraphInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraphInfo", "com/intellij/vcs/log/graph/impl/facade/BekBaseLinearGraphController", "<init>"));
        }
        if (bekIntMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bekIntMap", "com/intellij/vcs/log/graph/impl/facade/BekBaseLinearGraphController", "<init>"));
        }
        super(null, permanentGraphInfo);
        this.myBekIntMap = bekIntMap;
        this.myBekGraph = new BekLinearGraph();
        assert (BekChecker.checkLinearGraph(this.myBekGraph));
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        if (delegateAnswer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateAnswer", "com/intellij/vcs/log/graph/impl/facade/BekBaseLinearGraphController", "delegateGraphChanged"));
        }
        throw new IllegalStateException();
    }

    @Override
    @Nullable
    protected LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/graph/impl/facade/BekBaseLinearGraphController", "performAction"));
        }
        return null;
    }

    @NotNull
    public BekIntMap getBekIntMap() {
        BekIntMap bekIntMap = this.myBekIntMap;
        if (bekIntMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/BekBaseLinearGraphController", "getBekIntMap"));
        }
        return bekIntMap;
    }

    @Override
    @Nullable
    protected GraphElement convertToDelegate(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphElement", "com/intellij/vcs/log/graph/impl/facade/BekBaseLinearGraphController", "convertToDelegate"));
        }
        if (graphElement instanceof GraphEdge) {
            Integer upIndex = ((GraphEdge)graphElement).getUpNodeIndex();
            Integer downIndex = ((GraphEdge)graphElement).getDownNodeIndex();
            Integer convertedUpIndex = upIndex == null ? null : Integer.valueOf(this.myBekIntMap.getUsualIndex(upIndex));
            Integer convertedDownIndex = downIndex == null ? null : Integer.valueOf(this.myBekIntMap.getUsualIndex(downIndex));
            return new GraphEdge(convertedUpIndex, convertedDownIndex, ((GraphEdge)graphElement).getTargetId(), ((GraphEdge)graphElement).getType());
        }
        if (graphElement instanceof GraphNode) {
            return new GraphNode(this.myBekIntMap.getUsualIndex(((GraphNode)graphElement).getNodeIndex()), ((GraphNode)graphElement).getType());
        }
        return null;
    }

    @Override
    @NotNull
    public LinearGraph getCompiledGraph() {
        LinearGraph linearGraph = this.myBekGraph;
        if (linearGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/BekBaseLinearGraphController", "getCompiledGraph"));
        }
        return linearGraph;
    }

    private class BekLinearGraph
    implements LinearGraph {
        @NotNull
        private final LinearGraph myPermanentGraph;

        private BekLinearGraph() {
            this.myPermanentGraph = BekBaseLinearGraphController.this.myPermanentGraphInfo.getPermanentLinearGraph();
        }

        @Override
        public int nodesCount() {
            return this.myPermanentGraph.nodesCount();
        }

        @Nullable
        private Integer getNodeIndex(@Nullable Integer nodeId) {
            if (nodeId == null) {
                return null;
            }
            return BekBaseLinearGraphController.this.myBekIntMap.getBekIndex(nodeId);
        }

        @Override
        @NotNull
        public List<GraphEdge> getAdjacentEdges(int nodeIndex, @NotNull EdgeFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/graph/impl/facade/BekBaseLinearGraphController$BekLinearGraph", "getAdjacentEdges"));
            }
            List list = ContainerUtil.map(this.myPermanentGraph.getAdjacentEdges(BekBaseLinearGraphController.this.myBekIntMap.getUsualIndex(nodeIndex), filter), (Function)new Function<GraphEdge, GraphEdge>(){

                public GraphEdge fun(GraphEdge edge) {
                    return new GraphEdge(BekLinearGraph.this.getNodeIndex(edge.getUpNodeIndex()), BekLinearGraph.this.getNodeIndex(edge.getDownNodeIndex()), edge.getTargetId(), edge.getType());
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/BekBaseLinearGraphController$BekLinearGraph", "getAdjacentEdges"));
            }
            return list;
        }

        @Override
        @NotNull
        public GraphNode getGraphNode(int nodeIndex) {
            assert (this.inRanges(nodeIndex));
            GraphNode graphNode = new GraphNode(nodeIndex, GraphNodeType.USUAL);
            if (graphNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/BekBaseLinearGraphController$BekLinearGraph", "getGraphNode"));
            }
            return graphNode;
        }

        @Override
        public int getNodeId(int nodeIndex) {
            return BekBaseLinearGraphController.this.myBekIntMap.getUsualIndex(nodeIndex);
        }

        @Override
        @Nullable
        public Integer getNodeIndex(int nodeId) {
            if (!this.inRanges(nodeId)) {
                return null;
            }
            return BekBaseLinearGraphController.this.myBekIntMap.getBekIndex(nodeId);
        }

        private boolean inRanges(int index) {
            return index >= 0 && index < this.nodesCount();
        }
    }
}

