/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.linearBek;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.BekBaseLinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.CascadeLinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.GraphChanges;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.linearBek.LinearBekGraph;
import com.intellij.vcs.log.graph.linearBek.LinearBekGraphBuilder;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearBekController
extends CascadeLinearGraphController {
    @NotNull
    private final LinearBekGraph myCompiledGraph;

    public LinearBekController(@NotNull BekBaseLinearGraphController controller, @NotNull PermanentGraphInfo permanentGraphInfo, @NotNull TimestampGetter timestampGetter) {
        if (controller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/intellij/vcs/log/graph/linearBek/LinearBekController", "<init>"));
        }
        if (permanentGraphInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraphInfo", "com/intellij/vcs/log/graph/linearBek/LinearBekController", "<init>"));
        }
        if (timestampGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timestampGetter", "com/intellij/vcs/log/graph/linearBek/LinearBekController", "<init>"));
        }
        super(controller, permanentGraphInfo);
        BekIntMap bekIntMap = controller.getBekIntMap();
        this.myCompiledGraph = LinearBekController.compileGraph(this.getDelegateLinearGraphController().getCompiledGraph(), new BekGraphLayout(permanentGraphInfo.getPermanentGraphLayout(), bekIntMap), new BekTimestampGetter(timestampGetter, bekIntMap));
    }

    static LinearBekGraph compileGraph(@NotNull LinearGraph graph, @NotNull GraphLayout graphLayout, @NotNull TimestampGetter timestampGetter) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/linearBek/LinearBekController", "compileGraph"));
        }
        if (graphLayout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphLayout", "com/intellij/vcs/log/graph/linearBek/LinearBekController", "compileGraph"));
        }
        if (timestampGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timestampGetter", "com/intellij/vcs/log/graph/linearBek/LinearBekController", "compileGraph"));
        }
        return new LinearBekGraphBuilder(graph, graphLayout, timestampGetter).build();
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        if (delegateAnswer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateAnswer", "com/intellij/vcs/log/graph/linearBek/LinearBekController", "delegateGraphChanged"));
        }
        LinearGraphController.LinearGraphAnswer linearGraphAnswer = delegateAnswer;
        if (linearGraphAnswer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/linearBek/LinearBekController", "delegateGraphChanged"));
        }
        return linearGraphAnswer;
    }

    @Override
    @Nullable
    protected LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/graph/linearBek/LinearBekController", "performAction"));
        }
        if (action.getAffectedElement() != null) {
            GraphEdge edge;
            GraphElement graphElement;
            if (action.getType() == GraphAction.Type.MOUSE_CLICK) {
                GraphEdge edge2;
                GraphElement graphElement2 = action.getAffectedElement().getGraphElement();
                if (graphElement2 instanceof GraphEdge && (edge2 = (GraphEdge)graphElement2).getType() == GraphEdgeType.DOTTED) {
                    return new LinearGraphController.LinearGraphAnswer(LinearBekController.calculateChanges(edge2, this.myCompiledGraph.expandEdge(edge2), this.getDelegateLinearGraphController().getCompiledGraph()), null, null, null);
                }
            } else if (action.getType() == GraphAction.Type.MOUSE_OVER && (graphElement = action.getAffectedElement().getGraphElement()) instanceof GraphEdge && (edge = (GraphEdge)graphElement).getType() == GraphEdgeType.DOTTED) {
                return LinearGraphUtils.createSelectedAnswer(this.myCompiledGraph, ContainerUtil.set((Object[])new Integer[]{edge.getUpNodeIndex(), edge.getDownNodeIndex()}));
            }
        }
        return LinearGraphUtils.createCursorAnswer(false);
    }

    @Override
    @NotNull
    public LinearGraph getCompiledGraph() {
        LinearBekGraph linearBekGraph = this.myCompiledGraph;
        if (linearBekGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/linearBek/LinearBekController", "getCompiledGraph"));
        }
        return linearBekGraph;
    }

    private static GraphChanges<Integer> calculateChanges(GraphEdge expanded, Collection<GraphEdge> addedEdges, LinearGraph delegateGraph) {
        HashSet edgeChanges = ContainerUtil.newHashSet();
        edgeChanges.add(new GraphChanges.EdgeImpl<Object>(delegateGraph.getNodeId(expanded.getUpNodeIndex()), delegateGraph.getNodeId(expanded.getDownNodeIndex()), null, true));
        for (GraphEdge edge : addedEdges) {
            edgeChanges.add(new GraphChanges.EdgeImpl<Integer>(delegateGraph.getNodeId(edge.getUpNodeIndex()), delegateGraph.getNodeId(edge.getDownNodeIndex()), false));
        }
        return new GraphChanges.GraphChangesImpl<Integer>(Collections.emptySet(), edgeChanges);
    }

    private static class BekTimestampGetter
    implements TimestampGetter {
        private final TimestampGetter myTimestampGetter;
        private final BekIntMap myBekIntMap;

        public BekTimestampGetter(TimestampGetter timestampGetter, BekIntMap bekIntMap) {
            this.myTimestampGetter = timestampGetter;
            this.myBekIntMap = bekIntMap;
        }

        @Override
        public int size() {
            return this.myTimestampGetter.size();
        }

        @Override
        public long getTimestamp(int index) {
            return this.myTimestampGetter.getTimestamp(this.myBekIntMap.getUsualIndex(index));
        }
    }

    private static class BekGraphLayout
    implements GraphLayout {
        private final GraphLayout myGraphLayout;
        private final BekIntMap myBekIntMap;

        public BekGraphLayout(GraphLayout graphLayout, BekIntMap bekIntMap) {
            this.myGraphLayout = graphLayout;
            this.myBekIntMap = bekIntMap;
        }

        @Override
        public int getLayoutIndex(int nodeIndex) {
            return this.myGraphLayout.getLayoutIndex(this.myBekIntMap.getUsualIndex(nodeIndex));
        }

        @Override
        public int getOneOfHeadNodeIndex(int nodeIndex) {
            int usualIndex = this.myGraphLayout.getOneOfHeadNodeIndex(this.myBekIntMap.getUsualIndex(nodeIndex));
            return this.myBekIntMap.getBekIndex(usualIndex);
        }

        @Override
        @NotNull
        public List<Integer> getHeadNodeIndex() {
            ArrayList<Integer> bekIndexes = new ArrayList<Integer>();
            for (int head : this.myGraphLayout.getHeadNodeIndex()) {
                bekIndexes.add(this.myBekIntMap.getBekIndex(head));
            }
            ArrayList<Integer> arrayList = bekIndexes;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/linearBek/LinearBekController$BekGraphLayout", "getHeadNodeIndex"));
            }
            return arrayList;
        }
    }
}

