/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.linearBek;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.collapsing.EdgeStorageWrapper;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearBekGraph
implements LinearGraph {
    @NotNull
    protected final LinearGraph myGraph;
    @NotNull
    protected final EdgeStorageWrapper myHiddenEdges;
    @NotNull
    protected final EdgeStorageWrapper myDottedEdges;

    public LinearBekGraph(@NotNull LinearGraph graph, @NotNull EdgeStorageWrapper hiddenEdges, @NotNull EdgeStorageWrapper dottedEdges) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/linearBek/LinearBekGraph", "<init>"));
        }
        if (hiddenEdges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hiddenEdges", "com/intellij/vcs/log/graph/linearBek/LinearBekGraph", "<init>"));
        }
        if (dottedEdges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dottedEdges", "com/intellij/vcs/log/graph/linearBek/LinearBekGraph", "<init>"));
        }
        this.myGraph = graph;
        this.myHiddenEdges = hiddenEdges;
        this.myDottedEdges = dottedEdges;
    }

    @Override
    public int nodesCount() {
        return this.myGraph.nodesCount();
    }

    @Override
    @NotNull
    public List<GraphEdge> getAdjacentEdges(int nodeIndex, @NotNull EdgeFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/graph/linearBek/LinearBekGraph", "getAdjacentEdges"));
        }
        ArrayList<GraphEdge> result = new ArrayList<GraphEdge>();
        result.addAll(this.myGraph.getAdjacentEdges(nodeIndex, filter));
        result.removeAll(this.myHiddenEdges.getAdjacentEdges(nodeIndex, filter));
        result.addAll(this.myDottedEdges.getAdjacentEdges(nodeIndex, filter));
        Collections.sort(result, new Comparator<GraphEdge>(){

            @Override
            public int compare(GraphEdge o1, GraphEdge o2) {
                return o1.getUpNodeIndex().compareTo(o2.getUpNodeIndex());
            }
        });
        ArrayList<GraphEdge> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/linearBek/LinearBekGraph", "getAdjacentEdges"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public GraphNode getGraphNode(int nodeIndex) {
        GraphNode graphNode = this.myGraph.getGraphNode(nodeIndex);
        if (graphNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/linearBek/LinearBekGraph", "getGraphNode"));
        }
        return graphNode;
    }

    @Override
    public int getNodeId(int nodeIndex) {
        return this.myGraph.getNodeId(nodeIndex);
    }

    @Override
    @Nullable
    public Integer getNodeIndex(int nodeId) {
        return this.myGraph.getNodeIndex(nodeId);
    }

    public Collection<GraphEdge> expandEdge(@NotNull GraphEdge edge) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/linearBek/LinearBekGraph", "expandEdge"));
        }
        assert (edge.getType() == GraphEdgeType.DOTTED);
        final Integer tail = edge.getUpNodeIndex();
        Integer firstChild = edge.getDownNodeIndex();
        this.myDottedEdges.removeEdge(edge);
        HashSet addedEdges = ContainerUtil.newHashSet();
        addedEdges.addAll(this.myGraph.getAdjacentEdges(tail, EdgeFilter.NORMAL_DOWN));
        addedEdges.addAll(this.myGraph.getAdjacentEdges(firstChild, EdgeFilter.NORMAL_UP));
        for (GraphEdge hiddenEdge : addedEdges) {
            this.myHiddenEdges.removeEdge(hiddenEdge);
        }
        if (edge.getType() == GraphEdgeType.DOTTED) {
            this.myHiddenEdges.removeEdge(edge);
        }
        List<GraphEdge> hiddenDotted = this.myHiddenEdges.getAdjacentEdges(tail, EdgeFilter.ALL);
        List downDottedEdges = ContainerUtil.filter(hiddenDotted, (Condition)new Condition<GraphEdge>(){

            public boolean value(GraphEdge graphEdge) {
                return LinearGraphUtils.isEdgeDown(graphEdge, tail);
            }
        });
        for (GraphEdge graphEdge : downDottedEdges) {
            assert (graphEdge.getType() == GraphEdgeType.DOTTED);
            addedEdges.addAll(this.expandEdge(graphEdge));
        }
        return addedEdges;
    }
}

