/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.linearBek;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.collapsing.EdgeStorageWrapper;
import com.intellij.vcs.log.graph.linearBek.LinearBekGraph;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;

class LinearBekGraphBuilder {
    private static final int MAX_BLOCK_SIZE = 20;
    private static final long MAX_DELTA_TIME = 259200000L;
    @NotNull
    private final WorkingGraph myWorkingGraph;
    @NotNull
    private final GraphLayout myGraphLayout;
    @NotNull
    private final List<Integer> myHeads;
    @NotNull
    private final TimestampGetter myTimestampGetter;

    public LinearBekGraphBuilder(@NotNull LinearGraph graph, @NotNull GraphLayout graphLayout, @NotNull TimestampGetter timestampGetter) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/linearBek/LinearBekGraphBuilder", "<init>"));
        }
        if (graphLayout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphLayout", "com/intellij/vcs/log/graph/linearBek/LinearBekGraphBuilder", "<init>"));
        }
        if (timestampGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timestampGetter", "com/intellij/vcs/log/graph/linearBek/LinearBekGraphBuilder", "<init>"));
        }
        this.myWorkingGraph = new WorkingGraph(graph);
        this.myGraphLayout = graphLayout;
        this.myHeads = graphLayout.getHeadNodeIndex();
        this.myTimestampGetter = timestampGetter;
    }

    public LinearBekGraph build() {
        int i;
        Map nextHeadLayoutIndexes = ContainerUtilRt.newHashMap((int)this.myHeads.size());
        for (i = 0; i < this.myHeads.size(); ++i) {
            if (i == this.myHeads.size() - 1) {
                nextHeadLayoutIndexes.put(this.myHeads.get(i), Integer.MAX_VALUE);
                continue;
            }
            nextHeadLayoutIndexes.put(this.myHeads.get(i), this.myGraphLayout.getLayoutIndex(this.myHeads.get(i + 1)));
        }
        for (i = this.myWorkingGraph.myGraph.nodesCount() - 1; i >= 0; --i) {
            List downNodes = ContainerUtil.sorted(LinearGraphUtils.getDownNodes(this.myWorkingGraph, i));
            if (downNodes.size() != 2) continue;
            int head = this.myGraphLayout.getOneOfHeadNodeIndex(i);
            if (this.collapse((Integer)downNodes.get(1), (Integer)downNodes.get(0), i, this.myGraphLayout.getLayoutIndex(head), (Integer)nextHeadLayoutIndexes.get(head))) {
                this.myWorkingGraph.apply();
                continue;
            }
            this.myWorkingGraph.clear();
        }
        return this.myWorkingGraph.createLinearBekGraph();
    }

    private boolean collapse(int firstChild, int secondChild, int parent, int headIndex, int nextHeadIndex) {
        int x = this.myGraphLayout.getLayoutIndex(firstChild);
        int y = this.myGraphLayout.getLayoutIndex(secondChild);
        int k = 1;
        PriorityQueue<GraphEdge> queue = new PriorityQueue<GraphEdge>(20, new GraphEdgeComparator());
        queue.addAll(this.myWorkingGraph.getAdjacentEdges(secondChild, EdgeFilter.NORMAL_DOWN));
        HashSet definitelyNotTails = ContainerUtil.newHashSet();
        HashSet tails = ContainerUtil.newHashSet();
        boolean mergeWithOldCommit = false;
        while (!queue.isEmpty()) {
            GraphEdge nextEdge = queue.poll();
            Integer next = nextEdge.getDownNodeIndex();
            if (next == null) continue;
            Integer upNodeIndex = nextEdge.getUpNodeIndex();
            assert (upNodeIndex != null);
            if (next == firstChild) {
                tails.add(upNodeIndex);
                mergeWithOldCommit = true;
            } else if (next == secondChild + k) {
                ++k;
                queue.addAll(this.myWorkingGraph.getAdjacentEdges(next, EdgeFilter.NORMAL_DOWN));
                definitelyNotTails.add(upNodeIndex);
            } else if (next > secondChild + k && next < firstChild) {
                k = next - secondChild + 1;
                queue.addAll(this.myWorkingGraph.getAdjacentEdges(next, EdgeFilter.NORMAL_DOWN));
                definitelyNotTails.add(upNodeIndex);
            } else if (next > firstChild) {
                int li = this.myGraphLayout.getLayoutIndex(next);
                if (li > y) {
                    return false;
                }
                if (li < x && (li < headIndex || li >= nextHeadIndex)) {
                    return false;
                }
                if (!definitelyNotTails.contains(upNodeIndex)) {
                    tails.add(upNodeIndex);
                    if (li != y && li >= x) {
                        this.myWorkingGraph.removeEdge(upNodeIndex, next);
                    }
                }
            }
            if (k >= 20) {
                return false;
            }
            if (Math.abs(this.myTimestampGetter.getTimestamp(secondChild) - this.myTimestampGetter.getTimestamp(secondChild + k - 1)) <= 259200000L) continue;
            return false;
        }
        if (tails.isEmpty()) {
            return false;
        }
        for (Integer tail : tails) {
            if (!LinearGraphUtils.getDownNodes(this.myWorkingGraph, tail).contains(firstChild)) {
                this.myWorkingGraph.addEdge(tail, firstChild);
                continue;
            }
            if (!mergeWithOldCommit) continue;
            this.myWorkingGraph.replaceEdge(tail, firstChild);
        }
        this.myWorkingGraph.removeEdge(parent, firstChild);
        return true;
    }

    private static class WorkingGraph
    extends LinearBekGraph {
        private final List<GraphEdge> myToAdd = new ArrayList<GraphEdge>();
        private final List<GraphEdge> myToReplace = new ArrayList<GraphEdge>();
        private final List<GraphEdge> myNormalToHide = new ArrayList<GraphEdge>();
        private final List<GraphEdge> myDottedToHide = new ArrayList<GraphEdge>();

        private WorkingGraph(LinearGraph graph) {
            super(graph, EdgeStorageWrapper.createSimpleEdgeStorage(), EdgeStorageWrapper.createSimpleEdgeStorage());
        }

        public void addEdge(int up, int down) {
            this.myToAdd.add(new GraphEdge(up, down, null, GraphEdgeType.DOTTED));
        }

        public void removeEdge(int up, int down) {
            if (this.myDottedEdges.hasEdge(up, down)) {
                this.myDottedToHide.add(new GraphEdge(up, down, null, GraphEdgeType.DOTTED));
            } else {
                this.myNormalToHide.add(LinearGraphUtils.getEdge(this.myGraph, up, down));
            }
        }

        public void replaceEdge(int up, int down) {
            if (!this.myDottedEdges.hasEdge(up, down)) {
                this.myToReplace.add(LinearGraphUtils.getEdge(this.myGraph, up, down));
            }
        }

        public void apply() {
            for (GraphEdge e : this.myNormalToHide) {
                this.myHiddenEdges.createEdge(e);
            }
            for (GraphEdge e : this.myDottedToHide) {
                this.myDottedEdges.removeEdge(e);
                this.myHiddenEdges.createEdge(e);
            }
            for (GraphEdge e : this.myToAdd) {
                this.myDottedEdges.createEdge(e);
            }
            for (GraphEdge e : this.myToReplace) {
                this.myHiddenEdges.createEdge(e);
                this.myDottedEdges.createEdge(new GraphEdge(e.getUpNodeIndex(), e.getDownNodeIndex(), null, GraphEdgeType.DOTTED));
            }
            this.clear();
        }

        public void clear() {
            this.myToAdd.clear();
            this.myToReplace.clear();
            this.myNormalToHide.clear();
            this.myDottedToHide.clear();
        }

        public LinearBekGraph createLinearBekGraph() {
            return new LinearBekGraph(this.myGraph, this.myHiddenEdges, this.myDottedEdges);
        }
    }

    private static class GraphEdgeComparator
    implements Comparator<GraphEdge> {
        private GraphEdgeComparator() {
        }

        @Override
        public int compare(@NotNull GraphEdge o1, @NotNull GraphEdge o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/vcs/log/graph/linearBek/LinearBekGraphBuilder$GraphEdgeComparator", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/vcs/log/graph/linearBek/LinearBekGraphBuilder$GraphEdgeComparator", "compare"));
            }
            Integer d1 = o1.getDownNodeIndex();
            Integer d2 = o2.getDownNodeIndex();
            if (d1 == null) {
                if (d2 == null) {
                    return 0;
                }
                return 1;
            }
            if (d2 == null) {
                return -1;
            }
            return d1.compareTo(d2);
        }
    }
}

