/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.FindPopupWithProgress;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;

public class GoToRefAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        final VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || log == null) {
            return;
        }
        List refs = ContainerUtil.map((Collection)log.getAllReferences(), (Function)new Function<VcsRef, String>(){

            public String fun(VcsRef ref) {
                return ref.getName();
            }
        });
        FindPopupWithProgress popup = new FindPopupWithProgress(project, refs, new Function<String, Future>(){

            public Future fun(String text) {
                return log.jumpToReference(text);
            }
        });
        popup.showUnderneathOf(log.getToolbar());
    }

    public void update(AnActionEvent e) {
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && log != null);
    }
}

