/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.committed.RepositoryChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.graph.impl.facade.bek.BekSorter;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.frame.BranchesPanel;
import com.intellij.vcs.log.ui.frame.DetailsPanel;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import icons.VcsLogIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainFrame
extends JPanel
implements TypeSafeDataProvider {
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    private final VcsLogUiImpl myUI;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLog myLog;
    @NotNull
    private final VcsLogClassicFilterUi myFilterUi;
    @NotNull
    private final JBLoadingPanel myChangesLoadingPane;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final BranchesPanel myBranchesPanel;
    @NotNull
    private final DetailsPanel myDetailsPanel;
    @NotNull
    private final Splitter myDetailsSplitter;
    @NotNull
    private final JComponent myToolbar;
    @NotNull
    private final RepositoryChangesBrowser myChangesBrowser;

    public MainFrame(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiImpl vcsLogUI, @NotNull Project project, @NotNull VcsLogSettings settings, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLog log, @NotNull VisiblePack initialDataPack) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (vcsLogUI == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsLogUI", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataPack", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        this.myLogDataHolder = logDataHolder;
        this.myUI = vcsLogUI;
        this.myProject = project;
        this.myUiProperties = uiProperties;
        this.myLog = log;
        this.myFilterUi = new VcsLogClassicFilterUi(this.myUI, logDataHolder, uiProperties, initialDataPack);
        this.myGraphTable = new VcsLogGraphTable(vcsLogUI, logDataHolder, initialDataPack);
        this.myBranchesPanel = new BranchesPanel(logDataHolder, vcsLogUI, initialDataPack.getRefsModel());
        this.myBranchesPanel.setVisible(settings.isShowBranchesPanel());
        this.myDetailsPanel = new DetailsPanel(logDataHolder, this.myGraphTable, vcsLogUI.getColorManager(), initialDataPack);
        this.myChangesBrowser = new RepositoryChangesBrowser(project, null, Collections.<Change>emptyList(), null);
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(CommonShortcuts.getDiff(), (JComponent)((Object)this.getGraphTable()));
        this.myChangesBrowser.getEditSourceAction().registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)((Object)this.getGraphTable()));
        MainFrame.setDefaultEmptyText(this.myChangesBrowser);
        this.myChangesLoadingPane = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project);
        this.myChangesLoadingPane.add((Component)this.myChangesBrowser);
        CommitSelectionListener selectionChangeListener = new CommitSelectionListener(this.myChangesBrowser);
        this.myGraphTable.getSelectionModel().addListSelectionListener(selectionChangeListener);
        this.myGraphTable.getSelectionModel().addListSelectionListener(this.myDetailsPanel);
        this.updateWhenDetailsAreLoaded(selectionChangeListener);
        this.myToolbar = this.createActionsToolbar();
        this.myDetailsSplitter = new Splitter(true, 0.7f);
        this.myDetailsSplitter.setFirstComponent((JComponent)this.setupScrolledGraph());
        this.setupDetailsSplitter(this.myUiProperties.isShowDetails());
        JPanel toolbars = new JPanel(new BorderLayout());
        toolbars.add((Component)this.myToolbar, "North");
        toolbars.add((Component)this.myBranchesPanel, "Center");
        JPanel toolbarsAndTable = new JPanel(new BorderLayout());
        toolbarsAndTable.add((Component)toolbars, "North");
        toolbarsAndTable.add((Component)this.myDetailsSplitter, "Center");
        final Splitter changesBrowserSplitter = new Splitter(false, 0.7f);
        changesBrowserSplitter.setFirstComponent((JComponent)toolbarsAndTable);
        changesBrowserSplitter.setSecondComponent((JComponent)this.myChangesLoadingPane);
        this.setLayout(new BorderLayout());
        this.add((Component)changesBrowserSplitter);
        Disposer.register((Disposable)logDataHolder, (Disposable)new Disposable(){

            public void dispose() {
                MainFrame.this.myDetailsSplitter.dispose();
                changesBrowserSplitter.dispose();
            }
        });
        this.myGraphTable.resetDefaultFocusTraversalKeys();
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new MyFocusPolicy());
    }

    public void updateDataPack(@NotNull VisiblePack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/frame/MainFrame", "updateDataPack"));
        }
        this.myFilterUi.updateDataPack(dataPack);
        this.myDetailsPanel.updateDataPack(dataPack);
        this.myGraphTable.updateDataPack(dataPack);
    }

    private void updateWhenDetailsAreLoaded(final CommitSelectionListener selectionChangeListener) {
        this.myLogDataHolder.getMiniDetailsGetter().addDetailsLoadedListener(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.myGraphTable.repaint();
            }
        });
        this.myLogDataHolder.getCommitDetailsGetter().addDetailsLoadedListener(new Runnable(){

            @Override
            public void run() {
                selectionChangeListener.valueChanged(null);
                MainFrame.this.myDetailsPanel.valueChanged(null);
            }
        });
        this.myLogDataHolder.getContainingBranchesGetter().setTaskCompletedListener(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.myDetailsPanel.valueChanged(null);
            }
        });
    }

    public void setupDetailsSplitter(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)(state ? this.myDetailsPanel : null));
    }

    private JScrollPane setupScrolledGraph() {
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myGraphTable));
        this.myGraphTable.viewportSet(scrollPane.getViewport());
        return scrollPane;
    }

    private static void setDefaultEmptyText(ChangesBrowser changesBrowser) {
        changesBrowser.getViewer().setEmptyText("");
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myGraphTable;
        if (vcsLogGraphTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "getGraphTable"));
        }
        return vcsLogGraphTable;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        VcsLogClassicFilterUi vcsLogClassicFilterUi = this.myFilterUi;
        if (vcsLogClassicFilterUi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "getFilterUi"));
        }
        return vcsLogClassicFilterUi;
    }

    private JComponent createActionsToolbar() {
        GraphAction collapseBranchesAction = new GraphAction("Collapse linear branches", "Collapse linear branches", VcsLogIcons.CollapseBranches){

            public void actionPerformed(AnActionEvent e) {
                MainFrame.this.myUI.hideAll();
            }

            @Override
            public void update(AnActionEvent e) {
                super.update(e);
                if (!MainFrame.this.myFilterUi.getFilters().isEmpty()) {
                    e.getPresentation().setEnabled(false);
                }
            }
        };
        GraphAction expandBranchesAction = new GraphAction("Expand all branches", "Expand all branches", VcsLogIcons.ExpandBranches){

            public void actionPerformed(AnActionEvent e) {
                MainFrame.this.myUI.showAll();
            }

            @Override
            public void update(AnActionEvent e) {
                super.update(e);
                if (!MainFrame.this.myFilterUi.getFilters().isEmpty()) {
                    e.getPresentation().setEnabled(false);
                }
            }
        };
        RefreshAction refreshAction = new RefreshAction("Refresh", "Refresh", AllIcons.Actions.Refresh){

            @Override
            public void actionPerformed(AnActionEvent e) {
                MainFrame.this.myLogDataHolder.refreshCompletely();
            }

            @Override
            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(true);
            }
        };
        ShowLongEdgesAction showFullPatchAction = new ShowLongEdgesAction();
        ShowDetailsAction showDetailsAction = new ShowDetailsAction();
        refreshAction.registerShortcutOn(this);
        DefaultActionGroup toolbarGroup = new DefaultActionGroup(new AnAction[]{collapseBranchesAction, expandBranchesAction, showFullPatchAction, refreshAction, showDetailsAction});
        toolbarGroup.add(ActionManager.getInstance().getAction("Vcs.Log.Toolbar"));
        DefaultActionGroup mainGroup = new DefaultActionGroup();
        mainGroup.add((AnAction)this.myFilterUi.createActionGroup());
        mainGroup.addSeparator();
        if (BekSorter.isBekEnabled()) {
            mainGroup.add(ActionManager.getInstance().getAction("Vcs.Log.IntelliSortChooser"));
        }
        mainGroup.add((AnAction)toolbarGroup);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ChangesViewToolbar", (ActionGroup)mainGroup, true);
        toolbar.setTargetComponent((JComponent)this);
        return toolbar.getComponent();
    }

    public JComponent getMainComponent() {
        return this;
    }

    public void setBranchesPanelVisible(boolean visible) {
        this.myBranchesPanel.setVisible(visible);
    }

    @Nullable
    public List<Change> getSelectedChanges() {
        return this.myGraphTable.getSelectedChanges();
    }

    public void calcData(DataKey key, DataSink sink) {
        if (VcsLogDataKeys.VCS_LOG == key) {
            sink.put(key, (Object)this.myLog);
        } else if (VcsLogDataKeys.VCS_LOG_UI == key) {
            sink.put(key, (Object)this.myUI);
        } else if (VcsLogDataKeys.VCS_LOG_DATA_PROVIDER == key) {
            sink.put(key, (Object)this.myLogDataHolder);
        } else if (VcsDataKeys.CHANGES == key || VcsDataKeys.SELECTED_CHANGES == key) {
            List<Change> selectedChanges = this.getSelectedChanges();
            if (selectedChanges != null) {
                sink.put(key, (Object)ArrayUtil.toObjectArray(selectedChanges, Change.class));
            }
        } else if (VcsDataKeys.VCS_REVISION_NUMBERS == key) {
            List hashes = this.myUI.getVcsLog().getSelectedCommits();
            sink.put(key, (Object)ArrayUtil.toObjectArray((Collection)ContainerUtil.map((Collection)hashes, (Function)new Function<Hash, VcsRevisionNumber>(){

                public VcsRevisionNumber fun(Hash hash) {
                    return new TextRevisionNumber(hash.asString(), hash.toShortString());
                }
            }), VcsRevisionNumber.class));
        }
    }

    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myToolbar;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "getToolbar"));
        }
        return jComponent;
    }

    public boolean areGraphActionsEnabled() {
        return this.myGraphTable.getModel() instanceof GraphTableModel && this.myGraphTable.getRowCount() > 0;
    }

    public void onFiltersChange(@NotNull VcsLogFilterCollection filters) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/ui/frame/MainFrame", "onFiltersChange"));
        }
        this.myBranchesPanel.onFiltersChange(filters);
    }

    private class MyFocusPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyFocusPolicy() {
        }

        @Override
        @NotNull
        protected List<Component> getOrderedComponents() {
            List<Component> list = Arrays.asList(new Component[]{MainFrame.this.myGraphTable, MainFrame.this.myChangesBrowser.getPreferredFocusedComponent()});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame$MyFocusPolicy", "getOrderedComponents"));
            }
            return list;
        }
    }

    private abstract class GraphAction
    extends DumbAwareAction {
        public GraphAction(String text, String description, Icon icon) {
            super(text, description, icon);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(MainFrame.this.areGraphActionsEnabled());
        }
    }

    private class ShowLongEdgesAction
    extends ToggleAction
    implements DumbAware {
        public ShowLongEdgesAction() {
            super("Show long edges", "Show long branch edges even if commits are invisible in the current view.", VcsLogIcons.ShowHideLongEdges);
        }

        public boolean isSelected(AnActionEvent e) {
            return !MainFrame.this.myUI.getDataPack().getVisibleGraph().getActionController().areLongEdgesHidden();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            MainFrame.this.myUI.setLongEdgeVisibility(state);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(MainFrame.this.areGraphActionsEnabled());
        }
    }

    private class ShowDetailsAction
    extends ToggleAction
    implements DumbAware {
        public ShowDetailsAction() {
            super("Show Details", "Display details panel", AllIcons.Actions.Preview);
        }

        public boolean isSelected(AnActionEvent e) {
            return !MainFrame.this.myProject.isDisposed() && MainFrame.this.myUiProperties.isShowDetails();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            MainFrame.this.setupDetailsSplitter(state);
            if (!MainFrame.this.myProject.isDisposed()) {
                MainFrame.this.myUiProperties.setShowDetails(state);
            }
        }
    }

    private class CommitSelectionListener
    implements ListSelectionListener {
        private final ChangesBrowser myChangesBrowser;

        public CommitSelectionListener(ChangesBrowser changesBrowser) {
            this.myChangesBrowser = changesBrowser;
        }

        @Override
        public void valueChanged(@Nullable ListSelectionEvent notUsed) {
            int rows = MainFrame.this.getGraphTable().getSelectedRowCount();
            if (rows < 1) {
                MainFrame.this.myChangesLoadingPane.stopLoading();
                MainFrame.setDefaultEmptyText(this.myChangesBrowser);
                this.myChangesBrowser.setChangesToDisplay(Collections.<Change>emptyList());
            } else {
                List<Change> selectedChanges = MainFrame.this.getSelectedChanges();
                if (selectedChanges != null) {
                    MainFrame.this.myChangesLoadingPane.stopLoading();
                    this.myChangesBrowser.setChangesToDisplay(selectedChanges);
                } else {
                    this.myChangesBrowser.setChangesToDisplay(Collections.<Change>emptyList());
                    MainFrame.this.myChangesLoadingPane.startLoading();
                }
            }
        }
    }
}

