/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.BitUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.CodeFragmentInputComponent;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.evaluate.ExpressionInputComponent;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingsManager;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.nodes.EvaluatingExpressionRootNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerEvaluationDialog
extends DialogWrapper {
    private final JPanel myMainPanel;
    private final JPanel myResultPanel;
    private final XDebuggerTreePanel myTreePanel;
    private EvaluationInputComponent myInputComponent;
    private final XDebugSession mySession;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private EvaluationMode myMode;
    private XSourcePosition mySourcePosition;
    private final SwitchModeAction mySwitchModeAction;
    private final boolean myIsCodeFragmentEvaluationSupported;

    public XDebuggerEvaluationDialog(@NotNull XDebugSession session, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull XDebuggerEvaluator evaluator, @NotNull XExpression text, @Nullable XSourcePosition sourcePosition) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorsProvider", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "<init>"));
        }
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "<init>"));
        }
        super(session.getProject(), true);
        this.mySession = session;
        this.myEditorsProvider = editorsProvider;
        this.mySourcePosition = sourcePosition;
        this.setModal(false);
        this.setOKButtonText(XDebuggerBundle.message((String)"xdebugger.button.evaluate", (Object[])new Object[0]));
        this.setCancelButtonText(XDebuggerBundle.message((String)"xdebugger.evaluate.dialog.close", (Object[])new Object[0]));
        this.mySession.addSessionListener((XDebugSessionListener)new XDebugSessionAdapter(){

            public void sessionStopped() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        XDebuggerEvaluationDialog.this.close(1);
                    }
                });
            }

            public void stackFrameChanged() {
                XDebuggerEvaluationDialog.this.updateSourcePosition();
            }

            public void sessionPaused() {
                XDebuggerEvaluationDialog.this.updateSourcePosition();
            }
        }, this.myDisposable);
        this.myTreePanel = new XDebuggerTreePanel(session.getProject(), editorsProvider, this.myDisposable, sourcePosition, "XDebugger.Evaluation.Dialog.Tree.Popup", ((XDebugSessionImpl)session).getValueMarkers());
        this.myResultPanel = new JPanel(new BorderLayout());
        this.myResultPanel.add((Component)new JLabel(XDebuggerBundle.message((String)"xdebugger.evaluate.label.result", (Object[])new Object[0])), "North");
        this.myResultPanel.add((Component)this.myTreePanel.getMainPanel(), "Center");
        this.myMainPanel = new JPanel(new BorderLayout());
        this.mySwitchModeAction = new SwitchModeAction();
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                XDebuggerEvaluationDialog.this.doOKAction();
                XDebuggerEvaluationDialog.this.addToWatches();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 192)), (JComponent)this.getRootPane(), this.myDisposable);
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                IdeFocusManager.getInstance((Project)XDebuggerEvaluationDialog.this.mySession.getProject()).requestFocus((Component)((Object)XDebuggerEvaluationDialog.this.myTreePanel.getTree()), true);
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(82, 512)), (JComponent)this.getRootPane(), this.myDisposable);
        this.myTreePanel.getTree().expandNodesOnLoad(new Condition<TreeNode>(){

            public boolean value(TreeNode node) {
                return node.getParent() instanceof EvaluatingExpressionRootNode;
            }
        });
        EvaluationMode mode = XDebuggerSettingsManager.getInstanceImpl().getGeneralSettings().getEvaluationDialogMode();
        this.myIsCodeFragmentEvaluationSupported = evaluator.isCodeFragmentEvaluationSupported();
        if (mode == EvaluationMode.CODE_FRAGMENT && !this.myIsCodeFragmentEvaluationSupported) {
            mode = EvaluationMode.EXPRESSION;
        }
        if (mode == EvaluationMode.EXPRESSION && text.getMode() == EvaluationMode.CODE_FRAGMENT && this.myIsCodeFragmentEvaluationSupported) {
            mode = EvaluationMode.CODE_FRAGMENT;
        }
        this.switchToMode(mode, text);
        this.init();
    }

    private void updateSourcePosition() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                XDebuggerEvaluationDialog.this.mySourcePosition = XDebuggerEvaluationDialog.this.mySession.getCurrentPosition();
                XDebuggerEvaluationDialog.this.getInputEditor().setSourcePosition(XDebuggerEvaluationDialog.this.mySourcePosition);
            }
        });
    }

    protected void doOKAction() {
        this.evaluate();
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction = new DialogWrapper.OkAction(){

            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                if (BitUtil.isSet((int)e.getModifiers(), (int)1) || BitUtil.isSet((int)e.getModifiers(), (int)2)) {
                    XDebuggerEvaluationDialog.this.addToWatches();
                }
            }
        };
    }

    private void addToWatches() {
        XDebugSessionTab tab;
        XExpression expression;
        if (this.myMode == EvaluationMode.EXPRESSION && !XDebuggerUtilImpl.isEmptyExpression(expression = this.getInputEditor().getExpression()) && (tab = ((XDebugSessionImpl)this.mySession).getSessionTab()) != null) {
            tab.getWatchesView().addWatchExpression(expression, -1, true);
            this.requestFocusInEditor();
        }
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myIsCodeFragmentEvaluationSupported) {
            Action[] actionArray = new Action[]{this.getOKAction(), this.mySwitchModeAction, this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = super.createActions();
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "createActions"));
        }
        return actionArray;
    }

    protected String getHelpId() {
        return "debugging.debugMenu.evaluate";
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button = super.createJButtonForAction(action);
        if (action == this.mySwitchModeAction) {
            int width1 = new JButton((String)XDebuggerEvaluationDialog.getSwitchButtonText((EvaluationMode)EvaluationMode.EXPRESSION)).getPreferredSize().width;
            int width2 = new JButton((String)XDebuggerEvaluationDialog.getSwitchButtonText((EvaluationMode)EvaluationMode.CODE_FRAGMENT)).getPreferredSize().width;
            Dimension size = new Dimension(Math.max(width1, width2), button.getPreferredSize().height);
            button.setMinimumSize(size);
            button.setPreferredSize(size);
        }
        return button;
    }

    public XExpression getExpression() {
        return this.getInputEditor().getExpression();
    }

    private static String getSwitchButtonText(EvaluationMode mode) {
        return mode != EvaluationMode.EXPRESSION ? XDebuggerBundle.message((String)"button.text.expression.mode", (Object[])new Object[0]) : XDebuggerBundle.message((String)"button.text.code.fragment.mode", (Object[])new Object[0]);
    }

    private void switchToMode(EvaluationMode mode, XExpression text) {
        if (this.myMode == mode) {
            return;
        }
        this.myMode = mode;
        if (mode == EvaluationMode.EXPRESSION) {
            text = new XExpressionImpl(StringUtil.replace((String)text.getExpression(), (String)"\n", (String)" "), text.getLanguage(), text.getCustomInfo());
        }
        this.myInputComponent = this.createInputComponent(mode, text);
        this.myMainPanel.removeAll();
        this.myInputComponent.addComponent(this.myMainPanel, this.myResultPanel);
        this.setTitle(this.myInputComponent.getTitle());
        this.mySwitchModeAction.putValue("Name", XDebuggerEvaluationDialog.getSwitchButtonText(mode));
        this.requestFocusInEditor();
    }

    private void requestFocusInEditor() {
        JComponent preferredFocusedComponent = this.getInputEditor().getPreferredFocusedComponent();
        if (preferredFocusedComponent != null) {
            IdeFocusManager.getInstance((Project)this.mySession.getProject()).requestFocus((Component)preferredFocusedComponent, true);
        }
    }

    private XDebuggerEditorBase getInputEditor() {
        return this.myInputComponent.getInputEditor();
    }

    private EvaluationInputComponent createInputComponent(EvaluationMode mode, XExpression text) {
        Project project = this.mySession.getProject();
        text = XExpressionImpl.changeMode(text, mode);
        if (mode == EvaluationMode.EXPRESSION) {
            return new ExpressionInputComponent(project, this.myEditorsProvider, this.mySourcePosition, text);
        }
        return new CodeFragmentInputComponent(project, this.myEditorsProvider, this.mySourcePosition, text, this.myDisposable);
    }

    private void evaluate() {
        XDebuggerEditorBase inputEditor = this.getInputEditor();
        int offset = -1;
        Editor editor = inputEditor.getEditor();
        if (editor != null) {
            offset = editor.getCaretModel().getOffset();
        }
        XDebuggerTree tree = this.myTreePanel.getTree();
        tree.markNodesObsolete();
        tree.setRoot(new EvaluatingExpressionRootNode(this, tree), false);
        this.myResultPanel.invalidate();
        editor = inputEditor.getEditor();
        inputEditor.selectAll();
        if (offset >= 0 && editor != null) {
            offset = Math.min(editor.getDocument().getTextLength(), offset);
            editor.getCaretModel().moveToOffset(offset);
            editor.getSelectionModel().setSelection(offset, offset);
        }
    }

    protected String getDimensionServiceKey() {
        return "#xdebugger.evaluate";
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public void startEvaluation(@NotNull XDebuggerEvaluator.XEvaluationCallback evaluationCallback) {
        if (evaluationCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationCallback", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "startEvaluation"));
        }
        XDebuggerEditorBase inputEditor = this.getInputEditor();
        inputEditor.saveTextInHistory();
        XExpression expression = inputEditor.getExpression();
        XDebuggerEvaluator evaluator = this.mySession.getDebugProcess().getEvaluator();
        if (evaluator == null) {
            evaluationCallback.errorOccurred(XDebuggerBundle.message((String)"xdebugger.evaluate.stack.frame.has.not.evaluator", (Object[])new Object[0]));
        } else {
            evaluator.evaluate(expression, evaluationCallback, null);
        }
    }

    public void evaluationDone() {
        this.mySession.rebuildViews();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getInputEditor().getPreferredFocusedComponent();
    }

    private class SwitchModeAction
    extends AbstractAction {
        private SwitchModeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XExpression text = XDebuggerEvaluationDialog.this.getInputEditor().getExpression();
            EvaluationMode newMode = XDebuggerEvaluationDialog.this.myMode == EvaluationMode.EXPRESSION ? EvaluationMode.CODE_FRAGMENT : EvaluationMode.EXPRESSION;
            XDebuggerSettingsManager.getInstanceImpl().getGeneralSettings().setEvaluationDialogMode(newMode);
            XDebuggerEvaluationDialog.this.switchToMode(newMode, text);
        }
    }
}

