/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBInsets;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XDebuggerTreeRenderer
extends ColoredTreeCellRenderer {
    private final MyColoredTreeCellRenderer myLink = new MyColoredTreeCellRenderer();
    private boolean myHaveLink;
    private int myLinkOffset;
    private int myLinkWidth;

    public XDebuggerTreeRenderer() {
        Insets myLinkIpad = this.myLink.getIpad();
        this.myLink.setIpad((Insets)new JBInsets(myLinkIpad.top, 0, myLinkIpad.bottom, myLinkIpad.right));
        Insets myIpad = this.getIpad();
        this.setIpad((Insets)new JBInsets(myLinkIpad.top, myIpad.left, myLinkIpad.bottom, 0));
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRenderer", "customizeCellRenderer"));
        }
        this.myHaveLink = false;
        this.myLink.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        XDebuggerTreeNode node = (XDebuggerTreeNode)value;
        node.appendToComponent((ColoredTextContainer)this);
        this.setIcon(node.getIcon());
        if (this.myHaveLink) {
            Dimension linkSize = this.myLink.getPreferredSize();
            this.myLinkWidth = linkSize.width;
            this.myLink.setBounds(0, 0, linkSize.width, linkSize.height);
            Rectangle treeVisibleRect = tree.getVisibleRect();
            TreePath path = tree.getPathForRow(row);
            int rowX = path != null ? ((XDebuggerTree.LinkTreeUI)((Object)tree.getUI())).getRowX(row, path.getPathCount() - 1) : 0;
            this.myLinkOffset = Math.min(super.getPreferredSize().width, treeVisibleRect.x + treeVisibleRect.width - this.myLinkWidth - rowX);
        }
        this.putClientProperty("DisableExpandableHandler", this.myHaveLink ? Boolean.valueOf(true) : null);
    }

    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRenderer", "append"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRenderer", "append"));
        }
        if (tag instanceof XDebuggerTreeNodeHyperlink && ((XDebuggerTreeNodeHyperlink)tag).alwaysOnScreen()) {
            this.myHaveLink = true;
            this.myLink.append(fragment, attributes, tag);
        } else {
            super.append(fragment, attributes, tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPaint(Graphics2D g) {
        if (this.myHaveLink) {
            Graphics2D textGraphics = (Graphics2D)g.create(0, 0, this.myLinkOffset, g.getClipBounds().height);
            try {
                super.doPaint(textGraphics);
            }
            finally {
                textGraphics.dispose();
            }
            g.translate(this.myLinkOffset, 0);
            this.myLink.doPaint(g);
            g.translate(-this.myLinkOffset, 0);
        } else {
            super.doPaint(g);
        }
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.myHaveLink) {
            size.width += this.myLinkWidth;
        }
        Dimension dimension = size;
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRenderer", "getPreferredSize"));
        }
        return dimension;
    }

    @Nullable
    public Object getFragmentTagAt(int x) {
        if (this.myHaveLink) {
            return this.myLink.getFragmentTagAt(x - this.myLinkOffset);
        }
        return null;
    }

    private static class MyColoredTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MyColoredTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRenderer$MyColoredTreeCellRenderer", "customizeCellRenderer"));
            }
        }

        protected void doPaint(Graphics2D g) {
            super.doPaint(g);
        }
    }
}

