/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StandardVariableNamesInspectionBase
extends BaseInspection {
    @NonNls
    static final Map<String, String> s_expectedTypes = new HashMap<String, String>(13);
    @NonNls
    static final Map<String, String> s_boxingClasses = new HashMap<String, String>(8);
    public boolean ignoreParameterNameSameAsSuper = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("standard.variable.names.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/StandardVariableNamesInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String boxedType;
        PsiVariable variable = (PsiVariable)infos[0];
        String name = variable.getName();
        String expectedType = s_expectedTypes.get(name);
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)variable) && (boxedType = s_boxingClasses.get(expectedType)) != null) {
            String string = InspectionGadgetsBundle.message("standard.variable.names.problem.descriptor2", expectedType, boxedType);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/StandardVariableNamesInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("standard.variable.names.problem.descriptor", expectedType);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/StandardVariableNamesInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StandardVariableNamesVisitor();
    }

    static {
        s_expectedTypes.put("b", "byte");
        s_expectedTypes.put("c", "char");
        s_expectedTypes.put("ch", "char");
        s_expectedTypes.put("d", "double");
        s_expectedTypes.put("f", "float");
        s_expectedTypes.put("i", "int");
        s_expectedTypes.put("j", "int");
        s_expectedTypes.put("k", "int");
        s_expectedTypes.put("m", "int");
        s_expectedTypes.put("n", "int");
        s_expectedTypes.put("l", "long");
        s_expectedTypes.put("s", "java.lang.String");
        s_expectedTypes.put("str", "java.lang.String");
        s_boxingClasses.put("int", "java.lang.Integer");
        s_boxingClasses.put("short", "java.lang.Short");
        s_boxingClasses.put("boolean", "java.lang.Boolean");
        s_boxingClasses.put("long", "java.lang.Long");
        s_boxingClasses.put("byte", "java.lang.Byte");
        s_boxingClasses.put("float", "java.lang.Float");
        s_boxingClasses.put("double", "java.lang.Double");
        s_boxingClasses.put("char", "java.lang.Character");
    }

    private class StandardVariableNamesVisitor
    extends BaseInspectionVisitor {
        private StandardVariableNamesVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            String unboxedTypeText;
            PsiPrimitiveType unboxedType;
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/naming/StandardVariableNamesInspectionBase$StandardVariableNamesVisitor", "visitVariable"));
            }
            super.visitVariable(variable);
            String variableName = variable.getName();
            String expectedType = s_expectedTypes.get(variableName);
            if (expectedType == null) {
                return;
            }
            PsiType type = variable.getType();
            String typeText = type.getCanonicalText();
            if (expectedType.equals(typeText)) {
                return;
            }
            if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)variable) && (unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)type)) != null && expectedType.equals(unboxedTypeText = unboxedType.getCanonicalText())) {
                return;
            }
            if (StandardVariableNamesInspectionBase.this.ignoreParameterNameSameAsSuper && this.isVariableNamedSameAsSuper(variable)) {
                return;
            }
            this.registerVariableError(variable, variable);
        }

        private boolean isVariableNamedSameAsSuper(PsiVariable variable) {
            PsiMethod[] superMethods;
            if (!(variable instanceof PsiParameter)) {
                return false;
            }
            PsiParameter parameter = (PsiParameter)variable;
            PsiElement scope = parameter.getDeclarationScope();
            if (!(scope instanceof PsiMethod)) {
                return false;
            }
            String variableName = variable.getName();
            PsiMethod method = (PsiMethod)scope;
            int index = method.getParameterList().getParameterIndex(parameter);
            for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                PsiParameter[] parameters = superMethod.getParameterList().getParameters();
                PsiParameter overriddenParameter = parameters[index];
                if (!variableName.equals(overriddenParameter.getName())) continue;
                return true;
            }
            return false;
        }
    }
}

