/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.DonePromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.RejectedPromise;

public class AsyncPromise<T>
extends Promise<T>
implements Getter<T> {
    private static final Logger LOG = Logger.getInstance(AsyncPromise.class);
    private volatile Consumer<T> done;
    private volatile Consumer<Throwable> rejected;
    protected volatile Promise.State state = Promise.State.PENDING;
    private volatile Object result;

    @Override
    @NotNull
    public Promise.State getState() {
        Promise.State state = this.state;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "getState"));
        }
        return state;
    }

    @Override
    @NotNull
    public Promise<T> done(@NotNull Consumer<T> done) {
        if (done == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "org/jetbrains/concurrency/AsyncPromise", "done"));
        }
        if (AsyncPromise.isObsolete(done)) {
            AsyncPromise asyncPromise = this;
            if (asyncPromise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "done"));
            }
            return asyncPromise;
        }
        switch (this.state) {
            case PENDING: {
                break;
            }
            case FULFILLED: {
                done.consume(this.result);
                AsyncPromise asyncPromise = this;
                if (asyncPromise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "done"));
                }
                return asyncPromise;
            }
            case REJECTED: {
                AsyncPromise asyncPromise = this;
                if (asyncPromise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "done"));
                }
                return asyncPromise;
            }
        }
        this.done = AsyncPromise.setHandler(this.done, done);
        AsyncPromise asyncPromise = this;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "done"));
        }
        return asyncPromise;
    }

    @Override
    @NotNull
    public Promise<T> rejected(@NotNull Consumer<Throwable> rejected) {
        if (rejected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rejected", "org/jetbrains/concurrency/AsyncPromise", "rejected"));
        }
        if (AsyncPromise.isObsolete(rejected)) {
            AsyncPromise asyncPromise = this;
            if (asyncPromise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "rejected"));
            }
            return asyncPromise;
        }
        switch (this.state) {
            case PENDING: {
                break;
            }
            case FULFILLED: {
                AsyncPromise asyncPromise = this;
                if (asyncPromise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "rejected"));
                }
                return asyncPromise;
            }
            case REJECTED: {
                rejected.consume((Object)((Throwable)this.result));
                AsyncPromise asyncPromise = this;
                if (asyncPromise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "rejected"));
                }
                return asyncPromise;
            }
        }
        this.rejected = AsyncPromise.setHandler(this.rejected, rejected);
        AsyncPromise asyncPromise = this;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "rejected"));
        }
        return asyncPromise;
    }

    public T get() {
        return (T)(this.state == Promise.State.FULFILLED ? this.result : null);
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(final @NotNull Function<T, SUB_RESULT> fulfilled) {
        if (fulfilled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fulfilled", "org/jetbrains/concurrency/AsyncPromise", "then"));
        }
        switch (this.state) {
            case PENDING: {
                break;
            }
            case FULFILLED: {
                DonePromise<Object> donePromise = new DonePromise<Object>(fulfilled.fun(this.result));
                if (donePromise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "then"));
                }
                return donePromise;
            }
            case REJECTED: {
                RejectedPromise rejectedPromise = new RejectedPromise((Throwable)this.result);
                if (rejectedPromise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "then"));
                }
                return rejectedPromise;
            }
        }
        final AsyncPromise<T> promise = new AsyncPromise<T>();
        this.addHandlers(new Consumer<T>(){

            public void consume(T result) {
                try {
                    if (fulfilled instanceof Obsolescent && ((Obsolescent)fulfilled).isObsolete()) {
                        promise.setError(Promise.createError("Obsolete"));
                    } else {
                        promise.setResult(fulfilled.fun(result));
                    }
                }
                catch (Throwable e) {
                    promise.setError(e);
                }
            }
        }, new Consumer<Throwable>(){

            public void consume(Throwable error) {
                promise.setError(error);
            }
        });
        AsyncPromise<T> asyncPromise = promise;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "then"));
        }
        return asyncPromise;
    }

    @Override
    void notify(final @NotNull AsyncPromise<T> child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/concurrency/AsyncPromise", "notify"));
        }
        switch (this.state) {
            case PENDING: {
                break;
            }
            case FULFILLED: {
                child.setResult(this.result);
                return;
            }
            case REJECTED: {
                child.setError((Throwable)this.result);
                return;
            }
        }
        this.addHandlers(new Consumer<T>(){

            public void consume(T result) {
                try {
                    child.setResult(result);
                }
                catch (Throwable e) {
                    child.setError(e);
                }
            }
        }, new Consumer<Throwable>(){

            public void consume(Throwable error) {
                child.setError(error);
            }
        });
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(final @NotNull AsyncFunction<T, SUB_RESULT> fulfilled) {
        if (fulfilled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fulfilled", "org/jetbrains/concurrency/AsyncPromise", "then"));
        }
        switch (this.state) {
            case PENDING: {
                break;
            }
            case FULFILLED: {
                Promise<SUB_RESULT> promise = fulfilled.fun(this.result);
                if (promise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "then"));
                }
                return promise;
            }
            case REJECTED: {
                RejectedPromise rejectedPromise = new RejectedPromise((Throwable)this.result);
                if (rejectedPromise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "then"));
                }
                return rejectedPromise;
            }
        }
        final AsyncPromise<T> promise = new AsyncPromise<T>();
        Consumer<Throwable> rejectedHandler = new Consumer<Throwable>(){

            public void consume(Throwable error) {
                promise.setError(error);
            }
        };
        this.addHandlers(new Consumer<T>((Consumer)rejectedHandler){
            final /* synthetic */ Consumer val$rejectedHandler;
            {
                this.val$rejectedHandler = consumer;
            }

            public void consume(T result) {
                try {
                    fulfilled.fun(result).done(new Consumer<SUB_RESULT>(){

                        public void consume(SUB_RESULT result) {
                            try {
                                promise.setResult(result);
                            }
                            catch (Throwable e) {
                                promise.setError(e);
                            }
                        }
                    }).rejected((Consumer<Throwable>)this.val$rejectedHandler);
                }
                catch (Throwable e) {
                    promise.setError(e);
                }
            }
        }, rejectedHandler);
        AsyncPromise<T> asyncPromise = promise;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "then"));
        }
        return asyncPromise;
    }

    @Override
    @NotNull
    public Promise<T> processed(final @NotNull AsyncPromise<T> fulfilled) {
        if (fulfilled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fulfilled", "org/jetbrains/concurrency/AsyncPromise", "processed"));
        }
        switch (this.state) {
            case PENDING: {
                break;
            }
            case FULFILLED: {
                fulfilled.setResult(this.result);
                AsyncPromise asyncPromise = this;
                if (asyncPromise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "processed"));
                }
                return asyncPromise;
            }
            case REJECTED: {
                fulfilled.setError((Throwable)this.result);
                AsyncPromise asyncPromise = this;
                if (asyncPromise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "processed"));
                }
                return asyncPromise;
            }
        }
        this.addHandlers(new Consumer<T>(){

            public void consume(T result) {
                try {
                    fulfilled.setResult(result);
                }
                catch (Throwable e) {
                    fulfilled.setError(e);
                }
            }
        }, new Consumer<Throwable>(){

            public void consume(Throwable error) {
                fulfilled.setError(error);
            }
        });
        AsyncPromise asyncPromise = this;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "processed"));
        }
        return asyncPromise;
    }

    private void addHandlers(@NotNull Consumer<T> done, @NotNull Consumer<Throwable> rejected) {
        if (done == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "org/jetbrains/concurrency/AsyncPromise", "addHandlers"));
        }
        if (rejected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rejected", "org/jetbrains/concurrency/AsyncPromise", "addHandlers"));
        }
        this.done = AsyncPromise.setHandler(this.done, done);
        this.rejected = AsyncPromise.setHandler(this.rejected, rejected);
    }

    @NotNull
    private static <T> Consumer<T> setHandler(Consumer<T> oldConsumer, Consumer<T> newConsumer) {
        if (oldConsumer == null) {
            Consumer<T> consumer = newConsumer;
            if (consumer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "setHandler"));
            }
            return consumer;
        }
        if (oldConsumer instanceof CompoundConsumer) {
            ((CompoundConsumer)oldConsumer).add(newConsumer);
            Consumer<T> consumer = oldConsumer;
            if (consumer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "setHandler"));
            }
            return consumer;
        }
        CompoundConsumer<T> compoundConsumer = new CompoundConsumer<T>(oldConsumer, newConsumer);
        if (compoundConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncPromise", "setHandler"));
        }
        return compoundConsumer;
    }

    public void setResult(T result) {
        if (this.state != Promise.State.PENDING) {
            return;
        }
        this.result = result;
        this.state = Promise.State.FULFILLED;
        Consumer<T> done = this.done;
        this.clearHandlers();
        if (done != null && !AsyncPromise.isObsolete(done)) {
            done.consume(result);
        }
    }

    static boolean isObsolete(@Nullable Consumer<?> done) {
        return done instanceof Obsolescent && ((Obsolescent)done).isObsolete();
    }

    public void setError(@NotNull Throwable error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/concurrency/AsyncPromise", "setError"));
        }
        if (this.state != Promise.State.PENDING) {
            return;
        }
        this.result = error;
        this.state = Promise.State.REJECTED;
        Consumer<Throwable> rejected = this.rejected;
        this.clearHandlers();
        if (rejected != null) {
            if (!AsyncPromise.isObsolete(rejected)) {
                rejected.consume((Object)error);
            }
        } else if (!(error instanceof Promise.MessageError)) {
            LOG.error(error);
        }
    }

    private void clearHandlers() {
        this.done = null;
        this.rejected = null;
    }

    @Override
    public void processed(final @NotNull Consumer<T> processed) {
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "org/jetbrains/concurrency/AsyncPromise", "processed"));
        }
        this.done(processed);
        this.rejected(new Consumer<Throwable>(){

            public void consume(Throwable error) {
                processed.consume(null);
            }
        });
    }

    private static final class CompoundConsumer<T>
    implements Consumer<T> {
        private List<Consumer<T>> consumers;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompoundConsumer(@NotNull Consumer<T> c1, @NotNull Consumer<T> c2) {
            if (c1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c1", "org/jetbrains/concurrency/AsyncPromise$CompoundConsumer", "<init>"));
            }
            if (c2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c2", "org/jetbrains/concurrency/AsyncPromise$CompoundConsumer", "<init>"));
            }
            this.consumers = new ArrayList<Consumer<T>>();
            CompoundConsumer compoundConsumer = this;
            synchronized (compoundConsumer) {
                this.consumers.add(c1);
                this.consumers.add(c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consume(T t) {
            List<Consumer<T>> list;
            CompoundConsumer compoundConsumer = this;
            synchronized (compoundConsumer) {
                list = this.consumers;
                this.consumers = null;
            }
            if (list != null) {
                for (Consumer<T> consumer : list) {
                    if (AsyncPromise.isObsolete(consumer)) continue;
                    consumer.consume(t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull Consumer<T> consumer) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/concurrency/AsyncPromise$CompoundConsumer", "add"));
            }
            CompoundConsumer compoundConsumer = this;
            synchronized (compoundConsumer) {
                if (this.consumers != null) {
                    this.consumers.add(consumer);
                }
            }
        }
    }
}

