/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.values.ValueManager;

public abstract class EvaluateContextBase<VALUE_MANAGER extends ValueManager>
implements EvaluateContext {
    protected final VALUE_MANAGER valueManager;

    protected EvaluateContextBase(@NotNull VALUE_MANAGER valueManager) {
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "org/jetbrains/debugger/EvaluateContextBase", "<init>"));
        }
        this.valueManager = valueManager;
    }

    @Override
    @NotNull
    public Promise<EvaluateResult> evaluate(@NotNull String expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/debugger/EvaluateContextBase", "evaluate"));
        }
        Promise<EvaluateResult> promise = this.evaluate(expression, null, false);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/EvaluateContextBase", "evaluate"));
        }
        return promise;
    }

    @Override
    @NotNull
    public Promise<EvaluateResult> evaluate(@NotNull String expression, boolean enableBreak) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/debugger/EvaluateContextBase", "evaluate"));
        }
        Promise<EvaluateResult> promise = this.evaluate(expression, null, true);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/EvaluateContextBase", "evaluate"));
        }
        return promise;
    }

    @Override
    @NotNull
    public EvaluateContext withValueManager(@NotNull String objectGroup) {
        if (objectGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectGroup", "org/jetbrains/debugger/EvaluateContextBase", "withValueManager"));
        }
        EvaluateContextBase evaluateContextBase = this;
        if (evaluateContextBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/EvaluateContextBase", "withValueManager"));
        }
        return evaluateContextBase;
    }

    @Override
    public void releaseObjects() {
    }

    @Override
    @NotNull
    public abstract Promise<EvaluateResult> evaluate(@NotNull String var1, @Nullable Map<String, Object> var2, boolean var3);

    @NotNull
    public final VALUE_MANAGER getValueManager() {
        VALUE_MANAGER VALUE_MANAGER = this.valueManager;
        if (VALUE_MANAGER == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/EvaluateContextBase", "getValueManager"));
        }
        return VALUE_MANAGER;
    }

    @Override
    @NotNull
    public Promise<?> refreshOnDone(@NotNull Promise<?> promise) {
        if (promise == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promise", "org/jetbrains/debugger/EvaluateContextBase", "refreshOnDone"));
        }
        Promise<Void> promise2 = promise.then(((ValueManager)this.valueManager).getClearCachesTask());
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/EvaluateContextBase", "refreshOnDone"));
        }
        return promise2;
    }
}

