/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XSourcePositionWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceInfo
extends XSourcePositionWrapper {
    private final String functionName;
    private final int column;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static SourceInfo create(@Nullable String functionName, @Nullable VirtualFile file, int line, int column) {
        XSourcePosition position;
        if (file == null) {
            return null;
        }
        AccessToken token = ReadAction.start();
        try {
            position = XDebuggerUtil.getInstance().createPosition(file, line);
        }
        finally {
            token.finish();
        }
        return position == null ? null : new SourceInfo(functionName, position, column);
    }

    private SourceInfo(@Nullable String functionName, @NotNull XSourcePosition position, int column) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/debugger/SourceInfo", "<init>"));
        }
        super(position);
        this.functionName = functionName;
        this.column = column;
    }

    @Nullable
    public String getFunctionName() {
        return this.functionName;
    }

    public int getColumn() {
        return this.column;
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/debugger/SourceInfo", "createNavigatable"));
        }
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, this.myPosition.getFile(), this.myPosition.getLine(), this.column);
        if (openFileDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SourceInfo", "createNavigatable"));
        }
        return openFileDescriptor;
    }

    public String toString() {
        return this.myPosition.getFile() + ":" + this.myPosition.getLine() + (this.column == -1 ? "" : ":" + this.getColumn());
    }
}

