/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.fastCgi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.fastCgi.FastCgiResponse;
import org.jetbrains.fastCgi.FastCgiService;
import org.jetbrains.io.Responses;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;

@ChannelHandler.Sharable
public class FastCgiChannelHandler
extends SimpleChannelInboundHandlerAdapter<FastCgiResponse> {
    private final ConcurrentIntObjectMap<Channel> requestToChannel;

    public FastCgiChannelHandler(@NotNull ConcurrentIntObjectMap<Channel> channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/fastCgi/FastCgiChannelHandler", "<init>"));
        }
        this.requestToChannel = channel;
    }

    @Override
    protected void messageReceived(ChannelHandlerContext context, FastCgiResponse response) throws Exception {
        ByteBuf buffer = response.getData();
        Channel channel = (Channel)this.requestToChannel.remove(response.getId());
        if (channel == null || !channel.isActive()) {
            if (buffer != null) {
                buffer.release();
            }
            return;
        }
        if (buffer == null) {
            Responses.sendStatus(HttpResponseStatus.BAD_GATEWAY, channel);
            return;
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buffer);
        try {
            FastCgiChannelHandler.parseHeaders((HttpResponse)httpResponse, buffer);
            Responses.addServer((HttpResponse)httpResponse);
            if (!HttpHeaders.isContentLengthSet((HttpMessage)httpResponse)) {
                HttpHeaders.setContentLength((HttpMessage)httpResponse, (long)buffer.readableBytes());
            }
        }
        catch (Throwable e) {
            buffer.release();
            Responses.sendStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR, channel);
            FastCgiService.LOG.error(e);
        }
        channel.writeAndFlush((Object)httpResponse);
    }

    private static void parseHeaders(HttpResponse response, ByteBuf buffer) {
        StringBuilder builder = new StringBuilder();
        while (buffer.isReadable()) {
            byte b;
            builder.setLength(0);
            String key = null;
            boolean valueExpected = true;
            while ((b = buffer.readByte()) >= 0 && b != 10) {
                if (b == 13) continue;
                if (valueExpected && b == 58) {
                    valueExpected = false;
                    key = builder.toString();
                    builder.setLength(0);
                    FastCgiChannelHandler.skipWhitespace(buffer);
                    continue;
                }
                builder.append((char)b);
            }
            if (builder.length() == 0) {
                return;
            }
            if (StringUtil.isEmpty(key) || StringUtilRt.startsWithIgnoreCase(key, (String)"http") || StringUtilRt.startsWithIgnoreCase(key, (String)"X-Accel-")) continue;
            String value = builder.toString();
            if (key.equalsIgnoreCase("status")) {
                int index = value.indexOf(32);
                if (index == -1) {
                    FastCgiService.LOG.warn("Cannot parse status: " + value);
                    response.setStatus(HttpResponseStatus.OK);
                    continue;
                }
                response.setStatus(HttpResponseStatus.valueOf((int)Integer.parseInt(value.substring(0, index))));
                continue;
            }
            if (key.startsWith("http") || key.startsWith("HTTP")) continue;
            response.headers().add(key, (Object)value);
        }
    }

    private static void skipWhitespace(ByteBuf buffer) {
        while (buffer.isReadable() && buffer.getByte(buffer.readerIndex()) == 32) {
            buffer.skipBytes(1);
        }
    }
}

