/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.fastCgi;

import com.intellij.util.Consumer;
import gnu.trove.TIntObjectHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.CharsetUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.fastCgi.FastCgiResponse;
import org.jetbrains.fastCgi.FastCgiService;
import org.jetbrains.io.Decoder;

public class FastCgiDecoder
extends Decoder {
    private State state = State.HEADER;
    private int type;
    private int id;
    private int contentLength;
    private int paddingLength;
    private final TIntObjectHashMap<ByteBuf> dataBuffers = new TIntObjectHashMap();
    private final Consumer<String> errorOutputConsumer;

    public FastCgiDecoder(Consumer<String> errorOutputConsumer) {
        this.errorOutputConsumer = errorOutputConsumer;
    }

    @Override
    protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/fastCgi/FastCgiDecoder", "messageReceived"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/fastCgi/FastCgiDecoder", "messageReceived"));
        }
        while (true) {
            switch (this.state) {
                case HEADER: {
                    ByteBuf buffer;
                    if (this.paddingLength > 0) {
                        if (input.readableBytes() >= this.paddingLength) {
                            input.skipBytes(this.paddingLength);
                            this.paddingLength = 0;
                        } else {
                            this.paddingLength -= input.readableBytes();
                            input.skipBytes(input.readableBytes());
                            input.release();
                            return;
                        }
                    }
                    if ((buffer = this.getBufferIfSufficient(input, 8, context)) == null) {
                        input.release();
                        return;
                    }
                    this.decodeHeader(buffer);
                    this.state = State.CONTENT;
                }
                case CONTENT: {
                    ByteBuf buffer;
                    if (this.contentLength > 0) {
                        buffer = this.getBufferIfSufficient(input, this.contentLength, context);
                        if (buffer == null) {
                            input.release();
                            return;
                        }
                        FastCgiResponse response = this.readContent(buffer);
                        if (response != null) {
                            context.fireChannelRead((Object)response);
                        }
                    }
                    this.state = State.HEADER;
                }
            }
        }
    }

    private void decodeHeader(ByteBuf buffer) {
        buffer.skipBytes(1);
        this.type = buffer.readUnsignedByte();
        this.id = buffer.readUnsignedShort();
        this.contentLength = buffer.readUnsignedShort();
        this.paddingLength = buffer.readUnsignedByte();
        buffer.skipBytes(1);
    }

    private FastCgiResponse readContent(ByteBuf buffer) {
        switch (this.type) {
            case 3: {
                int appStatus = buffer.readInt();
                short protocolStatus = buffer.readUnsignedByte();
                buffer.skipBytes(3);
                if (appStatus != 0 || protocolStatus != ProtocolStatus.REQUEST_COMPLETE.ordinal()) {
                    FastCgiService.LOG.warn("Protocol status " + protocolStatus);
                    this.dataBuffers.remove(this.id);
                    return new FastCgiResponse(this.id, null);
                }
                if (protocolStatus != ProtocolStatus.REQUEST_COMPLETE.ordinal()) break;
                return new FastCgiResponse(this.id, (ByteBuf)this.dataBuffers.remove(this.id));
            }
            case 6: {
                ByteBuf data = (ByteBuf)this.dataBuffers.get(this.id);
                ByteBuf sliced = buffer.slice(buffer.readerIndex(), this.contentLength);
                if (data == null) {
                    this.dataBuffers.put(this.id, (Object)sliced);
                } else if (data instanceof CompositeByteBuf) {
                    ((CompositeByteBuf)data).addComponent(sliced);
                    data.writerIndex(data.writerIndex() + sliced.readableBytes());
                } else {
                    this.dataBuffers.put(this.id, (Object)Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{data, sliced}));
                }
                sliced.retain();
                buffer.skipBytes(this.contentLength);
                break;
            }
            case 7: {
                try {
                    this.errorOutputConsumer.consume((Object)buffer.toString(buffer.readerIndex(), this.contentLength, CharsetUtil.UTF_8));
                }
                catch (Throwable e) {
                    FastCgiService.LOG.error(e);
                }
                buffer.skipBytes(this.contentLength);
                break;
            }
            default: {
                FastCgiService.LOG.error("Unknown type " + this.type);
            }
        }
        return null;
    }

    public static final class RecordType {
        public static final int END_REQUEST = 3;
        public static final int STDOUT = 6;
        public static final int STDERR = 7;
    }

    private static enum ProtocolStatus {
        REQUEST_COMPLETE,
        CANT_MPX_CONN,
        OVERLOADED,
        UNKNOWN_ROLE;

    }

    private static enum State {
        HEADER,
        CONTENT;

    }
}

