/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.fastCgi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.fastCgi.FastCgiService;
import org.jetbrains.io.Responses;

public class FastCgiRequest {
    private static final int PARAMS = 4;
    private static final int BEGIN_REQUEST = 1;
    private static final int RESPONDER = 1;
    private static final int FCGI_KEEP_CONNECTION = 1;
    private static final int STDIN = 5;
    private static final int VERSION = 1;
    private final ByteBuf buffer;
    final int requestId;

    public FastCgiRequest(int requestId, @NotNull ByteBufAllocator allocator) {
        if (allocator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allocator", "org/jetbrains/fastCgi/FastCgiRequest", "<init>"));
        }
        this.requestId = requestId;
        this.buffer = allocator.buffer();
        this.writeHeader(this.buffer, 1, 8);
        this.buffer.writeShort(1);
        this.buffer.writeByte(1);
        this.buffer.writeZero(5);
    }

    public void writeFileHeaders(@NotNull VirtualFile file, @NotNull Project project, @NotNull CharSequence canonicalRequestPath) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/fastCgi/FastCgiRequest", "writeFileHeaders"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/fastCgi/FastCgiRequest", "writeFileHeaders"));
        }
        if (canonicalRequestPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canonicalRequestPath", "org/jetbrains/fastCgi/FastCgiRequest", "writeFileHeaders"));
        }
        PathInfo root = WebServerPathToFileManager.getInstance(project).getRoot(file);
        FastCgiService.LOG.assertTrue(root != null);
        this.addHeader("DOCUMENT_ROOT", root.getRoot().getPath());
        this.addHeader("SCRIPT_FILENAME", file.getPath());
        this.addHeader("SCRIPT_NAME", canonicalRequestPath);
    }

    public final void addHeader(@NotNull String key, @Nullable CharSequence value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/fastCgi/FastCgiRequest", "addHeader"));
        }
        if (value == null) {
            return;
        }
        int keyLength = key.length();
        int valLength = value.length();
        this.writeHeader(this.buffer, 4, keyLength + valLength + (keyLength < 128 ? 1 : 4) + (valLength < 128 ? 1 : 4));
        if (keyLength < 128) {
            this.buffer.writeByte(keyLength);
        } else {
            this.buffer.writeByte(0x80 | keyLength >> 24);
            this.buffer.writeByte(keyLength >> 16);
            this.buffer.writeByte(keyLength >> 8);
            this.buffer.writeByte(keyLength);
        }
        if (valLength < 128) {
            this.buffer.writeByte(valLength);
        } else {
            this.buffer.writeByte(0x80 | valLength >> 24);
            this.buffer.writeByte(valLength >> 16);
            this.buffer.writeByte(valLength >> 8);
            this.buffer.writeByte(valLength);
        }
        this.buffer.writeBytes(key.getBytes(CharsetUtil.US_ASCII));
        this.buffer.writeBytes(Unpooled.copiedBuffer((CharSequence)value, (Charset)CharsetUtil.UTF_8));
    }

    public void writeHeaders(FullHttpRequest request, Channel clientChannel) {
        this.addHeader("REQUEST_URI", request.uri());
        this.addHeader("REQUEST_METHOD", request.method().name());
        InetSocketAddress remote = (InetSocketAddress)clientChannel.remoteAddress();
        this.addHeader("REMOTE_ADDR", remote.getAddress().getHostAddress());
        this.addHeader("REMOTE_PORT", Integer.toString(remote.getPort()));
        InetSocketAddress local = (InetSocketAddress)clientChannel.localAddress();
        this.addHeader("SERVER_SOFTWARE", Responses.getServerHeaderValue());
        this.addHeader("SERVER_NAME", Responses.getServerHeaderValue());
        this.addHeader("SERVER_ADDR", local.getAddress().getHostAddress());
        this.addHeader("SERVER_PORT", Integer.toString(local.getPort()));
        this.addHeader("GATEWAY_INTERFACE", "CGI/1.1");
        this.addHeader("SERVER_PROTOCOL", request.protocolVersion().text());
        this.addHeader("CONTENT_TYPE", request.headers().get("Content-Type"));
        this.addHeader("REDIRECT_STATUS", "200");
        String queryString = "";
        int queryIndex = request.uri().indexOf(63);
        if (queryIndex != -1) {
            queryString = request.uri().substring(queryIndex + 1);
        }
        this.addHeader("QUERY_STRING", queryString);
        this.addHeader("CONTENT_LENGTH", String.valueOf(request.content().readableBytes()));
        for (Map.Entry entry : request.headers()) {
            this.addHeader("HTTP_" + ((String)entry.getKey()).replace('-', '_').toUpperCase(Locale.ENGLISH), (CharSequence)entry.getValue());
        }
    }

    final void writeToServerChannel(ByteBuf content, Channel fastCgiChannel) {
        this.writeHeader(this.buffer, 4, 0);
        fastCgiChannel.write((Object)this.buffer);
        if (content.isReadable()) {
            ByteBuf headerBuffer = fastCgiChannel.alloc().buffer(8, 8);
            this.writeHeader(headerBuffer, 5, content.readableBytes());
            fastCgiChannel.write((Object)headerBuffer);
            fastCgiChannel.write((Object)content);
            headerBuffer = fastCgiChannel.alloc().buffer(8, 8);
            this.writeHeader(headerBuffer, 5, 0);
            fastCgiChannel.write((Object)headerBuffer);
        } else {
            content.release();
        }
        fastCgiChannel.flush();
    }

    private void writeHeader(ByteBuf buffer, int type, int length) {
        buffer.writeByte(1);
        buffer.writeByte(type);
        buffer.writeShort(this.requestId);
        buffer.writeShort(length);
        buffer.writeZero(2);
    }
}

