/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.fastCgi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.SingleConnectionNetService;
import org.jetbrains.fastCgi.FastCgiChannelHandler;
import org.jetbrains.fastCgi.FastCgiDecoder;
import org.jetbrains.fastCgi.FastCgiRequest;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;

public abstract class FastCgiService
extends SingleConnectionNetService {
    static final Logger LOG = Logger.getInstance(FastCgiService.class);
    private final AtomicInteger requestIdCounter;
    protected final ConcurrentIntObjectMap<Channel> requests;

    public FastCgiService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/fastCgi/FastCgiService", "<init>"));
        }
        super(project);
        this.requestIdCounter = new AtomicInteger();
        this.requests = ContainerUtil.createConcurrentIntObjectMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeProcessConnections() {
        try {
            super.closeProcessConnections();
        }
        finally {
            this.requestIdCounter.set(0);
            if (!this.requests.isEmpty()) {
                List waitingClients = ContainerUtil.toList((Enumeration)this.requests.elements());
                this.requests.clear();
                for (Channel channel : waitingClients) {
                    try {
                        if (!channel.isActive()) continue;
                        Responses.sendStatus(HttpResponseStatus.BAD_GATEWAY, channel);
                    }
                    catch (Throwable e) {
                        NettyUtil.log(e, LOG);
                    }
                }
            }
        }
    }

    @Override
    protected void configureBootstrap(@NotNull Bootstrap bootstrap, final @NotNull Consumer<String> errorOutputConsumer) {
        if (bootstrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bootstrap", "org/jetbrains/fastCgi/FastCgiService", "configureBootstrap"));
        }
        if (errorOutputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorOutputConsumer", "org/jetbrains/fastCgi/FastCgiService", "configureBootstrap"));
        }
        final FastCgiChannelHandler fastCgiChannelHandler = new FastCgiChannelHandler(this.requests);
        bootstrap.handler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{new FastCgiDecoder((Consumer<String>)errorOutputConsumer), fastCgiChannelHandler, ChannelExceptionHandler.getInstance()});
            }
        });
    }

    public void send(final FastCgiRequest fastCgiRequest, final ByteBuf content) {
        content.retain();
        if (this.processHandler.has()) {
            fastCgiRequest.writeToServerChannel(content, this.processChannel);
        } else {
            this.processHandler.get().doWhenDone(new Runnable(){

                @Override
                public void run() {
                    fastCgiRequest.writeToServerChannel(content, FastCgiService.this.processChannel);
                }
            }).doWhenRejected(new Runnable(){

                @Override
                public void run() {
                    content.release();
                    Channel channel = (Channel)FastCgiService.this.requests.get(fastCgiRequest.requestId);
                    if (channel != null && channel.isActive()) {
                        Responses.sendStatus(HttpResponseStatus.BAD_GATEWAY, channel);
                    }
                }
            });
        }
    }

    public int allocateRequestId(Channel channel) {
        int requestId = this.requestIdCounter.getAndIncrement();
        if (requestId >= Short.MAX_VALUE) {
            this.requestIdCounter.set(0);
            requestId = this.requestIdCounter.getAndDecrement();
        }
        this.requests.put(requestId, (Object)channel);
        return requestId;
    }
}

