/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Decoder
extends ChannelInboundHandlerAdapter {
    protected ByteBuf cumulation;

    public final void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        if (message instanceof ByteBuf) {
            this.messageReceived(context, (ByteBuf)message);
        } else {
            context.fireChannelRead(message);
        }
    }

    protected abstract void messageReceived(@NotNull ChannelHandlerContext var1, @NotNull ByteBuf var2) throws Exception;

    @Nullable
    protected final ByteBuf getBufferIfSufficient(@NotNull ByteBuf input, int requiredLength, @NotNull ChannelHandlerContext context) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/io/Decoder", "getBufferIfSufficient"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/Decoder", "getBufferIfSufficient"));
        }
        if (!input.isReadable()) {
            return null;
        }
        if (this.cumulation == null) {
            if (input.readableBytes() < requiredLength) {
                this.cumulation = context.channel().config().getAllocator().buffer(requiredLength);
                this.cumulation.writeBytes(input);
                return null;
            }
            return input;
        }
        if (this.cumulation.readableBytes() + input.readableBytes() < requiredLength) {
            this.cumulation.writeBytes(input);
            return null;
        }
        ByteBuf buffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.cumulation, input});
        input.skipBytes(input.readableBytes());
        this.cumulation = null;
        return buffer;
    }
}

