/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharSequenceBackedByArray;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;
import org.jetbrains.io.jsonRpc.JsonServiceInvocator;
import org.jetbrains.io.webSocket.Client;
import org.jetbrains.io.webSocket.ExceptionHandler;
import org.jetbrains.io.webSocket.MessageServer;
import org.jetbrains.io.webSocket.WebSocketServer;

public class JsonRpcServer
implements MessageServer {
    protected static final Logger LOG = Logger.getInstance(JsonRpcServer.class);
    private static final TypeAdapterFactory INT_LIST_TYPE_ADAPTER_FACTORY = new TypeAdapterFactory(){
        private IntArrayListTypeAdapter<TIntArrayList> typeAdapter;

        @Nullable
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getType() != TIntArrayList.class) {
                return null;
            }
            if (this.typeAdapter == null) {
                this.typeAdapter = new IntArrayListTypeAdapter();
            }
            return this.typeAdapter;
        }
    };
    private final AtomicInteger messageIdCounter;
    private final WebSocketServer webSocketServer;
    private final ExceptionHandler exceptionHandler;
    private final Gson gson;
    private final Map<String, NotNullLazyValue> domains;

    public JsonRpcServer(@NotNull WebSocketServer webSocketServer, @NotNull ExceptionHandler exceptionHandler) {
        if (webSocketServer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webSocketServer", "org/jetbrains/io/jsonRpc/JsonRpcServer", "<init>"));
        }
        if (exceptionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionHandler", "org/jetbrains/io/jsonRpc/JsonRpcServer", "<init>"));
        }
        this.messageIdCounter = new AtomicInteger();
        this.domains = new THashMap();
        this.webSocketServer = webSocketServer;
        this.exceptionHandler = exceptionHandler;
        this.gson = new GsonBuilder().registerTypeAdapter(CharSequenceBackedByArray.class, (Object)new JsonSerializer<CharSequenceBackedByArray>(){

            public JsonElement serialize(CharSequenceBackedByArray src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString());
            }
        }).registerTypeAdapterFactory(INT_LIST_TYPE_ADAPTER_FACTORY).disableHtmlEscaping().create();
    }

    public void registerDomain(@NotNull String name, @NotNull NotNullLazyValue commands) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/io/jsonRpc/JsonRpcServer", "registerDomain"));
        }
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "org/jetbrains/io/jsonRpc/JsonRpcServer", "registerDomain"));
        }
        this.registerDomain(name, commands, false);
    }

    public void registerDomain(@NotNull String name, @NotNull NotNullLazyValue commands, boolean overridable) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/io/jsonRpc/JsonRpcServer", "registerDomain"));
        }
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "org/jetbrains/io/jsonRpc/JsonRpcServer", "registerDomain"));
        }
        if (this.domains.containsKey(name)) {
            if (overridable) {
                return;
            }
            throw new IllegalArgumentException(name + " is already registered");
        }
        this.domains.put(name, commands);
    }

    @Override
    public void message(@NotNull Client client, String message) throws IOException {
        Object[] parameters;
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "message"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("IN " + message);
        }
        JsonReaderEx reader = new JsonReaderEx(message);
        reader.beginArray();
        int messageId = reader.peek() == JsonToken.NUMBER ? reader.nextInt() : -1;
        String domainName = reader.nextString();
        if (domainName.length() == 1) {
            AsyncResult asyncResult = this.webSocketServer.removeAsyncResult(client, messageId);
            if (domainName.charAt(0) == 'r') {
                if (asyncResult == null) {
                    LOG.error("Response with id " + messageId + " was already processed");
                    return;
                }
                asyncResult.setDone(JsonUtil.nextAny(reader));
            } else {
                asyncResult.setRejected();
            }
            return;
        }
        NotNullLazyValue domainHolder = this.domains.get(domainName);
        if (domainHolder == null) {
            LOG.error("Cannot find domain " + domainName);
            return;
        }
        Object domain = domainHolder.getValue();
        String command = reader.nextString();
        if (domain instanceof JsonServiceInvocator) {
            ((JsonServiceInvocator)domain).invoke(command, client, reader, message, messageId);
            return;
        }
        if (reader.hasNext()) {
            SmartList list = new SmartList();
            JsonUtil.readListBody(reader, list);
            parameters = ArrayUtil.toObjectArray((Collection)list);
        } else {
            parameters = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        reader.endArray();
        LOG.assertTrue(reader.peek() == JsonToken.END_DOCUMENT);
        try {
            boolean isStatic = domain instanceof Class;
            Method[] methods = isStatic ? ((Class)domain).getDeclaredMethods() : domain.getClass().getMethods();
            for (Method method : methods) {
                ByteBuf response;
                if (!method.getName().equals(command)) continue;
                method.setAccessible(true);
                Object result = method.invoke(isStatic ? null : domain, parameters);
                if (messageId != -1 && (response = this.encodeMessage(messageId, null, null, new Object[]{result})) != null) {
                    this.webSocketServer.sendResponse(client, response);
                }
                return;
            }
            throw new NoSuchMethodException(command);
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public void sendResponse(int messageId, @NotNull Client client, @Nullable CharSequence rawMessage) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendResponse"));
        }
        ByteBuf response = this.encodeMessage(messageId, null, null, rawMessage, ArrayUtil.EMPTY_OBJECT_ARRAY);
        assert (response != null);
        this.webSocketServer.sendResponse(client, response);
    }

    public void sendErrorResponse(int messageId, @NotNull Client client, @Nullable CharSequence rawMessage) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendErrorResponse"));
        }
        ByteBuf response = this.encodeMessage(messageId, "e", null, rawMessage, ArrayUtil.EMPTY_OBJECT_ARRAY);
        assert (response != null);
        this.webSocketServer.sendResponse(client, response);
    }

    public void send(String domain, String name) {
        this.send(domain, name, null, new Object[0]);
    }

    public <T> void send(String domain, String command, @Nullable List<AsyncResult<Pair<Client, T>>> results, Object ... params) {
        if (this.webSocketServer.hasClients()) {
            this.send(results == null ? -1 : this.messageIdCounter.getAndIncrement(), domain, command, results, params);
        }
    }

    @Nullable
    private ByteBuf encodeMessage(int messageId, @Nullable String domain, @Nullable String command, Object[] params) {
        return this.encodeMessage(messageId, domain, command, null, params);
    }

    @Nullable
    private ByteBuf encodeMessage(int messageId, @Nullable String domain, @Nullable String command, @Nullable CharSequence rawMessage, @Nullable Object[] params) {
        StringBuilder sb = new StringBuilder();
        try {
            this.encodeCall(sb, messageId, domain, command, params, rawMessage);
            if (LOG.isDebugEnabled()) {
                LOG.debug("OUT " + sb.toString());
            }
            return Unpooled.copiedBuffer((CharSequence)sb, (Charset)CharsetUtil.UTF_8);
        }
        catch (IOException e) {
            this.exceptionHandler.exceptionCaught(e);
            return null;
        }
    }

    public boolean sendWithRawPart(Client client, String domain, String command, @Nullable CharSequence rawMessage, Object ... params) {
        ByteBuf message = this.encodeMessage(-1, domain, command, rawMessage, params);
        if (message != null) {
            this.webSocketServer.send(client, -1, message);
        }
        return message != null;
    }

    public void send(Client client, String domain, String command, Object ... params) {
        this.sendWithRawPart(client, domain, command, null, params);
    }

    public <T> AsyncResult<T> call(Client client, String domain, String command, Object ... params) {
        int messageId = this.messageIdCounter.getAndIncrement();
        ByteBuf message = this.encodeMessage(messageId, domain, command, params);
        if (message == null) {
            return new AsyncResult.Rejected();
        }
        AsyncResult.Rejected result = this.webSocketServer.send(client, messageId, message);
        return result == null ? new AsyncResult.Rejected() : result;
    }

    private <T> void send(int messageId, @Nullable String domain, @Nullable String command, @Nullable List<AsyncResult<Pair<Client, T>>> results, Object[] params) {
        ByteBuf message = this.encodeMessage(messageId, domain, command, params);
        if (message != null) {
            this.doSend(messageId, results, message);
        }
    }

    protected <T> void doSend(int messageId, List<AsyncResult<Pair<Client, T>>> results, ByteBuf message) {
        this.webSocketServer.send(messageId, message, results);
    }

    private void encodeCall(StringBuilder sb, int id, @Nullable String domain, @Nullable String command, @Nullable Object[] params, @Nullable CharSequence rawData) throws IOException {
        sb.append('[');
        boolean hasPrev = false;
        if (id != -1) {
            sb.append(id);
            hasPrev = true;
        }
        if (domain != null) {
            if (hasPrev) {
                sb.append(',');
            }
            sb.append('\"').append(domain).append("\",\"");
            if (command == null) {
                if (rawData != null) {
                    sb.append(rawData);
                }
                sb.append('\"');
                return;
            }
            sb.append(command).append('\"');
        }
        this.encodeParameters(sb, params == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : params, rawData);
        sb.append(']');
    }

    private void encodeParameters(StringBuilder sb, Object[] params, @Nullable CharSequence rawData) throws IOException {
        if (params.length == 0 && rawData == null) {
            return;
        }
        JsonWriter writer = null;
        sb.append(',').append('[');
        boolean hasPrev = false;
        for (Object param : params) {
            if (hasPrev) {
                sb.append(',');
            } else {
                hasPrev = true;
            }
            if (param instanceof CharSequence) {
                JsonUtil.escape((CharSequence)param, sb);
                continue;
            }
            if (param == null) {
                sb.append("null");
                continue;
            }
            if (param instanceof Number || param instanceof Boolean) {
                sb.append(param.toString());
                continue;
            }
            if (param instanceof Consumer) {
                ((Consumer)param).consume((Object)sb);
                continue;
            }
            if (writer == null) {
                writer = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
            }
            this.gson.getAdapter(param.getClass()).write(writer, param);
        }
        if (rawData != null) {
            if (hasPrev) {
                sb.append(',');
            }
            sb.append(rawData);
        }
        sb.append(']');
    }

    private static class IntArrayListTypeAdapter<T>
    extends TypeAdapter<T> {
        private IntArrayListTypeAdapter() {
        }

        public void write(final JsonWriter out, T value) throws IOException {
            final Ref error = new Ref();
            out.beginArray();
            ((TIntArrayList)value).forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    try {
                        out.value((long)value);
                    }
                    catch (IOException e) {
                        error.set((Object)e);
                    }
                    return error.isNull();
                }
            });
            if (!error.isNull()) {
                throw (IOException)error.get();
            }
            out.endArray();
        }

        public T read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

