/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import java.util.Enumeration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.webSocket.ExceptionHandler;

public abstract class Client
extends UserDataHolderBase {
    protected final Channel channel;
    final ConcurrentIntObjectMap<AsyncResult> messageCallbackMap;

    protected Client(@NotNull Channel channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/io/webSocket/Client", "<init>"));
        }
        this.messageCallbackMap = ContainerUtil.createConcurrentIntObjectMap();
        this.channel = channel;
    }

    @NotNull
    public EventLoop getEventLoop() {
        EventLoop eventLoop = this.channel.eventLoop();
        if (eventLoop == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/webSocket/Client", "getEventLoop"));
        }
        return eventLoop;
    }

    protected abstract ChannelFuture send(@NotNull ByteBuf var1);

    abstract void sendHeartbeat();

    @Nullable
    final <T> AsyncResult<T> send(int messageId, ByteBuf message) {
        ChannelFuture channelFuture = this.send(message);
        if (messageId == -1) {
            return null;
        }
        ChannelFutureAwareAsyncResult callback = new ChannelFutureAwareAsyncResult(messageId, this.messageCallbackMap);
        channelFuture.addListener(callback);
        this.messageCallbackMap.put(messageId, callback);
        return callback;
    }

    void rejectAsyncResults(ExceptionHandler exceptionHandler) {
        if (!this.messageCallbackMap.isEmpty()) {
            Enumeration elements = this.messageCallbackMap.elements();
            while (elements.hasMoreElements()) {
                try {
                    ((AsyncResult)elements.nextElement()).setRejected();
                }
                catch (Throwable e) {
                    exceptionHandler.exceptionCaught(e);
                }
            }
        }
    }

    private static final class ChannelFutureAwareAsyncResult<T>
    extends AsyncResult<T>
    implements ChannelFutureListener {
        private final int messageId;
        private final ConcurrentIntObjectMap<AsyncResult> messageCallbackMap;

        public ChannelFutureAwareAsyncResult(int messageId, ConcurrentIntObjectMap<AsyncResult> messageCallbackMap) {
            this.messageId = messageId;
            this.messageCallbackMap = messageCallbackMap;
        }

        public void setRejected() {
            super.setRejected();
            if (this.isProcessed()) {
                this.messageCallbackMap.remove(this.messageId);
            }
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!this.isProcessed() && !future.isSuccess()) {
                this.setRejected();
            }
        }
    }
}

