/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.ChannelBufferToString;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.io.webSocket.Client;
import org.jetbrains.io.webSocket.MessageServer;
import org.jetbrains.io.webSocket.WebSocketClient;
import org.jetbrains.io.webSocket.WebSocketHandshakeHandler;
import org.jetbrains.io.webSocket.WebSocketServer;

@ChannelHandler.Sharable
final class MessageChannelHandler
extends SimpleChannelInboundHandlerAdapter<WebSocketFrame> {
    private final WebSocketServer server;
    private final MessageServer messageServer;

    MessageChannelHandler(@NotNull WebSocketServer server, @NotNull MessageServer messageServer) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "org/jetbrains/io/webSocket/MessageChannelHandler", "<init>"));
        }
        if (messageServer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageServer", "org/jetbrains/io/webSocket/MessageChannelHandler", "<init>"));
        }
        this.server = server;
        this.messageServer = messageServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void messageReceived(ChannelHandlerContext context, WebSocketFrame message) throws Exception {
        WebSocketClient client = (WebSocketClient)((Object)context.attr(WebSocketHandshakeHandler.CLIENT).get());
        if (message instanceof CloseWebSocketFrame) {
            if (client != null) {
                try {
                    this.server.disconnectClient(context, client, false);
                }
                finally {
                    message.retain();
                    client.disconnect((CloseWebSocketFrame)message);
                }
            }
        } else if (message instanceof PingWebSocketFrame) {
            context.channel().writeAndFlush((Object)new PongWebSocketFrame(message.content()));
        } else if (message instanceof TextWebSocketFrame) {
            String text = ChannelBufferToString.readString(message.content());
            try {
                this.messageServer.message(client, text);
            }
            catch (Throwable e) {
                this.server.exceptionHandler.exceptionCaught(new IOException("Exception while handle message: " + text, e));
            }
        } else if (!(message instanceof PongWebSocketFrame)) {
            throw new UnsupportedOperationException(message.getClass().getName() + " frame types not supported");
        }
    }

    public void channelInactive(ChannelHandlerContext context) throws Exception {
        Client client = (Client)((Object)context.attr(WebSocketHandshakeHandler.CLIENT).get());
        if (client != null) {
            this.server.disconnectClient(context, client, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        try {
            this.server.exceptionHandler.exceptionCaught(cause);
        }
        finally {
            context.channel().close();
        }
    }
}

