/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rpc;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessor;
import org.jetbrains.rpc.CommandSender;
import org.jetbrains.rpc.RequestCallback;
import org.jetbrains.rpc.ResultReader;

public abstract class CommandSenderBase<SUCCESS_RESPONSE>
implements CommandSender {
    protected abstract <RESULT> void send(@NotNull Request var1, @NotNull RequestPromise<SUCCESS_RESPONSE, RESULT> var2);

    @Override
    @NotNull
    public final <RESULT> Promise<RESULT> send(@NotNull Request<RESULT> request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/rpc/CommandSenderBase", "send"));
        }
        RequestPromise callback = new RequestPromise(request.getMethodName());
        this.send(request, callback);
        RequestPromise requestPromise = callback;
        if (requestPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/rpc/CommandSenderBase", "send"));
        }
        return requestPromise;
    }

    protected static final class RequestPromise<SUCCESS_RESPONSE, RESULT>
    extends AsyncPromise<RESULT>
    implements RequestCallback<SUCCESS_RESPONSE> {
        private final String methodName;

        public RequestPromise(@Nullable String methodName) {
            this.methodName = methodName;
        }

        @Override
        public void onSuccess(@Nullable SUCCESS_RESPONSE response, @Nullable ResultReader<SUCCESS_RESPONSE> resultReader) {
            try {
                if (resultReader == null || response == null) {
                    this.setResult(response);
                } else {
                    this.setResult(this.methodName == null ? null : (Object)resultReader.readResult(this.methodName, response));
                }
            }
            catch (Throwable e) {
                CommandProcessor.LOG.error(e);
                this.setError(e);
            }
        }

        @Override
        public void onError(@NotNull Throwable error) {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/rpc/CommandSenderBase$RequestPromise", "onError"));
            }
            this.setError(error);
        }
    }
}

