/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rpc;

import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.rpc.CommandProcessor;
import org.jetbrains.rpc.MessageManagerBase;
import org.jetbrains.rpc.RequestCallback;

public final class MessageManager<REQUEST, INCOMING, INCOMING_WITH_SEQ, SUCCESS>
extends MessageManagerBase {
    private final ConcurrentIntObjectMap<RequestCallback<SUCCESS>> callbackMap = ContainerUtil.createConcurrentIntObjectMap();
    private final Handler<REQUEST, INCOMING, INCOMING_WITH_SEQ, SUCCESS> handler;

    public MessageManager(Handler<REQUEST, INCOMING, INCOMING_WITH_SEQ, SUCCESS> handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(@NotNull REQUEST message, @NotNull RequestCallback<SUCCESS> callback) {
        boolean success;
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/rpc/MessageManager", "send"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/rpc/MessageManager", "send"));
        }
        if (this.rejectIfClosed(callback)) {
            return;
        }
        int sequence = this.handler.getUpdatedSequence(message);
        this.callbackMap.put(sequence, callback);
        try {
            success = this.handler.write(message);
        }
        catch (Throwable e) {
            try {
                this.failedToSend(sequence);
            }
            finally {
                CommandProcessor.LOG.error("Failed to send", e);
            }
            return;
        }
        if (!success) {
            this.failedToSend(sequence);
        }
    }

    private void failedToSend(int sequence) {
        RequestCallback callback = (RequestCallback)this.callbackMap.remove(sequence);
        if (callback != null) {
            callback.onError(Promise.createError("Failed to send"));
        }
    }

    public void processIncoming(INCOMING incomingParsed) {
        INCOMING_WITH_SEQ commandResponse = this.handler.readIfHasSequence(incomingParsed);
        if (commandResponse == null) {
            if (this.closed) {
                CommandProcessor.LOG.info("Connection closed, ignore incoming");
            } else {
                this.handler.acceptNonSequence(incomingParsed);
            }
            return;
        }
        RequestCallback<SUCCESS> callback = this.getCallbackAndRemove(this.handler.getSequence(commandResponse));
        if (this.rejectIfClosed(callback)) {
            return;
        }
        try {
            this.handler.call(commandResponse, callback);
        }
        catch (Throwable e) {
            callback.onError(e);
            CommandProcessor.LOG.error("Failed to dispatch response to callback", e);
        }
    }

    public RequestCallback<SUCCESS> getCallbackAndRemove(int id) {
        RequestCallback callback = (RequestCallback)this.callbackMap.remove(id);
        if (callback == null) {
            throw new IllegalArgumentException("Cannot find callback with id " + id);
        }
        return callback;
    }

    public void cancelWaitingRequests() {
        ConcurrentIntObjectMap<RequestCallback<SUCCESS>> map = this.callbackMap;
        int[] keys = map.keys();
        Arrays.sort(keys);
        for (int key : keys) {
            RequestCallback callback = (RequestCallback)map.get(key);
            if (callback == null) continue;
            MessageManager.rejectCallback(callback);
        }
    }

    public static interface Handler<OUTGOING, INCOMING, INCOMING_WITH_SEQ, SUCCESS> {
        public int getUpdatedSequence(@NotNull OUTGOING var1);

        public boolean write(@NotNull OUTGOING var1) throws IOException;

        public INCOMING_WITH_SEQ readIfHasSequence(INCOMING var1);

        public int getSequence(INCOMING_WITH_SEQ var1);

        public void acceptNonSequence(INCOMING var1);

        public void call(INCOMING_WITH_SEQ var1, RequestCallback<SUCCESS> var2);
    }
}

