/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rollback;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitSimpleHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitUntrackedFilesHolder;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitRollbackEnvironment
implements RollbackEnvironment {
    private final Project myProject;

    public GitRollbackEnvironment(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rollback/GitRollbackEnvironment", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public String getRollbackOperationName() {
        String string = GitBundle.getString("revert.action.name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rollback/GitRollbackEnvironment", "getRollbackOperationName"));
        }
        return string;
    }

    public void rollbackModifiedWithoutCheckout(@NotNull List<VirtualFile> files, List<VcsException> exceptions, RollbackProgressListener listener) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/rollback/GitRollbackEnvironment", "rollbackModifiedWithoutCheckout"));
        }
        throw new UnsupportedOperationException("Explicit file checkout is not supported by GIT.");
    }

    public void rollbackMissingFileDeletion(@NotNull List<FilePath> files, List<VcsException> exceptions, RollbackProgressListener listener) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/rollback/GitRollbackEnvironment", "rollbackMissingFileDeletion"));
        }
        throw new UnsupportedOperationException("Missing file delete is not reported by GIT.");
    }

    public void rollbackIfUnchanged(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/rollback/GitRollbackEnvironment", "rollbackIfUnchanged"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackChanges(@NotNull List<Change> changes, List<VcsException> exceptions, @NotNull RollbackProgressListener listener) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "git4idea/rollback/GitRollbackEnvironment", "rollbackChanges"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "git4idea/rollback/GitRollbackEnvironment", "rollbackChanges"));
        }
        HashMap<VirtualFile, List<FilePath>> toUnindex = new HashMap<VirtualFile, List<FilePath>>();
        HashMap<VirtualFile, List<FilePath>> toUnversion = new HashMap<VirtualFile, List<FilePath>>();
        HashMap<VirtualFile, List<FilePath>> toRevert = new HashMap<VirtualFile, List<FilePath>>();
        ArrayList<FilePath> toDelete = new ArrayList<FilePath>();
        listener.determinate();
        for (Change change : changes) {
            switch (change.getType()) {
                case NEW: {
                    GitRollbackEnvironment.registerFile(toUnversion, change.getAfterRevision().getFile(), exceptions);
                    break;
                }
                case MOVED: {
                    GitRollbackEnvironment.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                    GitRollbackEnvironment.registerFile(toUnindex, change.getAfterRevision().getFile(), exceptions);
                    toDelete.add(change.getAfterRevision().getFile());
                    break;
                }
                case MODIFICATION: {
                    GitRollbackEnvironment.registerFile(toUnindex, change.getBeforeRevision().getFile(), exceptions);
                    GitRollbackEnvironment.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                    break;
                }
                case DELETED: {
                    GitRollbackEnvironment.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                }
            }
        }
        for (Map.Entry entry : toUnindex.entrySet()) {
            listener.accept((List)entry.getValue());
            try {
                this.unindex((VirtualFile)entry.getKey(), (List)entry.getValue(), false);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        for (Map.Entry entry : toUnversion.entrySet()) {
            listener.accept((List)entry.getValue());
            try {
                this.unindex((VirtualFile)entry.getKey(), (List)entry.getValue(), true);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        for (FilePath filePath : toDelete) {
            listener.accept(filePath);
            try {
                File ioFile = filePath.getIOFile();
                if (!ioFile.exists() || ioFile.delete()) continue;
                exceptions.add(new VcsException("Unable to delete file: " + filePath));
            }
            catch (Exception e) {
                exceptions.add(new VcsException("Unable to delete file: " + filePath, (Throwable)e));
            }
        }
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            for (Map.Entry<VirtualFile, List<FilePath>> entry : toRevert.entrySet()) {
                listener.accept(entry.getValue());
                try {
                    this.revert(entry.getKey(), entry.getValue());
                }
                catch (VcsException e) {
                    exceptions.add(e);
                }
            }
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.myProject, (AccessToken)token);
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        HashSet<File> filesToRefresh = new HashSet<File>();
        for (Change c : changes) {
            ContentRevision after;
            ContentRevision before = c.getBeforeRevision();
            if (before != null) {
                filesToRefresh.add(new File(before.getFile().getPath()));
            }
            if ((after = c.getAfterRevision()) == null) continue;
            filesToRefresh.add(new File(after.getFile().getPath()));
        }
        localFileSystem.refreshIoFiles(filesToRefresh);
        for (GitRepository repo : GitUtil.getRepositoryManager(this.myProject).getRepositories()) {
            repo.update();
        }
    }

    public void revert(VirtualFile root, List<FilePath> files) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitSimpleHandler handler = new GitSimpleHandler(this.myProject, root, GitCommand.CHECKOUT);
            handler.addParameters("HEAD");
            handler.endOptions();
            handler.addParameters(paths);
            handler.run();
        }
    }

    private void unindex(VirtualFile root, List<FilePath> files, boolean toUnversioned) throws VcsException {
        GitFileUtils.delete(this.myProject, root, files, "--cached", "-f");
        if (toUnversioned) {
            GitRepository repo = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(root);
            GitUntrackedFilesHolder untrackedFilesHolder = repo == null ? null : repo.getUntrackedFilesHolder();
            for (FilePath path : files) {
                VirtualFile vf = VcsUtil.getVirtualFile((File)path.getIOFile());
                if (untrackedFilesHolder == null || vf == null) continue;
                untrackedFilesHolder.add(vf);
            }
        }
    }

    private static void registerFile(Map<VirtualFile, List<FilePath>> files, FilePath file, List<VcsException> exceptions) {
        VirtualFile root;
        try {
            root = GitUtil.getGitRoot(file);
        }
        catch (VcsException e) {
            exceptions.add(e);
            return;
        }
        List<FilePath> paths = files.get(root);
        if (paths == null) {
            paths = new ArrayList<FilePath>();
            files.put(root, paths);
        }
        paths.add(file);
    }

    public static GitRollbackEnvironment getInstance(Project project) {
        return (GitRollbackEnvironment)PeriodicalTasksCloser.getInstance().safeGetService(project, GitRollbackEnvironment.class);
    }

    public static void resetHardLocal(Project project, VirtualFile root) {
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.RESET);
        handler.addParameters("--hard");
        handler.endOptions();
        GitHandlerUtil.runInCurrentThread(handler, null);
    }
}

