/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.pty4j.unix.Pty;
import com.pty4j.unix.PtyExecutor;
import com.pty4j.unix.PtyHelpers;
import jtermios.JTermios;
import jtermios.Termios;

public class JnaPtyExecutor
implements PtyExecutor {
    private static final int STDIN_FILENO = 0;
    private static final int STDOUT_FILENO = 1;
    private static final int STDERR_FILENO = 2;

    public int execPty(String full_path, String[] argv, String[] envp, String dirpath, int[] channels, String pts_name, int fdm, String err_pts_name, int err_fdm, boolean console) {
        PtyHelpers.OSFacade m_jpty = PtyHelpers.getInstance();
        int childpid = m_jpty.fork();
        if (childpid < 0) {
            return -1;
        }
        if (childpid == 0) {
            PtyHelpers.chdir(dirpath);
            if (channels != null) {
                if (console && m_jpty.setsid() < 0) {
                    return -1;
                }
                int fds = JnaPtyExecutor.ptySlaveOpen(fdm, pts_name);
                int err_fds = -1;
                if (console) {
                    err_fds = JnaPtyExecutor.ptySlaveOpen(err_fdm, err_pts_name);
                }
                if (fds < 0 || console && err_fds < 0) {
                    return -1;
                }
                m_jpty.login_tty(fds);
                if (JTermios.tcsetattr((int)fds, (int)JTermios.TCSANOW, (Termios)PtyHelpers.createTermios()) != 0) {
                    return -1;
                }
                m_jpty.close(fdm);
                if (console) {
                    m_jpty.close(err_fdm);
                }
                if (console) {
                    Pty.setNoEcho(fds);
                    int pid = m_jpty.getpid();
                    if (m_jpty.setpgid(pid, pid) < 0) {
                        return -1;
                    }
                }
                m_jpty.dup2(fds, 0);
                m_jpty.dup2(fds, 1);
                m_jpty.dup2(console ? err_fds : fds, 2);
                m_jpty.close(fds);
                if (console) {
                    m_jpty.close(err_fds);
                }
            }
            if (envp[0] == null) {
                m_jpty.execv(full_path, argv);
            } else {
                m_jpty.execve(full_path, argv, envp);
            }
            System.exit(127);
        } else if (childpid != 0) {
            if (console) {
                Pty.setNoEcho(fdm);
            }
            if (channels != null) {
                channels[0] = fdm;
                channels[1] = fdm;
                channels[2] = console ? err_fdm : fdm;
            }
            return childpid;
        }
        return -1;
    }

    public static int ptySlaveOpen(int fdm, String pts_name) {
        int fds = JTermios.open((String)pts_name, (int)JTermios.O_RDWR);
        if (fds < 0) {
            JTermios.close((int)fdm);
            return -5;
        }
        return fds;
    }
}

