/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import java.io.IOException;
import java.io.InputStream;
import jtermios.JTermios;

public class PTYInputStream
extends InputStream {
    int myFD;

    public PTYInputStream(int fd) {
        this.myFD = fd;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        if (1 != this.read(b, 0, 1)) {
            return -1;
        }
        return b[0];
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        byte[] tmpBuf = new byte[len];
        if ((len = this.read0(this.myFD, tmpBuf, len)) <= 0) {
            return -1;
        }
        System.arraycopy(tmpBuf, 0, buf, off, len);
        return len;
    }

    public void close() throws IOException {
        if (this.myFD == -1) {
            return;
        }
        this.close0(this.myFD);
        this.myFD = -1;
    }

    public int available() throws IOException {
        if (this.myFD == -1) {
            throw new IOException("File descriptor is closed");
        }
        return 0;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private int read0(int fd, byte[] buf, int len) throws IOException {
        return JTermios.read((int)fd, (byte[])buf, (int)len);
    }

    private int close0(int fd) throws IOException {
        return JTermios.close((int)fd);
    }
}

