/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import com.pty4j.unix.PTYInputStream;
import com.pty4j.unix.PTYOutputStream;
import com.pty4j.unix.Pty;
import com.pty4j.unix.PtyHelpers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UnixPtyProcess
extends PtyProcess {
    public int NOOP = 0;
    public int SIGHUP = 1;
    public int SIGINT = 2;
    public int SIGKILL = 9;
    public int SIGTERM = 15;
    public int INT = 2;
    public int CTRLC = 1000;
    private int pid = 0;
    private int myStatus;
    final int[] fChannels = new int[3];
    private boolean isDone;
    private OutputStream out;
    private InputStream in;
    private InputStream err;
    private Pty myPty;
    private Pty myErrPty;

    public UnixPtyProcess(String[] cmdarray, String[] envp, String dir, Pty pty, Pty errPty) throws IOException {
        if (dir == null) {
            dir = ".";
        }
        this.myPty = pty;
        this.myErrPty = errPty;
        this.execInPty(cmdarray, envp, dir, pty, errPty);
    }

    public Pty getPty() {
        return this.myPty;
    }

    protected void finalize() throws Throwable {
        this.closeUnusedStreams();
        super.finalize();
    }

    public synchronized InputStream getInputStream() {
        if (null == this.in) {
            this.in = this.myPty != null ? this.myPty.getInputStream() : new PTYInputStream(this.fChannels[1]);
        }
        return this.in;
    }

    public synchronized OutputStream getOutputStream() {
        if (null == this.out) {
            this.out = this.myPty != null ? this.myPty.getOutputStream() : new PTYOutputStream(this.fChannels[0]);
        }
        return this.out;
    }

    public synchronized InputStream getErrorStream() {
        if (null == this.err) {
            this.err = this.myPty != null && !this.myPty.isConsole() ? new InputStream(){

                public int read() {
                    return -1;
                }
            } : (this.myErrPty != null ? this.myErrPty.getInputStream() : new PTYInputStream(this.fChannels[2]));
        }
        return this.err;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (!this.isDone) {
            this.wait();
        }
        return this.myStatus;
    }

    public synchronized int exitValue() {
        if (!this.isDone) {
            throw new IllegalThreadStateException("Process not Terminated");
        }
        return this.myStatus;
    }

    public synchronized void destroy() {
        this.terminate();
        this.closeUnusedStreams();
        if (!this.isDone) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.isDone) {
            this.kill();
        }
    }

    public int interrupt() {
        return Pty.raise(this.pid, this.INT);
    }

    public int interruptCTRLC() {
        return this.interrupt();
    }

    public int hangup() {
        return Pty.raise(this.pid, this.SIGHUP);
    }

    public int kill() {
        return Pty.raise(this.pid, this.SIGKILL);
    }

    public int terminate() {
        return Pty.raise(this.pid, this.SIGTERM);
    }

    public boolean isRunning() {
        return Pty.raise(this.pid, this.NOOP) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execInPty(String[] command, String[] environment, String workingDirectory, Pty pty, Pty errPty) throws IOException {
        String cmd = command[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(cmd);
        }
        if (environment == null) {
            environment = new String[]{};
        }
        String slaveName = pty.getSlaveName();
        int masterFD = pty.getMasterFD();
        String errSlaveName = errPty == null ? null : errPty.getSlaveName();
        int errMasterFD = errPty == null ? -1 : errPty.getMasterFD();
        boolean console = pty.isConsole();
        Reaper reaper = new Reaper(command, environment, workingDirectory, slaveName, masterFD, errSlaveName, errMasterFD, console);
        reaper.setDaemon(true);
        reaper.start();
        UnixPtyProcess unixPtyProcess = this;
        synchronized (unixPtyProcess) {
            while (this.pid == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (this.pid == -1) {
            throw new IOException("Exec_tty error:" + reaper.getErrorMessage());
        }
    }

    private synchronized void closeUnusedStreams() {
        try {
            if (null == this.err) {
                this.getErrorStream().close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (null == this.in) {
                this.getInputStream().close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (null == this.out) {
                this.getOutputStream().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    int exec(String[] cmd, String[] envp, String dirname, int[] channels, String slaveName, int masterFD, String errSlaveName, int errMasterFD, boolean console) throws IOException {
        int[] fd = new int[3];
        int pid = -1;
        if (channels == null) {
            return pid;
        }
        if (cmd == null) {
            return pid;
        }
        if (envp == null) {
            return pid;
        }
        pid = PtyHelpers.execPty(cmd[0], cmd, envp, dirname, fd, slaveName, masterFD, errSlaveName, errMasterFD, console);
        if (pid < 0) {
            return pid;
        }
        channels[0] = fd[0];
        channels[1] = fd[1];
        channels[2] = fd[2];
        return pid;
    }

    int waitFor(int processID) {
        return Pty.wait0(processID);
    }

    public void setWinSize(WinSize winSize) {
        this.myPty.setTerminalSize(winSize.ws_col, winSize.ws_row);
    }

    public WinSize getWinSize() throws IOException {
        return this.myPty.getWinSize();
    }

    class Reaper
    extends Thread {
        private String[] myCommand;
        private String[] myEnv;
        private String myDir;
        private String mySlaveName;
        private int myMasterFD;
        private String myErrSlaveName;
        private int myErrMasterFD;
        private boolean myConsole;
        volatile Throwable myException;

        public Reaper(String[] command, String[] environment, String workingDirectory, String slaveName, int masterFD, String errSlaveName, int errMasterFD, boolean console) {
            super("PtyProcess Reaper");
            this.myCommand = command;
            this.myEnv = environment;
            this.myDir = workingDirectory;
            this.mySlaveName = slaveName;
            this.myMasterFD = masterFD;
            this.myErrSlaveName = errSlaveName;
            this.myErrMasterFD = errMasterFD;
            this.myConsole = console;
            this.myException = null;
        }

        int execute(String[] cmd, String[] env, String dir, int[] channels) throws IOException {
            return UnixPtyProcess.this.exec(cmd, env, dir, channels, this.mySlaveName, this.myMasterFD, this.myErrSlaveName, this.myErrMasterFD, this.myConsole);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                UnixPtyProcess.this.pid = this.execute(this.myCommand, this.myEnv, this.myDir, UnixPtyProcess.this.fChannels);
            }
            catch (Exception e) {
                UnixPtyProcess.this.pid = -1;
                this.myException = e;
            }
            UnixPtyProcess unixPtyProcess = UnixPtyProcess.this;
            synchronized (unixPtyProcess) {
                UnixPtyProcess.this.notifyAll();
            }
            if (UnixPtyProcess.this.pid != -1) {
                UnixPtyProcess.this.myStatus = UnixPtyProcess.this.waitFor(UnixPtyProcess.this.pid);
                unixPtyProcess = UnixPtyProcess.this;
                synchronized (unixPtyProcess) {
                    UnixPtyProcess.this.isDone = true;
                    UnixPtyProcess.this.notifyAll();
                }
            }
        }

        public String getErrorMessage() {
            return this.myException != null ? this.myException.getMessage() : "Unknown reason";
        }
    }
}

