/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffRequest
extends ContentDiffRequest {
    @Nullable
    private final String myTitle;
    @NotNull
    private final DiffContent[] myContents;
    @NotNull
    private final String[] myContentTitles;

    public SimpleDiffRequest(@Nullable String title, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull String title1, @NotNull String title2) {
        if (content1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/diff/requests/SimpleDiffRequest", "<init>"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "com/intellij/diff/requests/SimpleDiffRequest", "<init>"));
        }
        if (title1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title1", "com/intellij/diff/requests/SimpleDiffRequest", "<init>"));
        }
        if (title2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title2", "com/intellij/diff/requests/SimpleDiffRequest", "<init>"));
        }
        this(title, new DiffContent[]{content1, content2}, new String[]{title1, title2});
    }

    public SimpleDiffRequest(@Nullable String title, @NotNull DiffContent[] contents, @NotNull String[] titles) {
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/diff/requests/SimpleDiffRequest", "<init>"));
        }
        if (titles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titles", "com/intellij/diff/requests/SimpleDiffRequest", "<init>"));
        }
        assert (contents.length == titles.length);
        this.myTitle = title;
        this.myContents = contents;
        this.myContentTitles = titles;
    }

    @Override
    @NotNull
    public DiffContent[] getContents() {
        if (this.myContents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/requests/SimpleDiffRequest", "getContents"));
        }
        return this.myContents;
    }

    @Override
    @NotNull
    public String[] getContentTitles() {
        if (this.myContentTitles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/requests/SimpleDiffRequest", "getContentTitles"));
        }
        return this.myContentTitles;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @Override
    public void onAssigned(boolean isAssigned) {
        for (DiffContent content : this.myContents) {
            content.onAssigned(isAssigned);
        }
    }
}

