/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ConfigurationFromContextWrapper
extends ConfigurationFromContext {
    private final RuntimeConfigurationProducer myProducer;

    public ConfigurationFromContextWrapper(RuntimeConfigurationProducer producer) {
        this.myProducer = producer;
    }

    @Override
    public void onFirstRun(ConfigurationContext context, Runnable startRunnable) {
        this.myProducer.perform(context, startRunnable);
    }

    @Override
    @NotNull
    public RunnerAndConfigurationSettings getConfigurationSettings() {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.myProducer.getConfiguration();
        if (runnerAndConfigurationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConfigurationFromContextWrapper", "getConfigurationSettings"));
        }
        return runnerAndConfigurationSettings;
    }

    @Override
    public void setConfigurationSettings(RunnerAndConfigurationSettings configurationSettings) {
        this.myProducer.setConfiguration(configurationSettings);
    }

    @Override
    @NotNull
    public PsiElement getSourceElement() {
        PsiElement psiElement = this.myProducer.getSourceElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConfigurationFromContextWrapper", "getSourceElement"));
        }
        return psiElement;
    }

    @Override
    public boolean isPreferredTo(ConfigurationFromContext other) {
        return other instanceof ConfigurationFromContextWrapper && this.myProducer.compareTo(((ConfigurationFromContextWrapper)other).myProducer) < 0;
    }
}

