/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentTreeWatcher;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.DialogUtil;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;

public class MnemonicHelper
extends ComponentTreeWatcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.MnemonicHelper");
    private Map<Integer, String> myMnemonics = null;
    public static final PropertyChangeListener TEXT_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof AbstractButton) {
                DialogUtil.registerMnemonic((AbstractButton)source);
            } else if (source instanceof JLabel) {
                DialogUtil.registerMnemonic((JLabel)source, null);
            }
        }
    };
    @NonNls
    public static final String TEXT_CHANGED_PROPERTY = "text";

    public MnemonicHelper() {
        super(ArrayUtil.EMPTY_CLASS_ARRAY);
    }

    @Override
    protected void processComponent(Component parentComponent) {
        if (parentComponent instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)parentComponent;
            abstractButton.addPropertyChangeListener(TEXT_CHANGED_PROPERTY, TEXT_LISTENER);
            DialogUtil.registerMnemonic(abstractButton);
            this.checkForDuplicateMnemonics(abstractButton);
            MnemonicHelper.fixMacMnemonicKeyStroke(abstractButton, null);
        } else if (parentComponent instanceof JLabel) {
            JLabel jLabel = (JLabel)parentComponent;
            jLabel.addPropertyChangeListener(TEXT_CHANGED_PROPERTY, TEXT_LISTENER);
            DialogUtil.registerMnemonic(jLabel, null);
            this.checkForDuplicateMnemonics(jLabel);
            MnemonicHelper.fixMacMnemonicKeyStroke(jLabel, "release");
        }
    }

    private static void fixMacMnemonicKeyStroke(JComponent component, String type) {
        KeyStroke[] strokes;
        InputMap inputMap;
        if (SystemInfo.isMac && Registry.is((String)"ide.mac.alt.mnemonic.without.ctrl") && (inputMap = component.getInputMap(2)) != null && (strokes = inputMap.allKeys()) != null) {
            int mask = 10;
            for (KeyStroke stroke : strokes) {
                if (mask != (mask & stroke.getModifiers())) continue;
                inputMap.put(MnemonicHelper.getKeyStrokeWithoutCtrlModifier(stroke), type != null ? type : inputMap.get(stroke));
            }
        }
    }

    private static KeyStroke getKeyStrokeWithoutCtrlModifier(KeyStroke stroke) {
        try {
            Method method = AWTKeyStroke.class.getDeclaredMethod("getCachedStroke", Character.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            method.setAccessible(true);
            int modifiers = stroke.getModifiers() & 0xFFFFFFFD & 0xFFFFFF7F;
            return (KeyStroke)method.invoke(null, Character.valueOf(stroke.getKeyChar()), stroke.getKeyCode(), modifiers, stroke.isOnKeyRelease());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Override
    protected void unprocessComponent(Component component) {
    }

    public void checkForDuplicateMnemonics(JLabel label) {
        if (!Registry.is((String)"ide.checkDuplicateMnemonics")) {
            return;
        }
        this.checkForDuplicateMnemonics(label.getDisplayedMnemonic(), label.getText());
    }

    public void checkForDuplicateMnemonics(AbstractButton button) {
        if (!Registry.is((String)"ide.checkDuplicateMnemonics")) {
            return;
        }
        this.checkForDuplicateMnemonics(button.getMnemonic(), button.getText());
    }

    public void checkForDuplicateMnemonics(int mnemonic, String text) {
        String other;
        if (mnemonic == 0) {
            return;
        }
        if (this.myMnemonics == null) {
            this.myMnemonics = new HashMap<Integer, String>();
        }
        if ((other = this.myMnemonics.get(mnemonic)) != null && !other.equals(text)) {
            LOG.error("conflict: multiple components with mnemonic '" + (char)mnemonic + "' seen on '" + text + "' and '" + other + "'");
        }
        this.myMnemonics.put(mnemonic, text);
    }

    public static CustomShortcutSet createShortcut(char ch) {
        Character mnemonic = Character.valueOf(ch);
        String shortcut = SystemInfo.isMac && SystemInfo.isJavaVersionAtLeast((String)"1.7") ? "control alt pressed " + mnemonic : "alt pressed " + mnemonic;
        return CustomShortcutSet.fromString(shortcut);
    }
}

