/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SharedScheme;
import com.intellij.openapi.util.WriteExternalException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SchemesManager<T extends Scheme, E extends ExternalizableScheme> {
    public static final SchemesManager EMPTY = new SchemesManager(){

        @NotNull
        public Collection loadSchemes() {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManager$1", "loadSchemes"));
            }
            return set;
        }

        @NotNull
        public Collection loadSharedSchemes() {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManager$1", "loadSharedSchemes"));
            }
            return set;
        }

        public void exportScheme(@NotNull ExternalizableScheme scheme, String name, String description) {
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManager$1", "exportScheme"));
            }
        }

        @Override
        public boolean isImportAvailable() {
            return false;
        }

        @Override
        public boolean isExportAvailable() {
            return false;
        }

        @Override
        public boolean isShared(@NotNull Scheme scheme) {
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManager$1", "isShared"));
            }
            return false;
        }

        public void addNewScheme(@NotNull Scheme scheme, boolean replaceExisting) {
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManager$1", "addNewScheme"));
            }
        }

        @Override
        public void clearAllSchemes() {
        }

        @NotNull
        public List getAllSchemes() {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManager$1", "getAllSchemes"));
            }
            return list;
        }

        public Scheme findSchemeByName(@NotNull String schemeName) {
            if (schemeName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeName", "com/intellij/openapi/options/SchemesManager$1", "findSchemeByName"));
            }
            return null;
        }

        @Override
        public void save() {
        }

        @Override
        public void setCurrentSchemeName(String schemeName) {
        }

        public Scheme getCurrentScheme() {
            return null;
        }

        public void removeScheme(@NotNull Scheme scheme) {
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManager$1", "removeScheme"));
            }
        }

        @NotNull
        public Collection getAllSchemeNames() {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManager$1", "getAllSchemeNames"));
            }
            return set;
        }

        @NotNull
        public Collection loadSharedSchemes(Collection currentSchemeList) {
            Collection collection = this.loadSharedSchemes();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManager$1", "loadSharedSchemes"));
            }
            return collection;
        }

        @Override
        public File getRootDirectory() {
            return null;
        }
    };

    @NotNull
    public Collection<E> loadSchemes();

    @Deprecated
    @NotNull
    public Collection<SharedScheme<E>> loadSharedSchemes();

    @Deprecated
    @NotNull
    public Collection<SharedScheme<E>> loadSharedSchemes(Collection<T> var1);

    @Deprecated
    public void exportScheme(@NotNull E var1, String var2, String var3) throws WriteExternalException, IOException;

    @Deprecated
    public boolean isImportAvailable();

    @Deprecated
    public boolean isExportAvailable();

    @Deprecated
    public boolean isShared(@NotNull Scheme var1);

    public void addNewScheme(@NotNull T var1, boolean var2);

    public void clearAllSchemes();

    @NotNull
    public List<T> getAllSchemes();

    @Nullable
    public T findSchemeByName(@NotNull String var1);

    public void save();

    public void setCurrentSchemeName(String var1);

    @Nullable
    public T getCurrentScheme();

    public void removeScheme(@NotNull T var1);

    @NotNull
    public Collection<String> getAllSchemeNames();

    public File getRootDirectory();
}

