/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.tabs.impl.JBEditorTabsPainter;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class DefaultEditorTabsPainter
extends JBEditorTabsPainter {
    @Override
    public void doPaintInactive(Graphics2D g2d, Rectangle effectiveBounds, int x, int y, int w, int h, Color tabColor, int row, int column, boolean vertical) {
        g2d.setColor(tabColor != null ? tabColor : this.getDefaultTabColor());
        g2d.fillRect(x, y, w, h);
        g2d.setColor(this.getInactiveMaskColor());
        g2d.fillRect(x, y, w, h);
        if (!vertical) {
            this.drawShadowLines(g2d, x, y, w);
        }
    }

    @Override
    public void doPaintBackground(Graphics2D g, Rectangle clip, boolean vertical, Rectangle rectangle) {
        g.setColor(this.getBackgroundColor());
        g.fill(clip);
        if (!vertical) {
            this.drawShadowLines(g, rectangle.x, rectangle.y, rectangle.width);
        }
    }

    private void drawShadowLines(Graphics g, int x, int y, int width) {
        g.setColor(ColorUtil.withAlpha((Color)this.getShadowBaseColor(), (double)0.5));
        g.drawLine(x, y, x + width, y);
        g.setColor(ColorUtil.withAlpha((Color)this.getShadowBaseColor(), (double)0.2));
        g.drawLine(x, y + 1, x + width, y + 1);
    }

    @Override
    public void fillSelectionAndBorder(Graphics2D g, JBTabsImpl.ShapeInfo selectedShape, Color tabColor, int x, int y, int height) {
        g.setColor(tabColor != null ? tabColor : this.getDefaultTabColor());
        g.fill(selectedShape.fillPath.getShape());
        g.draw(selectedShape.fillPath.getShape());
    }

    @Override
    public Color getBackgroundColor() {
        return Gray._177;
    }

    protected Color getDefaultTabColor() {
        return Color.WHITE;
    }

    protected Color getInactiveMaskColor() {
        return ColorUtil.withAlpha((Color)new Color(0x262626), (double)0.2);
    }

    protected Color getShadowBaseColor() {
        return new Color(0xBABABA);
    }
}

