/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.DarculaEditorTabsPainter;
import com.intellij.ui.tabs.impl.DefaultEditorTabsPainter;
import com.intellij.ui.tabs.impl.JBEditorTabsPainter;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.singleRow.CompressibleSingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.ScrollableSingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.impl.table.TableLayout;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBEditorTabs
extends JBTabsImpl {
    public static final String TABS_ALPHABETICAL_KEY = "tabs.alphabetical";
    static final String TABS_SHORTEN_TITLE_IF_NEED = "tabs.shorten.title.if.need";
    private JBEditorTabsPainter myDarkPainter;
    private JBEditorTabsPainter myDefaultPainter;

    public JBEditorTabs(@Nullable Project project, @NotNull ActionManager actionManager, IdeFocusManager focusManager, @NotNull Disposable parent) {
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/ui/tabs/impl/JBEditorTabs", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ui/tabs/impl/JBEditorTabs", "<init>"));
        }
        super(project, actionManager, focusManager, parent);
        this.myDarkPainter = new DarculaEditorTabsPainter();
        this.myDefaultPainter = new DefaultEditorTabsPainter();
    }

    @Override
    protected SingleRowLayout createSingleRowLayout() {
        if (Registry.is((String)"editor.use.compressible.tabs")) {
            return new CompressibleSingleRowLayout(this);
        }
        if (ApplicationManager.getApplication().isInternal() || Registry.is((String)"editor.use.scrollable.tabs")) {
            return new ScrollableSingleRowLayout(this);
        }
        return super.createSingleRowLayout();
    }

    @Override
    protected TabLabel createTabLabel(TabInfo info) {
        TabLabel label = super.createTabLabel(info);
        label.putClientProperty(TABS_SHORTEN_TITLE_IF_NEED, Boolean.TRUE);
        return label;
    }

    @Override
    public boolean isEditorTabs() {
        return true;
    }

    @Override
    protected void paintFirstGhost(Graphics2D g2d) {
    }

    @Override
    protected void paintLastGhost(Graphics2D g2d) {
    }

    @Override
    public boolean isGhostsAlwaysVisible() {
        return false;
    }

    @Override
    public boolean useSmallLabels() {
        return UISettings.getInstance().USE_SMALL_LABELS_ON_TABS;
    }

    @Override
    public boolean useBoldLabels() {
        return SystemInfo.isMac && Registry.is((String)"ide.mac.boldEditorTabs");
    }

    @Override
    public boolean hasUnderline() {
        return this.isSingleRow();
    }

    @Override
    protected void doPaintInactive(Graphics2D g2d, boolean leftGhostExists, TabLabel label, Rectangle effectiveBounds, boolean rightGhostExists, int row, int column) {
        Insets insets = this.getTabsBorder().getEffectiveBorder();
        int _x = effectiveBounds.x + insets.left;
        int _y = effectiveBounds.y + insets.top;
        int _width = effectiveBounds.width - insets.left - insets.right + (this.getTabsPosition() == JBTabsPosition.right ? 1 : 0);
        int _height = effectiveBounds.height - insets.top - insets.bottom;
        if (!this.isSingleRow() || this.isSingleRow() && this.isHorizontalTabs()) {
            if (this.isSingleRow() && this.getPosition() == JBTabsPosition.bottom) {
                _y += this.getActiveTabUnderlineHeight();
            } else if (this.isSingleRow()) {
                _height -= this.getActiveTabUnderlineHeight();
            } else {
                TabInfo info = label.getInfo();
                if (((TableLayout)this.getEffectiveLayout()).isLastRow(info)) {
                    _height -= this.getActiveTabUnderlineHeight();
                }
            }
        }
        boolean vertical = this.getTabsPosition() == JBTabsPosition.left || this.getTabsPosition() == JBTabsPosition.right;
        Color tabColor = label.getInfo().getTabColor();
        Composite oldComposite = g2d.getComposite();
        this.getPainter().doPaintInactive(g2d, effectiveBounds, _x, _y, _width, _height, tabColor, row, column, vertical);
    }

    @Override
    public int getActiveTabUnderlineHeight() {
        return this.hasUnderline() ? super.getActiveTabUnderlineHeight() : 1;
    }

    JBEditorTabsPainter getPainter() {
        return UIUtil.isUnderDarcula() ? this.myDarkPainter : this.myDefaultPainter;
    }

    @Override
    public boolean isAlphabeticalMode() {
        return Registry.is((String)TABS_ALPHABETICAL_KEY);
    }

    public static void setAlphabeticalMode(boolean on) {
        Registry.get((String)TABS_ALPHABETICAL_KEY).setValue(on);
    }

    @Override
    protected void doPaintBackground(Graphics2D g2d, Rectangle clip) {
        Rectangle rectangle;
        List<TabInfo> visibleInfos = this.getVisibleInfos();
        if (this.isAlphabeticalMode()) {
            Collections.sort(visibleInfos, new Comparator<TabInfo>(){

                @Override
                public int compare(TabInfo o1, TabInfo o2) {
                    return StringUtil.naturalCompare((String)o1.getText(), (String)o2.getText());
                }
            });
        }
        boolean vertical = this.getTabsPosition() == JBTabsPosition.left || this.getTabsPosition() == JBTabsPosition.right;
        Insets insets = this.getTabsBorder().getEffectiveBorder();
        int maxOffset = 0;
        int maxLength = 0;
        for (int i = visibleInfos.size() - 1; i >= 0; --i) {
            TabInfo visibleInfo = visibleInfos.get(i);
            TabLabel tabLabel = (TabLabel)this.myInfo2Label.get(visibleInfo);
            Rectangle r = tabLabel.getBounds();
            if (r.width == 0 || r.height == 0) continue;
            maxOffset = vertical ? r.y + r.height : r.x + r.width;
            maxLength = vertical ? r.width : r.height;
            break;
        }
        ++maxOffset;
        Rectangle r2 = this.getBounds();
        if (vertical) {
            rectangle = new Rectangle(insets.left, maxOffset, this.getWidth(), r2.height - maxOffset - insets.top - insets.bottom);
        } else {
            int y = r2.y + insets.top;
            int height = maxLength - insets.top - insets.bottom;
            if (this.getTabsPosition() == JBTabsPosition.bottom) {
                y = r2.height - height - insets.top + this.getActiveTabUnderlineHeight();
            } else {
                height -= this.getActiveTabUnderlineHeight();
            }
            rectangle = new Rectangle(maxOffset, y, r2.width - maxOffset - insets.left - insets.right, height);
        }
        this.getPainter().doPaintBackground(g2d, clip, vertical, rectangle);
    }

    @Override
    protected void paintSelectionAndBorder(Graphics2D g2d) {
        if (this.getSelectedInfo() == null) {
            return;
        }
        TabLabel label = this.getSelectedLabel();
        Rectangle r = label.getBounds();
        JBTabsImpl.ShapeInfo selectedShape = this._computeSelectedLabelShape();
        Insets insets = this.getTabsBorder().getEffectiveBorder();
        Color tabColor = label.getInfo().getTabColor();
        boolean isHorizontalTabs = this.isHorizontalTabs();
        this.getPainter().paintSelectionAndBorder(g2d, r, selectedShape, insets, tabColor, isHorizontalTabs);
    }

    @Override
    public Color getBackground() {
        return this.getPainter().getBackgroundColor();
    }

    @Override
    public Color getForeground() {
        return UIUtil.getLabelForeground();
    }

    protected JBTabsImpl.ShapeInfo _computeSelectedLabelShape() {
        JBTabsImpl.ShapeInfo shape = new JBTabsImpl.ShapeInfo();
        shape.path = this.getEffectiveLayout().createShapeTransform(this.getSize());
        shape.insets = shape.path.transformInsets(this.getLayoutInsets());
        shape.labelPath = shape.path.createTransform(this.getSelectedLabel().getBounds());
        shape.labelBottomY = shape.labelPath.getMaxY() - shape.labelPath.deltaY(this.getActiveTabUnderlineHeight() - 1);
        shape.labelTopY = shape.labelPath.getY() + (this.getPosition() == JBTabsPosition.top || this.getPosition() == JBTabsPosition.bottom ? shape.labelPath.deltaY(1) : 0);
        shape.labelLeftX = shape.labelPath.getX() + (this.getPosition() == JBTabsPosition.top || this.getPosition() == JBTabsPosition.bottom ? 0 : shape.labelPath.deltaX(1));
        shape.labelRightX = shape.labelPath.getMaxX() - shape.labelPath.deltaX(1);
        int leftX = shape.insets.left + (this.getPosition() == JBTabsPosition.top || this.getPosition() == JBTabsPosition.bottom ? 0 : shape.labelPath.deltaX(1));
        shape.path.moveTo(leftX, shape.labelBottomY);
        shape.path.lineTo(shape.labelLeftX, shape.labelBottomY);
        shape.path.lineTo(shape.labelLeftX, shape.labelTopY);
        shape.path.lineTo(shape.labelRightX, shape.labelTopY);
        shape.path.lineTo(shape.labelRightX, shape.labelBottomY);
        int lastX = shape.path.getWidth() - shape.path.deltaX(shape.insets.right);
        shape.path.lineTo(lastX, shape.labelBottomY);
        shape.path.lineTo(lastX, shape.labelBottomY + shape.labelPath.deltaY(this.getActiveTabUnderlineHeight() - 1));
        shape.path.lineTo(leftX, shape.labelBottomY + shape.labelPath.deltaY(this.getActiveTabUnderlineHeight() - 1));
        shape.path.closePath();
        shape.fillPath = shape.path.copy();
        return shape;
    }
}

