/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.httpclient.NewBaseRepositoryImpl;
import com.intellij.tasks.impl.httpclient.ResponseUtil;
import com.intellij.tasks.trello.TrelloTask;
import com.intellij.tasks.trello.TrelloUtil;
import com.intellij.tasks.trello.model.TrelloBoard;
import com.intellij.tasks.trello.model.TrelloCard;
import com.intellij.tasks.trello.model.TrelloList;
import com.intellij.tasks.trello.model.TrelloUser;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="Trello")
public final class TrelloRepository
extends NewBaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance(TrelloRepository.class);
    static final TrelloBoard UNSPECIFIED_BOARD = new TrelloBoard(){

        @Override
        @NotNull
        public String getName() {
            if ("-- from all boards --" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository$1", "getName"));
            }
            return "-- from all boards --";
        }
    };
    static final TrelloList UNSPECIFIED_LIST = new TrelloList(){

        @Override
        @NotNull
        public String getName() {
            if ("-- from all lists --" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository$2", "getName"));
            }
            return "-- from all lists --";
        }
    };
    private TrelloUser myCurrentUser;
    private TrelloBoard myCurrentBoard;
    private TrelloList myCurrentList;
    private boolean myIncludeAllCards;

    public TrelloRepository() {
    }

    public TrelloRepository(TaskRepositoryType type) {
        super(type);
    }

    public TrelloRepository(TrelloRepository other) {
        super(other);
        this.myCurrentUser = other.myCurrentUser;
        this.myCurrentBoard = other.myCurrentBoard;
        this.myCurrentList = other.myCurrentList;
        this.myIncludeAllCards = other.myIncludeAllCards;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        TrelloRepository repository = (TrelloRepository)((Object)o);
        if (!Comparing.equal((Object)this.myCurrentUser, (Object)repository.myCurrentUser)) {
            return false;
        }
        if (!Comparing.equal((Object)this.myCurrentBoard, (Object)repository.myCurrentBoard)) {
            return false;
        }
        if (!Comparing.equal((Object)this.myCurrentList, (Object)repository.myCurrentList)) {
            return false;
        }
        return this.myIncludeAllCards == repository.myIncludeAllCards;
    }

    @NotNull
    public BaseRepository clone() {
        TrelloRepository trelloRepository = new TrelloRepository(this);
        if (trelloRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "clone"));
        }
        return trelloRepository;
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed) throws Exception {
        List<TrelloCard> cards = this.fetchCards(offset + limit, withClosed);
        return (Task[])ContainerUtil.map2Array(cards, Task.class, (Function)new Function<TrelloCard, Task>(){

            public Task fun(TrelloCard card) {
                return new TrelloTask(card, (TaskRepository)TrelloRepository.this);
            }
        });
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/tasks/trello/TrelloRepository", "findTask"));
        }
        TrelloCard card = this.fetchCardById(id);
        return card != null ? new TrelloTask(card, (TaskRepository)this) : null;
    }

    @Nullable
    public TrelloCard fetchCardById(@NotNull String id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/tasks/trello/TrelloRepository", "fetchCardById"));
        }
        try {
            URIBuilder url = new URIBuilder(this.getRestApiUrl("cards", id)).addParameter("actions", "commentCard").addParameter("fields", "closed,desc,idMembers,idBoard,idList,labels,name,url,dateLastActivity");
            return this.executeMethod((HttpUriRequest)new HttpGet(url.build()), new ResponseUtil.GsonSingleObjectDeserializer<TrelloCard>(TrelloUtil.GSON, TrelloCard.class, true));
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    @Nullable
    public TrelloUser getCurrentUser() {
        return this.myCurrentUser;
    }

    public void setCurrentUser(TrelloUser currentUser) {
        this.myCurrentUser = currentUser;
    }

    @Nullable
    public TrelloBoard getCurrentBoard() {
        return this.myCurrentBoard;
    }

    public void setCurrentBoard(@Nullable TrelloBoard board) {
        this.myCurrentBoard = board != null && board.getId().equals(UNSPECIFIED_BOARD.getId()) ? UNSPECIFIED_BOARD : board;
    }

    @Nullable
    public TrelloList getCurrentList() {
        return this.myCurrentList;
    }

    public void setCurrentList(@Nullable TrelloList list) {
        this.myCurrentList = list != null && list.getId().equals(UNSPECIFIED_LIST.getId()) ? UNSPECIFIED_LIST : list;
    }

    @Nullable
    public String extractId(@NotNull String taskName) {
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/tasks/trello/TrelloRepository", "extractId"));
        }
        return TrelloUtil.TRELLO_ID_PATTERN.matcher(taskName).matches() ? taskName : null;
    }

    @NotNull
    public TrelloUser fetchUserByToken() throws Exception {
        TrelloUser trelloUser;
        try {
            URIBuilder url = new URIBuilder(this.getRestApiUrl("members", "me")).addParameter("fields", "username");
            trelloUser = this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloUser.class);
        }
        catch (Exception e) {
            LOG.warn("Error while fetching initial user info", (Throwable)e);
            this.myCurrentBoard = null;
            this.myCurrentList = null;
            throw e;
        }
        if (trelloUser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "fetchUserByToken"));
        }
        return trelloUser;
    }

    @NotNull
    public TrelloBoard fetchBoardById(@NotNull String id) throws Exception {
        TrelloBoard trelloBoard;
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/tasks/trello/TrelloRepository", "fetchBoardById"));
        }
        URIBuilder url = new URIBuilder(this.getRestApiUrl("boards", id)).addParameter("fields", "closed,name,idOrganization");
        try {
            trelloBoard = this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloBoard.class);
        }
        catch (Exception e) {
            LOG.warn("Error while fetching initial board info", (Throwable)e);
            throw e;
        }
        if (trelloBoard == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "fetchBoardById"));
        }
        return trelloBoard;
    }

    @NotNull
    public TrelloList fetchListById(@NotNull String id) throws Exception {
        TrelloList trelloList;
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/tasks/trello/TrelloRepository", "fetchListById"));
        }
        URIBuilder url = new URIBuilder(this.getRestApiUrl("lists", id)).addParameter("fields", "closed,name,idBoard");
        try {
            trelloList = this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloList.class);
        }
        catch (Exception e) {
            LOG.warn("Error while fetching initial list info" + id, (Throwable)e);
            throw e;
        }
        if (trelloList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "fetchListById"));
        }
        return trelloList;
    }

    @NotNull
    public List<TrelloList> fetchBoardLists() throws Exception {
        if (this.myCurrentBoard == null || this.myCurrentBoard == UNSPECIFIED_BOARD) {
            throw new IllegalStateException("Board not set");
        }
        URIBuilder url = new URIBuilder(this.getRestApiUrl("boards", this.myCurrentBoard.getId(), "lists")).addParameter("fields", "closed,name,idBoard");
        List<TrelloList> list = this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloUtil.LIST_OF_LISTS_TYPE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "fetchBoardLists"));
        }
        return list;
    }

    @NotNull
    public List<TrelloBoard> fetchUserBoards() throws Exception {
        if (this.myCurrentUser == null) {
            throw new IllegalStateException("User not set");
        }
        URIBuilder url = new URIBuilder(this.getRestApiUrl("members", "me", "boards")).addParameter("filter", "open").addParameter("fields", "closed,name,idOrganization");
        List<TrelloBoard> list = this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloUtil.LIST_OF_BOARDS_TYPE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "fetchUserBoards"));
        }
        return list;
    }

    @NotNull
    public List<TrelloCard> fetchCards(int limit, boolean withClosed) throws Exception {
        String baseUrl;
        boolean fromList = false;
        if (this.myCurrentList != null && this.myCurrentList != UNSPECIFIED_LIST) {
            baseUrl = this.getRestApiUrl("lists", this.myCurrentList.getId(), "cards");
            fromList = true;
        } else if (this.myCurrentBoard != null && this.myCurrentBoard != UNSPECIFIED_BOARD) {
            baseUrl = this.getRestApiUrl("boards", this.myCurrentBoard.getId(), "cards");
        } else if (this.myCurrentUser != null) {
            baseUrl = this.getRestApiUrl("members", "me", "cards");
        } else {
            throw new IllegalStateException("Not configured");
        }
        URIBuilder fetchCardUrl = new URIBuilder(baseUrl).addParameter("fields", "closed,desc,idMembers,idBoard,idList,labels,name,url,dateLastActivity").addParameter("limit", String.valueOf(limit));
        if (withClosed || fromList) {
            fetchCardUrl.addParameter("filter", "all");
        } else {
            fetchCardUrl.addParameter("filter", "visible");
        }
        List cards = this.makeRequestAndDeserializeJsonResponse(fetchCardUrl.build(), TrelloUtil.LIST_OF_CARDS_TYPE);
        LOG.debug("Total " + cards.size() + " cards downloaded");
        if (!this.myIncludeAllCards) {
            cards = ContainerUtil.filter(cards, (Condition)new Condition<TrelloCard>(){

                public boolean value(TrelloCard card) {
                    return card.getIdMembers().contains(TrelloRepository.this.myCurrentUser.getId());
                }
            });
            LOG.debug("Total " + cards.size() + " cards after filtering");
        }
        if (!cards.isEmpty()) {
            if (fromList) {
                baseUrl = this.getRestApiUrl("boards", ((TrelloCard)cards.get(0)).getIdBoard(), "cards");
            }
            URIBuilder visibleCardsUrl = new URIBuilder(baseUrl).addParameter("filter", "visible").addParameter("fields", "none");
            List<TrelloCard> visibleCards = this.makeRequestAndDeserializeJsonResponse(visibleCardsUrl.build(), TrelloUtil.LIST_OF_CARDS_TYPE);
            LOG.debug("Total " + visibleCards.size() + " visible cards");
            Set visibleCardsIDs = ContainerUtil.map2Set(visibleCards, (Function)new Function<TrelloCard, String>(){

                public String fun(TrelloCard card) {
                    return card.getId();
                }
            });
            for (TrelloCard card : cards) {
                card.setVisible(visibleCardsIDs.contains(card.getId()));
            }
        }
        List list = cards;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "fetchCards"));
        }
        return list;
    }

    @NotNull
    private <T> T executeMethod(@NotNull HttpUriRequest method, @NotNull ResponseHandler<T> handler) throws Exception {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/tasks/trello/TrelloRepository", "executeMethod"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/tasks/trello/TrelloRepository", "executeMethod"));
        }
        HttpClient client = this.getHttpClient();
        HttpResponse response = client.execute(method);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            Header header = response.getFirstHeader("Content-Type");
            if (header != null && header.getValue().startsWith("text/plain")) {
                String entityContent = ResponseUtil.getResponseContentAsString(response);
                throw new Exception(TaskBundle.message("failure.server.message", StringUtil.capitalize((String)entityContent)));
            }
            throw new Exception(TaskBundle.message("failure.http.error", statusLine.getStatusCode(), statusLine.getStatusCode()));
        }
        Object object = handler.handleResponse(response);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "executeMethod"));
        }
        return (T)object;
    }

    @NotNull
    private <T> List<T> makeRequestAndDeserializeJsonResponse(@NotNull URI url, @NotNull TypeToken<List<T>> type) throws Exception {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/tasks/trello/TrelloRepository", "makeRequestAndDeserializeJsonResponse"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/tasks/trello/TrelloRepository", "makeRequestAndDeserializeJsonResponse"));
        }
        List list = (List)this.executeMethod((HttpUriRequest)new HttpGet(url), new ResponseUtil.GsonMultipleObjectsDeserializer<T>(TrelloUtil.GSON, type));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "makeRequestAndDeserializeJsonResponse"));
        }
        return list;
    }

    @NotNull
    private <T> T makeRequestAndDeserializeJsonResponse(@NotNull URI url, @NotNull Class<T> cls) throws Exception {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/tasks/trello/TrelloRepository", "makeRequestAndDeserializeJsonResponse"));
        }
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/intellij/tasks/trello/TrelloRepository", "makeRequestAndDeserializeJsonResponse"));
        }
        T t = this.executeMethod((HttpUriRequest)new HttpGet(url), new ResponseUtil.GsonSingleObjectDeserializer<T>(TrelloUtil.GSON, cls));
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "makeRequestAndDeserializeJsonResponse"));
        }
        return t;
    }

    public String getPresentableName() {
        String pseudoUrl = "trello.com";
        if (this.myCurrentBoard != null && this.myCurrentBoard != UNSPECIFIED_BOARD) {
            pseudoUrl = pseudoUrl + "/" + this.myCurrentBoard.getName();
        }
        if (this.myCurrentList != null && this.myCurrentList != UNSPECIFIED_LIST) {
            pseudoUrl = pseudoUrl + "/" + this.myCurrentList.getName();
        }
        return pseudoUrl;
    }

    public boolean isIncludeAllCards() {
        return this.myIncludeAllCards;
    }

    public void setIncludeAllCards(boolean includeAllCards) {
        this.myIncludeAllCards = includeAllCards;
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new NewBaseRepositoryImpl.HttpTestConnection((HttpRequestBase)new HttpGet(this.getRestApiUrl("members", "me", "cards") + "?limit=1"));
    }

    @Override
    @Nullable
    protected HttpRequestInterceptor createRequestInterceptor() {
        return new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (request instanceof HttpRequestWrapper) {
                    HttpRequestWrapper wrapper = (HttpRequestWrapper)request;
                    try {
                        wrapper.setURI(new URIBuilder(wrapper.getURI()).addParameter("token", TrelloRepository.this.myPassword).addParameter("key", "d6ec3709f7141007e150de64d4701181").build());
                    }
                    catch (URISyntaxException e) {
                        LOG.error("Illegal URL: " + wrapper.getURI(), (Throwable)e);
                    }
                } else {
                    LOG.error("Cannot add required authentication query parameters to request: " + request);
                }
            }
        };
    }

    public boolean isConfigured() {
        return super.isConfigured() && StringUtil.isNotEmpty((String)this.myPassword);
    }

    @Override
    @NotNull
    public String getRestApiPathPrefix() {
        if ("/1" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "getRestApiPathPrefix"));
        }
        return "/1";
    }

    public String getUrl() {
        return "https://api.trello.com";
    }

    protected int getFeatures() {
        return super.getFeatures() & 0xFFFFFFEF;
    }
}

