/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.codeInsight.JavaFxImportsOptimizer;

public class JavaFxUnusedImportsInspection
extends XmlSuppressableInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnusedImportsInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnusedImportsInspection", "checkFile"));
        }
        if (!JavaFxFileTypeFactory.isFxml(file)) {
            return null;
        }
        XmlDocument document = ((XmlFile)file).getDocument();
        if (document == null) {
            return null;
        }
        final HashSet usedNames = new HashSet();
        file.accept((PsiElementVisitor)new JavaFxImportsOptimizer.JavaFxUsedClassesVisitor(){

            @Override
            protected void appendClassName(String fqn) {
                usedNames.add(fqn);
                String packageName = StringUtil.getPackageName((String)fqn);
                if (!StringUtil.isEmpty((String)packageName)) {
                    usedNames.add(packageName);
                }
            }
        });
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)file.getProject());
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        Collection instructions = PsiTreeUtil.findChildrenOfType((PsiElement)document.getProlog(), XmlProcessingInstruction.class);
        LinkedHashMap<String, XmlProcessingInstruction> targetProcessingInstructions = new LinkedHashMap<String, XmlProcessingInstruction>();
        for (XmlProcessingInstruction instruction : instructions) {
            String target = JavaFxPsiUtil.getInstructionTarget("import", instruction);
            if (target == null) continue;
            targetProcessingInstructions.put(target, instruction);
        }
        for (String target : targetProcessingInstructions.keySet()) {
            XmlProcessingInstruction instruction = (XmlProcessingInstruction)targetProcessingInstructions.get(target);
            if (target.endsWith(".*")) {
                if (usedNames.contains(StringUtil.trimEnd((String)target, (String)".*"))) continue;
                problems.add(inspectionManager.createProblemDescriptor((PsiElement)instruction, "Unused import", (LocalQuickFix)new JavaFxOptimizeImportsFix(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, isOnTheFly));
                continue;
            }
            if (usedNames.contains(target) && !targetProcessingInstructions.containsKey(StringUtil.getPackageName((String)target) + ".*")) continue;
            problems.add(inspectionManager.createProblemDescriptor((PsiElement)instruction, "Unused import", (LocalQuickFix)new JavaFxOptimizeImportsFix(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, isOnTheFly));
        }
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static class JavaFxOptimizeImportsFix
    implements LocalQuickFix {
        private JavaFxOptimizeImportsFix() {
        }

        @NotNull
        public String getName() {
            String string = QuickFixBundle.message((String)"optimize.imports.fix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnusedImportsInspection$JavaFxOptimizeImportsFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message((String)"optimize.imports.fix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnusedImportsInspection$JavaFxOptimizeImportsFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnusedImportsInspection$JavaFxOptimizeImportsFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnusedImportsInspection$JavaFxOptimizeImportsFix", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement == null) {
                return;
            }
            PsiFile file = psiElement.getContainingFile();
            if (file == null || !JavaFxFileTypeFactory.isFxml(file)) {
                return;
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            JavaFxImportsOptimizer optimizer = new JavaFxImportsOptimizer();
            final Runnable runnable = optimizer.processFile(file);
            new WriteCommandAction.Simple(project, this.getFamilyName(), new PsiFile[]{file}){

                protected void run() throws Throwable {
                    runnable.run();
                }
            }.execute();
        }
    }
}

