/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.PushTargetTextField;
import com.intellij.dvcs.push.ui.VcsEditableTextComponent;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.dvcs.push.ui.VcsLinkedTextComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitRemoteBranch;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushTargetPanel
extends PushTargetPanel<GitPushTarget> {
    private static final Logger LOG = Logger.getInstance(GitPushTargetPanel.class);
    private static final Comparator<GitRemoteBranch> REMOTE_BRANCH_COMPARATOR = new MyRemoteBranchComparator();
    private static final String SEPARATOR = " : ";
    @NotNull
    private final GitRepository myRepository;
    @NotNull
    private final VcsEditableTextComponent myTargetRenderedComponent;
    @NotNull
    private final PushTargetTextField myTargetTextField;
    @NotNull
    private final VcsLinkedTextComponent myRemoteRenderedComponent;
    @Nullable
    private GitPushTarget myCurrentTarget;
    @Nullable
    private String myError;
    @Nullable
    private Runnable myFireOnChangeAction;

    public GitPushTargetPanel(@NotNull GitRepository repository, @Nullable GitPushTarget defaultTarget) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushTargetPanel", "<init>"));
        }
        this.myRepository = repository;
        this.myCurrentTarget = defaultTarget;
        String initialBranch = "";
        String initialRemote = "";
        if (defaultTarget == null) {
            this.myError = repository.getCurrentBranch() == null ? "Detached HEAD" : (repository.getRemotes().isEmpty() ? "No remotes" : (repository.isFresh() ? "Empty repository" : "Can't push"));
        } else {
            initialBranch = GitPushTargetPanel.getTextFieldText(defaultTarget);
            initialRemote = defaultTarget.getBranch().getRemote().getName();
        }
        this.myTargetRenderedComponent = new VcsEditableTextComponent("<a href=''>" + initialBranch + "</a>", null);
        this.myTargetTextField = new PushTargetTextField(repository.getProject(), GitPushTargetPanel.getTargetNames(this.myRepository), initialBranch);
        this.myRemoteRenderedComponent = new VcsLinkedTextComponent("<a href=''>" + initialRemote + "</a>", new VcsLinkListener(){

            public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                if (sourceNode == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNode", "git4idea/push/GitPushTargetPanel$1", "hyperlinkActivated"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/push/GitPushTargetPanel$1", "hyperlinkActivated"));
                }
                GitPushTargetPanel.this.showRemoteSelector(event);
            }
        });
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JPanel remoteAndSeparator = new JPanel(new BorderLayout());
        remoteAndSeparator.setOpaque(false);
        remoteAndSeparator.add((Component)this.myRemoteRenderedComponent, "Center");
        remoteAndSeparator.add((Component)new JBLabel(SEPARATOR), "East");
        this.add(remoteAndSeparator, "West");
        this.add((Component)this.myTargetTextField, "Center");
        this.updateTextField();
    }

    private void updateTextField() {
        this.myTargetTextField.setVisible(!this.myRepository.getRemotes().isEmpty());
    }

    private void showRemoteSelector(@NotNull MouseEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/push/GitPushTargetPanel", "showRemoteSelector"));
        }
        List<String> remotes = this.getRemotes();
        if (remotes.size() <= 1) {
            return;
        }
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(null, remotes){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                GitPushTargetPanel.this.myRemoteRenderedComponent.updateLinkText(selectedValue);
                if (GitPushTargetPanel.this.myFireOnChangeAction != null) {
                    GitPushTargetPanel.this.myFireOnChangeAction.run();
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }
        });
        popup.show(new RelativePoint(event));
    }

    @NotNull
    private List<String> getRemotes() {
        List list = ContainerUtil.map(this.myRepository.getRemotes(), (Function)new Function<GitRemote, String>(){

            public String fun(GitRemote remote) {
                return remote.getName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel", "getRemotes"));
        }
        return list;
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer, boolean isSelected, boolean isActive) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "git4idea/push/GitPushTargetPanel", "render"));
        }
        SimpleTextAttributes targetTextAttributes = PushLogTreeUtil.addTransparencyIfNeeded((SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (boolean)isActive);
        if (this.myError != null) {
            renderer.append(this.myError, PushLogTreeUtil.addTransparencyIfNeeded((SimpleTextAttributes)SimpleTextAttributes.ERROR_ATTRIBUTES, (boolean)isActive));
        } else {
            String currentRemote = this.myRemoteRenderedComponent.getText();
            if (this.getRemotes().size() > 1) {
                this.myRemoteRenderedComponent.setSelected(isSelected);
                this.myRemoteRenderedComponent.setTransparent(!isActive);
                this.myRemoteRenderedComponent.render(renderer);
            } else {
                renderer.append(currentRemote, targetTextAttributes);
            }
            renderer.append(SEPARATOR, targetTextAttributes);
            GitPushTarget target = this.getValue();
            if (target.isNewBranchCreated()) {
                renderer.append("+", PushLogTreeUtil.addTransparencyIfNeeded((SimpleTextAttributes)SimpleTextAttributes.SYNTHETIC_ATTRIBUTES, (boolean)isActive), (Object)this);
            }
            this.myTargetRenderedComponent.setSelected(isSelected);
            this.myTargetRenderedComponent.setTransparent(!isActive);
            this.myTargetRenderedComponent.render(renderer);
        }
    }

    @NotNull
    public GitPushTarget getValue() {
        GitPushTarget gitPushTarget = (GitPushTarget)ObjectUtils.assertNotNull((Object)this.myCurrentTarget);
        if (gitPushTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel", "getValue"));
        }
        return gitPushTarget;
    }

    @NotNull
    private static String getTextFieldText(@Nullable GitPushTarget target) {
        String string = target != null ? target.getBranch().getNameForRemoteOperations() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel", "getTextFieldText"));
        }
        return string;
    }

    public void fireOnCancel() {
        this.myTargetTextField.setText(GitPushTargetPanel.getTextFieldText(this.myCurrentTarget));
    }

    public void fireOnChange() {
        if (this.myError != null) {
            return;
        }
        String remoteName = this.myRemoteRenderedComponent.getText();
        String branchName = this.myTargetTextField.getText();
        try {
            this.myCurrentTarget = GitPushTarget.parse(this.myRepository, remoteName, branchName);
            this.myTargetRenderedComponent.updateLinkText(branchName);
        }
        catch (ParseException e) {
            LOG.error("Invalid remote name shouldn't be allowed. [" + remoteName + ", " + branchName + "]", (Throwable)e);
        }
    }

    @Nullable
    public ValidationInfo verify() {
        if (this.myError != null) {
            return new ValidationInfo(this.myError, (JComponent)this.myTargetTextField);
        }
        try {
            GitPushTarget.parse(this.myRepository, this.myRemoteRenderedComponent.getText(), this.myTargetTextField.getText());
            return null;
        }
        catch (ParseException e) {
            return new ValidationInfo(e.getMessage(), (JComponent)this.myTargetTextField);
        }
    }

    public void setFireOnChangeAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "git4idea/push/GitPushTargetPanel", "setFireOnChangeAction"));
        }
        this.myFireOnChangeAction = action;
    }

    @NotNull
    public static List<String> getTargetNames(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushTargetPanel", "getTargetNames"));
        }
        List remoteBranches = ContainerUtil.sorted(repository.getBranches().getRemoteBranches(), REMOTE_BRANCH_COMPARATOR);
        List list = ContainerUtil.map((Collection)remoteBranches, (Function)new Function<GitRemoteBranch, String>(){

            public String fun(GitRemoteBranch branch) {
                return branch.getNameForRemoteOperations();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel", "getTargetNames"));
        }
        return list;
    }

    private static class MyRemoteBranchComparator
    implements Comparator<GitRemoteBranch> {
        private MyRemoteBranchComparator() {
        }

        @Override
        public int compare(@NotNull GitRemoteBranch o1, @NotNull GitRemoteBranch o2) {
            String remoteName2;
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "git4idea/push/GitPushTargetPanel$MyRemoteBranchComparator", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "git4idea/push/GitPushTargetPanel$MyRemoteBranchComparator", "compare"));
            }
            String remoteName1 = o1.getRemote().getName();
            int remoteComparison = remoteName1.compareTo(remoteName2 = o2.getRemote().getName());
            if (remoteComparison != 0) {
                if (remoteName1.equals("origin")) {
                    return -1;
                }
                if (remoteName2.equals("origin")) {
                    return 1;
                }
                return remoteComparison;
            }
            return o1.getNameForLocalOperations().compareTo(o2.getNameForLocalOperations());
        }
    }
}

