/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitSvnRemoteBranch;
import git4idea.GitTag;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeUtil;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.GitReferenceValidator;
import git4idea.util.GitUIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GitRebaseDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(GitRebaseDialog.class);
    protected ComboBox myGitRootComboBox;
    protected ComboBox myBranchComboBox;
    protected ComboBox myFromComboBox;
    private JButton myFromValidateButton;
    protected ComboBox myOntoComboBox;
    private JButton myOntoValidateButton;
    private JCheckBox myShowTagsCheckBox;
    private ComboBox myMergeStrategyComboBox;
    protected JCheckBox myInteractiveCheckBox;
    private JCheckBox myDoNotUseMergeCheckBox;
    private JPanel myPanel;
    protected JCheckBox myShowRemoteBranchesCheckBox;
    private JCheckBox myPreserveMergesCheckBox;
    protected final Project myProject;
    protected final List<GitBranch> myLocalBranches;
    protected final List<GitBranch> myRemoteBranches;
    protected GitBranch myCurrentBranch;
    protected final List<GitTag> myTags;
    private final GitReferenceValidator myOntoValidator;
    private final GitReferenceValidator myFromValidator;

    public GitRebaseDialog(Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myLocalBranches = new ArrayList<GitBranch>();
        this.myRemoteBranches = new ArrayList<GitBranch>();
        this.myTags = new ArrayList<GitTag>();
        this.setTitle(GitBundle.getString("rebase.title"));
        this.setOKButtonText(GitBundle.getString("rebase.button"));
        this.init();
        this.myProject = project;
        Runnable validateRunnable = new Runnable(){

            @Override
            public void run() {
                GitRebaseDialog.this.validateFields();
            }
        };
        this.myOntoValidator = new GitReferenceValidator(this.myProject, (JComboBox)this.myGitRootComboBox, GitUIUtil.getTextField((JComboBox)this.myOntoComboBox), this.myOntoValidateButton, validateRunnable);
        this.myFromValidator = new GitReferenceValidator(this.myProject, (JComboBox)this.myGitRootComboBox, GitUIUtil.getTextField((JComboBox)this.myFromComboBox), this.myFromValidateButton, validateRunnable);
        GitUIUtil.setupRootChooser(this.myProject, roots, defaultRoot, (JComboBox)this.myGitRootComboBox, null);
        this.myGitRootComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRebaseDialog.this.validateFields();
            }
        });
        this.setupBranches();
        this.setupStrategy();
        this.validateFields();
    }

    public GitLineHandler handler() {
        GitLineHandler h = new GitLineHandler(this.myProject, this.gitRoot(), GitCommand.REBASE);
        h.setStdoutSuppressed(false);
        if (this.myInteractiveCheckBox.isSelected() && this.myInteractiveCheckBox.isEnabled()) {
            h.addParameters("-i");
        }
        h.addParameters("-v");
        if (!this.myDoNotUseMergeCheckBox.isSelected()) {
            if (this.myMergeStrategyComboBox.getSelectedItem().equals(GitMergeUtil.DEFAULT_STRATEGY)) {
                h.addParameters("-m");
            } else {
                h.addParameters("-s", this.myMergeStrategyComboBox.getSelectedItem().toString());
            }
        }
        if (this.myPreserveMergesCheckBox.isSelected()) {
            h.addParameters("-p");
        }
        String from = GitUIUtil.getTextField((JComboBox)this.myFromComboBox).getText();
        String onto = GitUIUtil.getTextField((JComboBox)this.myOntoComboBox).getText();
        if (from.length() == 0) {
            h.addParameters(onto);
        } else {
            h.addParameters("--onto", onto, from);
        }
        String selectedBranch = (String)this.myBranchComboBox.getSelectedItem();
        if (this.myCurrentBranch != null && !this.myCurrentBranch.getName().equals(selectedBranch)) {
            h.addParameters(selectedBranch);
        }
        return h;
    }

    private void setupStrategy() {
        for (String s : GitMergeUtil.getMergeStrategies(1)) {
            this.myMergeStrategyComboBox.addItem((Object)s);
        }
        this.myMergeStrategyComboBox.setSelectedItem((Object)GitMergeUtil.DEFAULT_STRATEGY);
        this.myDoNotUseMergeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRebaseDialog.this.myMergeStrategyComboBox.setEnabled(!GitRebaseDialog.this.myDoNotUseMergeCheckBox.isSelected());
            }
        });
    }

    private void validateFields() {
        if (GitUIUtil.getTextField((JComboBox)this.myOntoComboBox).getText().length() == 0) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        if (this.myOntoValidator.isInvalid()) {
            this.setErrorText(GitBundle.getString("rebase.invalid.onto"));
            this.setOKActionEnabled(false);
            return;
        }
        if (GitUIUtil.getTextField((JComboBox)this.myFromComboBox).getText().length() != 0 && this.myFromValidator.isInvalid()) {
            this.setErrorText(GitBundle.getString("rebase.invalid.from"));
            this.setOKActionEnabled(false);
            return;
        }
        if (GitRebaseUtils.isRebaseInTheProgress(this.gitRoot())) {
            this.setErrorText(GitBundle.getString("rebase.in.progress"));
            this.setOKActionEnabled(false);
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    private void setupBranches() {
        GitUIUtil.getTextField((JComboBox)this.myOntoComboBox).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GitRebaseDialog.this.validateFields();
            }
        });
        ActionListener rootListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRebaseDialog.this.loadRefs();
                GitRebaseDialog.this.updateBranches();
            }
        };
        ActionListener showListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRebaseDialog.this.updateOntoFrom();
            }
        };
        this.myShowRemoteBranchesCheckBox.addActionListener(showListener);
        this.myShowTagsCheckBox.addActionListener(showListener);
        rootListener.actionPerformed(null);
        this.myGitRootComboBox.addActionListener(rootListener);
        this.myBranchComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRebaseDialog.this.updateTrackedBranch();
            }
        });
    }

    private void updateBranches() {
        this.myBranchComboBox.removeAllItems();
        for (GitBranch b : this.myLocalBranches) {
            this.myBranchComboBox.addItem((Object)b.getName());
        }
        if (this.myCurrentBranch != null) {
            this.myBranchComboBox.setSelectedItem((Object)this.myCurrentBranch.getName());
        } else {
            this.myBranchComboBox.setSelectedItem((Object)0);
        }
        this.updateOntoFrom();
        this.updateTrackedBranch();
    }

    protected void updateOntoFrom() {
        String onto = GitUIUtil.getTextField((JComboBox)this.myOntoComboBox).getText();
        String from = GitUIUtil.getTextField((JComboBox)this.myFromComboBox).getText();
        this.myFromComboBox.removeAllItems();
        this.myOntoComboBox.removeAllItems();
        for (GitBranch b : this.myLocalBranches) {
            this.myFromComboBox.addItem((Object)b);
            this.myOntoComboBox.addItem((Object)b);
        }
        if (this.myShowRemoteBranchesCheckBox.isSelected()) {
            for (GitBranch b : this.myRemoteBranches) {
                this.myFromComboBox.addItem((Object)b);
                this.myOntoComboBox.addItem((Object)b);
            }
        }
        if (this.myShowTagsCheckBox.isSelected()) {
            for (GitTag t : this.myTags) {
                this.myFromComboBox.addItem((Object)t);
                this.myOntoComboBox.addItem((Object)t);
            }
        }
        GitUIUtil.getTextField((JComboBox)this.myOntoComboBox).setText(onto);
        GitUIUtil.getTextField((JComboBox)this.myFromComboBox).setText(from);
    }

    protected void loadRefs() {
        try {
            this.myLocalBranches.clear();
            this.myRemoteBranches.clear();
            this.myTags.clear();
            VirtualFile root = this.gitRoot();
            GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(root);
            if (repository != null) {
                this.myLocalBranches.addAll(repository.getBranches().getLocalBranches());
                this.myRemoteBranches.addAll(repository.getBranches().getRemoteBranches());
                this.myCurrentBranch = repository.getCurrentBranch();
            } else {
                LOG.error("Repository is null for root " + root);
            }
            GitTag.list(this.myProject, root, this.myTags);
        }
        catch (VcsException e) {
            GitUIUtil.showOperationError(this.myProject, e, "git branch -a");
        }
    }

    private void updateTrackedBranch() {
        try {
            VirtualFile root = this.gitRoot();
            String currentBranch = (String)this.myBranchComboBox.getSelectedItem();
            GitRemoteBranch trackedBranch = null;
            if (currentBranch != null) {
                String remote = GitConfigUtil.getValue(this.myProject, root, "branch." + currentBranch + ".remote");
                String mergeBranch = GitConfigUtil.getValue(this.myProject, root, "branch." + currentBranch + ".merge");
                if (remote == null || mergeBranch == null) {
                    trackedBranch = null;
                } else {
                    mergeBranch = GitBranchUtil.stripRefsPrefix(mergeBranch);
                    if (remote.equals(".")) {
                        trackedBranch = new GitSvnRemoteBranch(mergeBranch, GitBranch.DUMMY_HASH);
                    } else {
                        GitRemote r = GitBranchUtil.findRemoteByNameOrLogError(this.myProject, root, remote);
                        if (r != null) {
                            trackedBranch = new GitStandardRemoteBranch(r, mergeBranch, GitBranch.DUMMY_HASH);
                        }
                    }
                }
            }
            if (trackedBranch != null) {
                this.myOntoComboBox.setSelectedItem(trackedBranch);
            } else {
                GitUIUtil.getTextField((JComboBox)this.myOntoComboBox).setText("");
            }
            GitUIUtil.getTextField((JComboBox)this.myFromComboBox).setText("");
        }
        catch (VcsException e) {
            GitUIUtil.showOperationError(this.myProject, e, "git config");
        }
    }

    public VirtualFile gitRoot() {
        return (VirtualFile)this.myGitRootComboBox.getSelectedItem();
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.Rebase";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        ComboBox comboBox;
        JButton jButton;
        ComboBox comboBox2;
        JButton jButton2;
        ComboBox comboBox3;
        ComboBox comboBox4;
        ComboBox comboBox5;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myGitRootComboBox = comboBox5 = new ComboBox();
        comboBox5.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root.tooltip"));
        jPanel.add((Component)comboBox5, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.branch"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBranchComboBox = comboBox4 = new ComboBox();
        comboBox4.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.branch.tooltip"));
        jPanel.add((Component)comboBox4, new GridConstraints(1, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.onto"));
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOntoComboBox = comboBox3 = new ComboBox();
        comboBox3.setEditable(true);
        comboBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.onto.tooltip"));
        jPanel.add((Component)comboBox3, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myOntoValidateButton = jButton2 = new JButton();
        jButton2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.valdate.onto.tooltip"));
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.onto.validate"));
        jPanel.add((Component)jButton2, new GridConstraints(3, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.merge.strategy"));
        jPanel.add((Component)jLabel4, new GridConstraints(6, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.from"));
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFromComboBox = comboBox2 = new ComboBox();
        comboBox2.setEditable(true);
        comboBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.from.tooltip"));
        jPanel.add((Component)comboBox2, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myFromValidateButton = jButton = new JButton();
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.validate.from.tooltip"));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.validate.from"));
        jPanel.add((Component)jButton, new GridConstraints(4, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(6, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myMergeStrategyComboBox = comboBox = new ComboBox();
        comboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.merge.strategy.tooltip"));
        jPanel2.add((Component)comboBox, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDoNotUseMergeCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.no.merge"));
        jCheckBox5.setSelected(false);
        jCheckBox5.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.no.merge.tooltip"));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(2, 1, 1, 2, 0, 3, 7, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPreserveMergesCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.preserve.merges"));
        jCheckBox4.setSelected(false);
        jCheckBox4.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.preserve.merges.tooltip"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInteractiveCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.interactive"));
        jCheckBox3.setSelected(true);
        ((Component)jCheckBox3).setEnabled(true);
        jCheckBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.interactive.tooltip"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(5, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myShowTagsCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("regase.show.tags"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.show.tags.tooltip"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowRemoteBranchesCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.show.remote.branches"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.show.remote.branches.tooltip"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel.setLabelFor((Component)comboBox5);
        jLabel2.setLabelFor((Component)comboBox4);
        jLabel3.setLabelFor((Component)comboBox3);
        jLabel4.setLabelFor((Component)comboBox);
        jLabel5.setLabelFor((Component)comboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

