/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.openapi.util.Ref;
import com.intellij.util.ThreeState;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DiffTree<OT, NT> {
    private static final int CHANGE_PARENT_VERSUS_CHILDREN_THRESHOLD = 20;
    private final FlyweightCapableTreeStructure<OT> myOldTree;
    private final FlyweightCapableTreeStructure<NT> myNewTree;
    private final ShallowNodeComparator<OT, NT> myComparator;
    private final DiffTreeChangeBuilder<OT, NT> myConsumer;
    private final List<Ref<OT[]>> myOldChildrenLists;
    private final List<Ref<NT[]>> myNewChildrenLists;

    private DiffTree(@NotNull FlyweightCapableTreeStructure<OT> oldTree, @NotNull FlyweightCapableTreeStructure<NT> newTree, @NotNull ShallowNodeComparator<OT, NT> comparator, @NotNull DiffTreeChangeBuilder<OT, NT> consumer) {
        if (oldTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldTree", "com/intellij/util/diff/DiffTree", "<init>"));
        }
        if (newTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTree", "com/intellij/util/diff/DiffTree", "<init>"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/diff/DiffTree", "<init>"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/diff/DiffTree", "<init>"));
        }
        this.myOldChildrenLists = new ArrayList<Ref<OT[]>>();
        this.myNewChildrenLists = new ArrayList<Ref<NT[]>>();
        this.myOldTree = oldTree;
        this.myNewTree = newTree;
        this.myComparator = comparator;
        this.myConsumer = consumer;
    }

    public static <OT, NT> void diff(@NotNull FlyweightCapableTreeStructure<OT> oldTree, @NotNull FlyweightCapableTreeStructure<NT> newTree, @NotNull ShallowNodeComparator<OT, NT> comparator, @NotNull DiffTreeChangeBuilder<OT, NT> consumer) {
        if (oldTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldTree", "com/intellij/util/diff/DiffTree", "diff"));
        }
        if (newTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTree", "com/intellij/util/diff/DiffTree", "diff"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/diff/DiffTree", "diff"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/diff/DiffTree", "diff"));
        }
        super.build(oldTree.getRoot(), newTree.getRoot(), 0);
    }

    private void build(@NotNull OT oldN, @NotNull NT newN, int level) {
        if (oldN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldN", "com/intellij/util/diff/DiffTree", "build"));
        }
        if (newN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newN", "com/intellij/util/diff/DiffTree", "build"));
        }
        OT oldNode = this.myOldTree.prepareForGetChildren(oldN);
        NT newNode = this.myNewTree.prepareForGetChildren(newN);
        if (level == this.myNewChildrenLists.size()) {
            this.myNewChildrenLists.add(new Ref());
            this.myOldChildrenLists.add(new Ref());
        }
        Ref<T[]> oldChildrenR = this.myOldChildrenLists.get(level);
        int oldChildrenSize = this.myOldTree.getChildren(oldNode, oldChildrenR);
        T[] oldChildren = oldChildrenR.get();
        Ref<T[]> newChildrenR = this.myNewChildrenLists.get(level);
        int newChildrenSize = this.myNewTree.getChildren(newNode, newChildrenR);
        T[] newChildren = newChildrenR.get();
        if (Math.abs(oldChildrenSize - newChildrenSize) > 20) {
            this.myConsumer.nodeReplaced(oldNode, newNode);
        } else if (oldChildrenSize == 0 && newChildrenSize == 0) {
            if (!this.myComparator.hashCodesEqual(oldNode, newNode) || !this.myComparator.typesEqual(oldNode, newNode)) {
                this.myConsumer.nodeReplaced(oldNode, newNode);
            }
        } else {
            Object newChild1;
            Object oldChild1;
            CompareResult c11;
            int newSize;
            int oldSize = oldChildrenSize;
            ShallowNodeComparator<OT, NT> comparator = this.myComparator;
            for (newSize = newChildrenSize; oldSize > 0 && newSize > 0 && ((c11 = DiffTree.looksEqual(comparator, oldChild1 = oldChildren[oldSize - 1], newChild1 = newChildren[newSize - 1])) == CompareResult.EQUAL || c11 == CompareResult.DRILL_DOWN_NEEDED); --oldSize, --newSize) {
                if (c11 != CompareResult.DRILL_DOWN_NEEDED) continue;
                this.build(oldChild1, newChild1, level + 1);
            }
            int oldIndex = 0;
            int newIndex = 0;
            while (oldIndex < oldSize || newIndex < newSize) {
                Object oldChild12 = oldIndex < oldSize ? (Object)oldChildren[oldIndex] : null;
                OT oldChild2 = oldIndex < oldSize - 1 ? (OT)oldChildren[oldIndex + 1] : null;
                Object newChild12 = newIndex < newSize ? (Object)newChildren[newIndex] : null;
                NT newChild2 = newIndex < newSize - 1 ? (NT)newChildren[newIndex + 1] : null;
                CompareResult c112 = DiffTree.looksEqual(comparator, oldChild12, newChild12);
                if (c112 == CompareResult.EQUAL || c112 == CompareResult.DRILL_DOWN_NEEDED) {
                    if (c112 == CompareResult.DRILL_DOWN_NEEDED) {
                        this.build(oldChild12, newChild12, level + 1);
                    }
                    ++oldIndex;
                    ++newIndex;
                    continue;
                }
                if (c112 == CompareResult.TYPE_ONLY) {
                    CompareResult c21 = DiffTree.looksEqual(comparator, oldChild2, newChild12);
                    if (c21 == CompareResult.EQUAL || c21 == CompareResult.DRILL_DOWN_NEEDED) {
                        this.myConsumer.nodeDeleted(oldNode, oldChild12);
                        ++oldIndex;
                        continue;
                    }
                    CompareResult c12 = DiffTree.looksEqual(comparator, oldChild12, newChild2);
                    if (c12 == CompareResult.EQUAL || c12 == CompareResult.DRILL_DOWN_NEEDED) {
                        this.myConsumer.nodeInserted(oldNode, newChild12, newIndex);
                        ++newIndex;
                        continue;
                    }
                    this.myConsumer.nodeReplaced(oldChild12, newChild12);
                    ++oldIndex;
                    ++newIndex;
                    continue;
                }
                CompareResult c12 = DiffTree.looksEqual(comparator, oldChild12, newChild2);
                if (c12 == CompareResult.EQUAL || c12 == CompareResult.DRILL_DOWN_NEEDED || c12 == CompareResult.TYPE_ONLY) {
                    this.myConsumer.nodeInserted(oldNode, newChild12, newIndex);
                    ++newIndex;
                    continue;
                }
                CompareResult c21 = DiffTree.looksEqual(comparator, oldChild2, newChild12);
                if (c21 == CompareResult.EQUAL || c21 == CompareResult.DRILL_DOWN_NEEDED || c21 == CompareResult.TYPE_ONLY) {
                    this.myConsumer.nodeDeleted(oldNode, oldChild12);
                    ++oldIndex;
                    continue;
                }
                if (oldChild12 == null) {
                    this.myConsumer.nodeInserted(oldNode, newChild12, newIndex);
                    ++newIndex;
                    continue;
                }
                if (newChild12 == null) {
                    this.myConsumer.nodeDeleted(oldNode, oldChild12);
                    ++oldIndex;
                    continue;
                }
                this.myConsumer.nodeReplaced(oldChild12, newChild12);
                ++oldIndex;
                ++newIndex;
            }
        }
        this.myOldTree.disposeChildren(oldChildren, oldChildrenSize);
        this.myNewTree.disposeChildren(newChildren, newChildrenSize);
    }

    @NotNull
    private static <OT, NT> CompareResult looksEqual(@NotNull ShallowNodeComparator<OT, NT> comparator, OT oldChild1, NT newChild1) {
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/diff/DiffTree", "looksEqual"));
        }
        if (oldChild1 == null || newChild1 == null) {
            CompareResult compareResult = oldChild1 == newChild1 ? CompareResult.EQUAL : CompareResult.NOT_EQUAL;
            if (compareResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/diff/DiffTree", "looksEqual"));
            }
            return compareResult;
        }
        if (!comparator.typesEqual(oldChild1, newChild1)) {
            CompareResult compareResult = CompareResult.NOT_EQUAL;
            if (compareResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/diff/DiffTree", "looksEqual"));
            }
            return compareResult;
        }
        ThreeState ret = comparator.deepEqual(oldChild1, newChild1);
        if (ret == ThreeState.YES) {
            CompareResult compareResult = CompareResult.EQUAL;
            if (compareResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/diff/DiffTree", "looksEqual"));
            }
            return compareResult;
        }
        if (ret == ThreeState.UNSURE) {
            CompareResult compareResult = CompareResult.DRILL_DOWN_NEEDED;
            if (compareResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/diff/DiffTree", "looksEqual"));
            }
            return compareResult;
        }
        CompareResult compareResult = CompareResult.TYPE_ONLY;
        if (compareResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/diff/DiffTree", "looksEqual"));
        }
        return compareResult;
    }

    private static enum CompareResult {
        EQUAL,
        DRILL_DOWN_NEEDED,
        TYPE_ONLY,
        NOT_EQUAL;

    }
}

