/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseInputStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseOutputReader
extends BaseDataReader {
    protected final Reader myReader;
    private final char[] myBuffer;
    private final StringBuilder myTextBuffer;
    private boolean skipLF;

    public BaseOutputReader(@NotNull InputStream inputStream, @Nullable Charset charset) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        this(inputStream, charset, null);
    }

    public BaseOutputReader(@NotNull InputStream inputStream, @Nullable Charset charset, @Nullable BaseDataReader.SleepingPolicy sleepingPolicy) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        super(sleepingPolicy);
        this.myBuffer = new char[8192];
        this.myTextBuffer = new StringBuilder();
        this.skipLF = false;
        this.myReader = BaseOutputReader.createInputStreamReader(inputStream, charset);
    }

    public BaseOutputReader(@NotNull Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        this(reader, null);
    }

    public BaseOutputReader(@NotNull Reader reader, BaseDataReader.SleepingPolicy sleepingPolicy) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        super(sleepingPolicy);
        this.myBuffer = new char[8192];
        this.myTextBuffer = new StringBuilder();
        this.skipLF = false;
        if (sleepingPolicy == BaseDataReader.SleepingPolicy.BLOCKING && !(reader instanceof BaseInputStreamReader)) {
            throw new IllegalArgumentException("Blocking policy can be used only with BaseInputStreamReader, that doesn't lock on close");
        }
        this.myReader = reader;
    }

    private static Reader createInputStreamReader(@NotNull InputStream streamToRead, @Nullable Charset charset) {
        if (streamToRead == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamToRead", "com/intellij/util/io/BaseOutputReader", "createInputStreamReader"));
        }
        if (charset == null) {
            return new BaseInputStreamReader(streamToRead);
        }
        return new BaseInputStreamReader(streamToRead, charset);
    }

    private void processLine(char[] buffer, StringBuilder token, int n) {
        for (int i = 0; i < n; ++i) {
            char c = buffer[i];
            if (this.skipLF && c != '\n') {
                token.append('\r');
            }
            if (c == '\r') {
                this.skipLF = true;
            } else {
                this.skipLF = false;
                token.append(c);
            }
            if (c != '\n') continue;
            this.onTextAvailable(token.toString());
            token.setLength(0);
        }
    }

    protected final boolean readAvailableNonBlocking() throws IOException {
        int n;
        char[] buffer = this.myBuffer;
        StringBuilder token = this.myTextBuffer;
        token.setLength(0);
        boolean read = false;
        while (this.myReader.ready() && (n = this.myReader.read(buffer)) > 0) {
            read = true;
            this.processLine(buffer, token, n);
        }
        if (token.length() != 0) {
            this.onTextAvailable(token.toString());
            token.setLength(0);
        }
        return read;
    }

    protected final boolean readAvailableBlocking() throws IOException {
        int n;
        char[] buffer = this.myBuffer;
        StringBuilder token = this.myTextBuffer;
        token.setLength(0);
        boolean read = false;
        while ((n = this.myReader.read(buffer)) > 0) {
            read = true;
            this.processLine(buffer, token, n);
        }
        if (token.length() != 0) {
            this.onTextAvailable(token.toString());
            token.setLength(0);
        }
        return read;
    }

    @Override
    protected boolean readAvailable() throws IOException {
        return this.mySleepingPolicy == BaseDataReader.SleepingPolicy.BLOCKING ? this.readAvailableBlocking() : this.readAvailableNonBlocking();
    }

    @Override
    protected void close() throws IOException {
        this.myReader.close();
    }

    protected abstract void onTextAvailable(@NotNull String var1);
}

