/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OpenFileHyperlink
extends NotificationHyperlink {
    @NotNull
    private final String myFilePath;
    private final int myLine;

    public OpenFileHyperlink(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/idea/gradle/service/notification/hyperlink/OpenFileHyperlink", "<init>"));
        }
        this(filePath, -1);
    }

    public OpenFileHyperlink(@NotNull String filePath, int line) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/idea/gradle/service/notification/hyperlink/OpenFileHyperlink", "<init>"));
        }
        super("openFile", "Open File");
        this.myFilePath = FileUtil.toSystemIndependentName((String)filePath);
        this.myLine = line;
    }

    @Override
    protected void execute(@NotNull Project project) {
        OpenFileDescriptor openFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/OpenFileHyperlink", "execute"));
        }
        VirtualFile projectFile = project.getProjectFile();
        if (projectFile == null) {
            return;
        }
        VirtualFile file = projectFile.getParent().getFileSystem().findFileByPath(this.myFilePath);
        if (file != null && (openFile = new OpenFileDescriptor(project, file, this.myLine, -1, false)).canNavigate()) {
            openFile.navigate(true);
        }
    }
}

