/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceType;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceTypeInspection
extends BaseJavaLocalInspectionTool {
    private static final String RESOURCE_TYPE_ANNOTATIONS_SUFFIX = "Res";
    private static final int VALID = 1001;
    private static final int INVALID = 1002;
    private static final int UNCERTAIN = 1003;
    private static final Key<Map<String, PsiExpression>> LITERAL_EXPRESSION_CACHE = Key.create((String)"TYPE_DEF_LITERAL_EXPRESSION");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/inspections/ResourceTypeInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "org/jetbrains/android/inspections/ResourceTypeInspection", "buildVisitor"));
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)holder.getFile());
        if (facet == null) {
            PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){};
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitCallExpression(PsiCallExpression callExpression) {
                ResourceTypeInspection.checkCall(callExpression, holder);
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                PsiExpression r = expression.getRExpression();
                if (r == null) {
                    return;
                }
                PsiExpression l = expression.getLExpression();
                if (!(l instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiElement resolved = ((PsiReferenceExpression)l).resolve();
                if (!(resolved instanceof PsiModifierListOwner)) {
                    return;
                }
                PsiModifierListOwner owner = (PsiModifierListOwner)resolved;
                PsiType type = expression.getType();
                ResourceTypeInspection.checkExpression(r, owner, type, holder);
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                PsiExpression value = statement.getReturnValue();
                if (value == null) {
                    return;
                }
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
                if (method == null) {
                    return;
                }
                ResourceTypeInspection.checkExpression(value, (PsiModifierListOwner)method, value.getType(), holder);
            }

            public void visitNameValuePair(PsiNameValuePair pair) {
                PsiAnnotationMemberValue value = pair.getValue();
                if (!(value instanceof PsiExpression)) {
                    return;
                }
                PsiReference ref = pair.getReference();
                if (ref == null) {
                    return;
                }
                PsiMethod method = (PsiMethod)ref.resolve();
                if (method == null) {
                    return;
                }
                ResourceTypeInspection.checkExpression((PsiExpression)value, (PsiModifierListOwner)method, method.getReturnType(), holder);
            }

            public void visitBinaryExpression(PsiBinaryExpression expression) {
                IElementType tokenType = expression.getOperationTokenType();
                if (tokenType != JavaTokenType.EQEQ && tokenType != JavaTokenType.NE) {
                    return;
                }
                PsiExpression l = expression.getLOperand();
                PsiExpression r = expression.getROperand();
                if (r == null) {
                    return;
                }
                this.checkBinary(l, r);
                this.checkBinary(r, l);
            }

            private void checkBinary(PsiExpression l, PsiExpression r) {
                PsiMethod method;
                if (l instanceof PsiReference) {
                    PsiElement resolved = ((PsiReference)l).resolve();
                    if (resolved instanceof PsiModifierListOwner) {
                        ResourceTypeInspection.checkExpression(r, (PsiModifierListOwner)resolved, ResourceTypeInspection.getType((PsiModifierListOwner)resolved), holder);
                    }
                } else if (l instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)l).resolveMethod()) != null) {
                    ResourceTypeInspection.checkExpression(r, (PsiModifierListOwner)method, method.getReturnType(), holder);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static void checkExpression(PsiExpression expression, PsiModifierListOwner owner, @Nullable PsiType type, ProblemsHolder holder) {
        AllowedValues allowed = ResourceTypeInspection.getAllowedValues(owner, type, null);
        if (allowed == null) {
            return;
        }
        PsiElement scope = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression, null);
        if (scope == null) {
            scope = expression;
        }
        if (!ResourceTypeInspection.isAllowed(scope, expression, allowed, expression.getManager(), null)) {
            ResourceTypeInspection.registerProblem(expression, allowed, holder);
        }
    }

    private static void checkCall(@NotNull PsiCallExpression methodCall, @NotNull ProblemsHolder holder) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/android/inspections/ResourceTypeInspection", "checkCall"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/inspections/ResourceTypeInspection", "checkCall"));
        }
        PsiMethod method = methodCall.resolveMethod();
        if (method == null) {
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiExpressionList argumentList = methodCall.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            AllowedValues values = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)parameter, parameter.getType(), null);
            if (values == null) continue;
            if (i >= arguments.length) break;
            PsiExpression argument = arguments[i];
            if ((argument = PsiUtil.deparenthesizeExpression((PsiExpression)argument)) == null) continue;
            ResourceTypeInspection.checkMagicParameterArgument(parameter, argument, values, holder);
        }
    }

    @Nullable
    private static AllowedValues getAllowedValuesFromTypedef(@NotNull PsiType type, @NotNull PsiAnnotation magic, @NotNull PsiManager manager) {
        boolean canBeOred;
        PsiAnnotationMemberValue[] allowedValues;
        boolean isString;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/inspections/ResourceTypeInspection", "getAllowedValuesFromTypedef"));
        }
        if (magic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "magic", "org/jetbrains/android/inspections/ResourceTypeInspection", "getAllowedValuesFromTypedef"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "getAllowedValuesFromTypedef"));
        }
        boolean isInt = TypeConversionUtil.getTypeRank((PsiType)type) <= 5;
        boolean bl = isString = !isInt && type.equals(PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)manager.getProject())));
        if (isInt || isString) {
            PsiAnnotationMemberValue orValue;
            PsiAnnotationMemberValue intValues = magic.findAttributeValue("value");
            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = allowedValues = intValues instanceof PsiArrayInitializerMemberValue ? ((PsiArrayInitializerMemberValue)intValues).getInitializers() : PsiAnnotationMemberValue.EMPTY_ARRAY;
            canBeOred = isInt ? (orValue = magic.findAttributeValue("flag")) instanceof PsiLiteral && Boolean.TRUE.equals(((PsiLiteral)orValue).getValue()) : false;
        } else {
            return null;
        }
        if (allowedValues.length != 0) {
            return new AllowedValues(allowedValues, canBeOred, null);
        }
        return null;
    }

    @Nullable
    private static ResourceType getResourceTypeFromAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/android/inspections/ResourceTypeInspection", "getResourceTypeFromAnnotation"));
        }
        String resourceTypeName = Character.toLowerCase(qualifiedName.charAt("android.support.annotation.".length())) + qualifiedName.substring("android.support.annotation.".length() + 1, qualifiedName.length() - RESOURCE_TYPE_ANNOTATIONS_SUFFIX.length());
        return ResourceType.getEnum((String)resourceTypeName);
    }

    @Nullable
    static AllowedValues getAllowedValues(@NotNull PsiModifierListOwner element, @Nullable PsiType type, @Nullable Set<PsiClass> visited) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/inspections/ResourceTypeInspection", "getAllowedValues"));
        }
        PsiAnnotation[] annotations = AnnotationUtil.getAllAnnotations((PsiModifierListOwner)element, (boolean)true, null);
        PsiManager manager = element.getManager();
        ArrayList resourceTypes = null;
        for (PsiAnnotation annotation : annotations) {
            PsiJavaCodeReferenceElement ref;
            PsiElement resolved;
            AllowedValues values;
            if (type != null) {
                ResourceType resourceType;
                String qualifiedName = annotation.getQualifiedName();
                if (qualifiedName == null) continue;
                if ("android.support.annotation.IntDef".equals(qualifiedName) || "android.support.annotation.StringDef".equals(qualifiedName)) {
                    values = ResourceTypeInspection.getAllowedValuesFromTypedef(type, annotation, manager);
                    if (values != null) {
                        return values;
                    }
                } else if (qualifiedName.startsWith("android.support.annotation.") && qualifiedName.endsWith(RESOURCE_TYPE_ANNOTATIONS_SUFFIX) && (resourceType = ResourceTypeInspection.getResourceTypeFromAnnotation(qualifiedName)) != null) {
                    if (resourceTypes == null) {
                        resourceTypes = Lists.newArrayList();
                    }
                    resourceTypes.add(resourceType);
                }
            }
            PsiElement psiElement = resolved = (ref = annotation.getNameReferenceElement()) == null ? null : ref.resolve();
            if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
            PsiClass aClass = (PsiClass)resolved;
            if (visited == null) {
                visited = new THashSet();
            }
            if (!visited.add((PsiClass)aClass) || (values = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)aClass, type, (Set<PsiClass>)visited)) == null) continue;
            return values;
        }
        if (resourceTypes != null) {
            return new AllowedValues(PsiAnnotationMemberValue.EMPTY_ARRAY, false, resourceTypes);
        }
        return null;
    }

    @Nullable
    private static PsiType getType(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/inspections/ResourceTypeInspection", "getType"));
        }
        return element instanceof PsiVariable ? ((PsiVariable)element).getType() : (element instanceof PsiMethod ? ((PsiMethod)element).getReturnType() : null);
    }

    private static void checkMagicParameterArgument(@NotNull PsiParameter parameter, @NotNull PsiExpression argument, @NotNull AllowedValues allowedValues, @NotNull ProblemsHolder holder) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/android/inspections/ResourceTypeInspection", "checkMagicParameterArgument"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection", "checkMagicParameterArgument"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "checkMagicParameterArgument"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/inspections/ResourceTypeInspection", "checkMagicParameterArgument"));
        }
        PsiManager manager = PsiManager.getInstance((Project)holder.getProject());
        if (!argument.getTextRange().isEmpty() && !ResourceTypeInspection.isAllowed(parameter.getDeclarationScope(), argument, allowedValues, manager, null)) {
            ResourceTypeInspection.registerProblem(argument, allowedValues, holder);
        }
    }

    private static void registerProblem(@NotNull PsiExpression argument, @NotNull AllowedValues allowedValues, @NotNull ProblemsHolder holder) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection", "registerProblem"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "registerProblem"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/inspections/ResourceTypeInspection", "registerProblem"));
        }
        if (allowedValues.types != null) {
            if (allowedValues.types.size() == 1) {
                holder.registerProblem((PsiElement)argument, "Expected resource of type " + allowedValues.types.get(0), new LocalQuickFix[0]);
            } else {
                holder.registerProblem((PsiElement)argument, "Expected resource type to be one of " + Joiner.on((String)", ").join(allowedValues.types), new LocalQuickFix[0]);
            }
            return;
        }
        String values = StringUtil.join((Object[])allowedValues.values, (Function)new Function<PsiAnnotationMemberValue, String>(){

            public String fun(PsiAnnotationMemberValue value) {
                PsiElement resolved;
                if (value instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiVariable) {
                    return PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)resolved), (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                }
                return value.getText();
            }
        }, (String)", ");
        String message = allowedValues.canBeOred ? "Must be one or more of: " + values : "Must be one of: " + values;
        holder.registerProblem((PsiElement)argument, message, new LocalQuickFix[0]);
    }

    private static boolean isAllowed(final @NotNull PsiElement scope, @NotNull PsiExpression argument, final @NotNull AllowedValues allowedValues, final @NotNull PsiManager manager, final @Nullable Set<PsiExpression> visited) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/inspections/ResourceTypeInspection", "isAllowed"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection", "isAllowed"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "isAllowed"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "isAllowed"));
        }
        if (allowedValues.types != null) {
            return ResourceTypeInspection.isResourceTypeAllowed(scope, argument, allowedValues, manager, visited);
        }
        if (ResourceTypeInspection.isGoodExpression(argument, allowedValues, scope, manager, visited)) {
            return true;
        }
        return ResourceTypeInspection.processValuesFlownTo(argument, scope, manager, new Processor<PsiExpression>(){

            public boolean process(PsiExpression expression) {
                return ResourceTypeInspection.isGoodExpression(expression, allowedValues, scope, manager, visited);
            }
        });
    }

    private static boolean isGoodExpression(@NotNull PsiExpression e, @NotNull AllowedValues allowedValues, @NotNull PsiElement scope, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        AllowedValues allowedForRef;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/inspections/ResourceTypeInspection", "isGoodExpression"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "isGoodExpression"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/inspections/ResourceTypeInspection", "isGoodExpression"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "isGoodExpression"));
        }
        PsiExpression expression = PsiUtil.deparenthesizeExpression((PsiExpression)e);
        if (expression == null) {
            return true;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiExpression)expression)) {
            return true;
        }
        if (expression instanceof PsiConditionalExpression) {
            boolean thenAllowed;
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            boolean bl = thenAllowed = thenExpression == null || ResourceTypeInspection.isAllowed(scope, thenExpression, allowedValues, manager, (Set<PsiExpression>)visited);
            if (!thenAllowed) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            return elseExpression == null || ResourceTypeInspection.isAllowed(scope, elseExpression, allowedValues, manager, (Set<PsiExpression>)visited);
        }
        assert (allowedValues.types == null);
        if (ResourceTypeInspection.isOneOf(expression, allowedValues, manager)) {
            return true;
        }
        if (allowedValues.canBeOred) {
            IElementType tokenType;
            PsiExpression zero = ResourceTypeInspection.getLiteralExpression(expression, manager, "0");
            if (ResourceTypeInspection.same((PsiElement)expression, (PsiElement)zero, manager)) {
                return true;
            }
            PsiExpression mOne = ResourceTypeInspection.getLiteralExpression(expression, manager, "-1");
            if (ResourceTypeInspection.same((PsiElement)expression, (PsiElement)mOne, manager)) {
                return true;
            }
            if (expression instanceof PsiPolyadicExpression && (JavaTokenType.OR.equals(tokenType = ((PsiPolyadicExpression)expression).getOperationTokenType()) || JavaTokenType.AND.equals(tokenType) || JavaTokenType.PLUS.equals(tokenType))) {
                for (PsiExpression operand : ((PsiPolyadicExpression)expression).getOperands()) {
                    if (ResourceTypeInspection.isAllowed(scope, operand, allowedValues, manager, (Set<PsiExpression>)visited)) continue;
                    return false;
                }
                return true;
            }
            if (expression instanceof PsiPrefixExpression && JavaTokenType.TILDE.equals(((PsiPrefixExpression)expression).getOperationTokenType())) {
                PsiExpression operand = ((PsiPrefixExpression)expression).getOperand();
                return operand == null || ResourceTypeInspection.isAllowed(scope, operand, allowedValues, manager, (Set<PsiExpression>)visited);
            }
        }
        PsiElement resolved = null;
        if (expression instanceof PsiReference) {
            resolved = ((PsiReference)expression).resolve();
        } else if (expression instanceof PsiCallExpression) {
            resolved = ((PsiCallExpression)expression).resolveMethod();
        }
        if (resolved instanceof PsiModifierListOwner && (allowedForRef = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)resolved, ResourceTypeInspection.getType((PsiModifierListOwner)resolved), null)) != null && allowedForRef.isSubsetOf(allowedValues, manager)) {
            return true;
        }
        return PsiType.NULL.equals((Object)expression.getType());
    }

    private static boolean isResourceTypeAllowed(final @NotNull PsiElement scope, @NotNull PsiExpression argument, final @NotNull AllowedValues allowedValues, final @NotNull PsiManager manager, final @Nullable Set<PsiExpression> visited) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/inspections/ResourceTypeInspection", "isResourceTypeAllowed"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection", "isResourceTypeAllowed"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "isResourceTypeAllowed"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "isResourceTypeAllowed"));
        }
        int result = ResourceTypeInspection.isValidResourceTypeExpression(argument, allowedValues, scope, manager, visited);
        if (result == 1001) {
            return true;
        }
        if (result == 1002) {
            return false;
        }
        assert (result == 1003);
        final AtomicInteger b = new AtomicInteger();
        ResourceTypeInspection.processValuesFlownTo(argument, scope, manager, new Processor<PsiExpression>(){

            public boolean process(PsiExpression expression) {
                int goodExpression = ResourceTypeInspection.isValidResourceTypeExpression(expression, allowedValues, scope, manager, visited);
                b.set(goodExpression);
                return goodExpression == 1003;
            }
        });
        result = b.get();
        return result != 1002;
    }

    private static int isValidResourceTypeExpression(@NotNull PsiExpression e, @NotNull AllowedValues allowedValues, @NotNull PsiElement scope, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        PsiType type;
        AllowedValues allowedForRef;
        Object value;
        PsiPrefixExpression ppe;
        PsiExpression r;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/inspections/ResourceTypeInspection", "isValidResourceTypeExpression"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "isValidResourceTypeExpression"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/inspections/ResourceTypeInspection", "isValidResourceTypeExpression"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "isValidResourceTypeExpression"));
        }
        PsiExpression expression = PsiUtil.deparenthesizeExpression((PsiExpression)e);
        if (expression == null) {
            return 1001;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiExpression)expression)) {
            return 1001;
        }
        if (expression instanceof PsiConditionalExpression) {
            boolean thenAllowed;
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            boolean bl = thenAllowed = thenExpression == null || ResourceTypeInspection.isAllowed(scope, thenExpression, allowedValues, manager, (Set<PsiExpression>)visited);
            if (!thenAllowed) {
                return 1002;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            return elseExpression == null || ResourceTypeInspection.isAllowed(scope, elseExpression, allowedValues, manager, (Set<PsiExpression>)visited) ? 1001 : 1003;
        }
        assert (allowedValues.types != null);
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression typeDef;
            PsiReferenceExpression refExpression = (PsiReferenceExpression)expression;
            PsiExpression qualifierExpression = refExpression.getQualifierExpression();
            if (qualifierExpression instanceof PsiReferenceExpression && (r = (typeDef = (PsiReferenceExpression)qualifierExpression).getQualifierExpression()) instanceof PsiReferenceExpression && "R".equals(((PsiReferenceExpression)r).getReferenceName())) {
                String typeName = typeDef.getReferenceName();
                return ResourceTypeInspection.isTypeAllowed(allowedValues, typeName);
            }
        } else if (expression instanceof PsiLiteral) {
            PsiElement outerMost;
            PsiElement parent;
            if (expression instanceof PsiLiteralExpression && (parent = expression.getParent()) instanceof PsiField && (parent = parent.getParent()) instanceof PsiClass && (outerMost = parent.getParent()) instanceof PsiClass && "R".equals(((PsiClass)outerMost).getName())) {
                PsiClass typeClass = (PsiClass)parent;
                String typeClassName = typeClass.getName();
                return ResourceTypeInspection.isTypeAllowed(allowedValues, typeClassName);
            }
            Object value2 = ((PsiLiteral)expression).getValue();
            if (value2 instanceof Integer) {
                return (Integer)value2 == 0 ? 1001 : 1002;
            }
        } else if (expression instanceof PsiPrefixExpression && (ppe = (PsiPrefixExpression)expression).getOperationTokenType() == JavaTokenType.MINUS && ppe.getOperand() instanceof PsiLiteral && (value = ((PsiLiteral)ppe.getOperand()).getValue()) instanceof Integer) {
            return (Integer)value == 1 ? 1001 : 1002;
        }
        PsiElement resolved = null;
        if (expression instanceof PsiReference) {
            ResourceType type2;
            PsiField field;
            PsiClass containingClass;
            resolved = ((PsiReference)expression).resolve();
            if (resolved instanceof PsiField && (containingClass = (field = (PsiField)resolved).getContainingClass()) != null && (r = containingClass.getContainingClass()) != null && "R".equals(r.getName()) && (type2 = ResourceType.getEnum((String)containingClass.getName())) != null) {
                for (ResourceType t : allowedValues.types) {
                    if (t != type2) continue;
                    return 1001;
                }
                return 1002;
            }
        } else if (expression instanceof PsiCallExpression) {
            resolved = ((PsiCallExpression)expression).resolveMethod();
        }
        if (resolved instanceof PsiModifierListOwner && (allowedForRef = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)resolved, type = ResourceTypeInspection.getType((PsiModifierListOwner)resolved), null)) != null && allowedForRef.types != null) {
            for (ResourceType t1 : allowedForRef.types) {
                for (ResourceType t2 : allowedValues.types) {
                    if (t1 != t2) continue;
                    return 1001;
                }
            }
            return 1002;
        }
        return 1003;
    }

    private static int isTypeAllowed(@NotNull AllowedValues allowedValues, @NotNull String typeName) {
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "isTypeAllowed"));
        }
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "org/jetbrains/android/inspections/ResourceTypeInspection", "isTypeAllowed"));
        }
        if (allowedValues.types != null) {
            for (ResourceType type : allowedValues.types) {
                if (type.getName().equals(typeName)) {
                    return 1001;
                }
                if (type != ResourceType.DRAWABLE || !ResourceType.COLOR.getName().equals(typeName)) continue;
                return 1001;
            }
        }
        return 1002;
    }

    private static PsiExpression getLiteralExpression(@NotNull PsiExpression context, @NotNull PsiManager manager, @NotNull String text) {
        PsiExpression expression;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/inspections/ResourceTypeInspection", "getLiteralExpression"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "getLiteralExpression"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/android/inspections/ResourceTypeInspection", "getLiteralExpression"));
        }
        Map cache = (Map)LITERAL_EXPRESSION_CACHE.get((UserDataHolder)manager);
        if (cache == null) {
            cache = ContainerUtil.createConcurrentSoftValueMap();
            cache = (Map)manager.putUserDataIfAbsent(LITERAL_EXPRESSION_CACHE, (Object)cache);
        }
        if ((expression = (PsiExpression)cache.get(text)) == null) {
            expression = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText(text, (PsiElement)context);
            cache.put(text, expression);
        }
        return expression;
    }

    private static boolean isOneOf(@NotNull PsiExpression expression, @NotNull AllowedValues allowedValues, @NotNull PsiManager manager) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/android/inspections/ResourceTypeInspection", "isOneOf"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "isOneOf"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "isOneOf"));
        }
        for (PsiAnnotationMemberValue allowedValue : allowedValues.values) {
            if (!ResourceTypeInspection.same((PsiElement)allowedValue, (PsiElement)expression, manager)) continue;
            return true;
        }
        return false;
    }

    private static boolean same(@Nullable PsiElement e1, @Nullable PsiElement e2, @NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "same"));
        }
        if (e1 instanceof PsiLiteralExpression && e2 instanceof PsiLiteralExpression) {
            return Comparing.equal((Object)((PsiLiteralExpression)e1).getValue(), (Object)((PsiLiteralExpression)e2).getValue());
        }
        if (e1 instanceof PsiPrefixExpression && e2 instanceof PsiPrefixExpression && ((PsiPrefixExpression)e1).getOperationTokenType() == ((PsiPrefixExpression)e2).getOperationTokenType()) {
            return ResourceTypeInspection.same((PsiElement)((PsiPrefixExpression)e1).getOperand(), (PsiElement)((PsiPrefixExpression)e2).getOperand(), manager);
        }
        if (e1 instanceof PsiReference && e2 instanceof PsiReference) {
            e1 = ((PsiReference)e1).resolve();
            e2 = ((PsiReference)e2).resolve();
        }
        return manager.areElementsEquivalent(e2, e1);
    }

    private static boolean processValuesFlownTo(@NotNull PsiExpression argument, @NotNull PsiElement scope, @NotNull PsiManager manager, @NotNull Processor<PsiExpression> processor) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection", "processValuesFlownTo"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/inspections/ResourceTypeInspection", "processValuesFlownTo"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "processValuesFlownTo"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/android/inspections/ResourceTypeInspection", "processValuesFlownTo"));
        }
        SliceAnalysisParams params = new SliceAnalysisParams();
        params.dataFlowToThis = true;
        params.scope = new AnalysisScope((SearchScope)new LocalSearchScope(scope), manager.getProject());
        SliceRootNode rootNode = new SliceRootNode(manager.getProject(), new DuplicateMap(), SliceUsage.createRootUsage((PsiElement)argument, (SliceAnalysisParams)params));
        Collection children = ((AbstractTreeNode)rootNode.getChildren().iterator().next()).getChildren();
        for (AbstractTreeNode child : children) {
            SliceUsage usage = (SliceUsage)child.getValue();
            PsiElement element = usage.getElement();
            if (!(element instanceof PsiExpression) || processor.process((Object)((PsiExpression)element))) continue;
            return false;
        }
        return !children.isEmpty();
    }

    static class AllowedValues {
        final PsiAnnotationMemberValue[] values;
        final boolean canBeOred;
        final List<ResourceType> types;

        private AllowedValues(@NotNull PsiAnnotationMemberValue[] values, boolean canBeOred, @Nullable List<ResourceType> types) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/android/inspections/ResourceTypeInspection$AllowedValues", "<init>"));
            }
            this.values = values;
            this.canBeOred = canBeOred;
            this.types = types;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllowedValues a2 = (AllowedValues)o;
            if (this.canBeOred != a2.canBeOred) {
                return false;
            }
            THashSet v1 = new THashSet(Arrays.asList(this.values));
            THashSet v2 = new THashSet(Arrays.asList(a2.values));
            if (v1.size() != v2.size()) {
                return false;
            }
            block0: for (PsiAnnotationMemberValue value : v1) {
                for (PsiAnnotationMemberValue value2 : v2) {
                    if (!ResourceTypeInspection.same((PsiElement)value, (PsiElement)value2, value.getManager())) continue;
                    v2.remove(value2);
                    continue block0;
                }
            }
            return v2.isEmpty();
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.values);
            result = 31 * result + (this.canBeOred ? 1 : 0);
            return result;
        }

        public boolean isSubsetOf(@NotNull AllowedValues other, @NotNull PsiManager manager) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/android/inspections/ResourceTypeInspection$AllowedValues", "isSubsetOf"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection$AllowedValues", "isSubsetOf"));
            }
            for (PsiAnnotationMemberValue value : this.values) {
                boolean found = false;
                for (PsiAnnotationMemberValue otherValue : other.values) {
                    if (!ResourceTypeInspection.same((PsiElement)value, (PsiElement)otherValue, manager)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
    }
}

